/*
 * Decompiled with CFR 0.152.
 */
package gui.tools.dialogs;

import com.ur.i18n.TextResource;
import com.ur.lang.EqualsUtil;
import com.ur.log.GoToLog;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.swing.URFingerDragScrollMouseListener;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.URDialogPanel;
import com.ur.swing.dialog.URDialogType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ExceptionDialogPanel
extends URDialogPanel {
    private final RobotMessage robotMessage;
    private JTextArea outputTextArea;
    private JLabel threadNameLabel;
    private GoToLog goToLog;
    private TextResource textResource;

    public ExceptionDialogPanel(Thread t, Throwable e, RobotMessage robotMessage, TextResource textResource) {
        this(t, e, robotMessage, textResource, null);
    }

    public ExceptionDialogPanel(Thread t, Throwable e, RobotMessage robotMessage, TextResource textResource, GoToLog goToLogService) {
        this.goToLog = goToLogService;
        this.robotMessage = robotMessage;
        this.textResource = textResource;
        this.initComponents();
        new URFingerDragScrollMouseListener((Component)this.outputTextArea);
        this.threadNameLabel.setText("Exception Caught in Thread " + t.getName());
        this.outputTextArea.setText(e + "\n");
        this.outputTextArea.append("-----------------\n");
        this.appendStackTrace(e);
        Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
        if (cause != null) {
            this.outputTextArea.append("-----------------\n");
            this.outputTextArea.append("Cause: " + cause);
            this.appendStackTrace(cause);
        }
    }

    private void appendStackTrace(Throwable e) {
        StackTraceElement[] stackTraceElement;
        StackTraceElement[] stackTraceElementArray = stackTraceElement = e.getStackTrace();
        int n = stackTraceElement.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement aStackTraceElement = stackTraceElementArray[n2];
            this.outputTextArea.append(String.valueOf(aStackTraceElement.toString()) + "\n");
            ++n2;
        }
    }

    String getThreadText() {
        return this.threadNameLabel.getText();
    }

    String getStacktraceText() {
        return this.outputTextArea.getText();
    }

    public JPanel getPanel() {
        return this;
    }

    public URDialogType getDialogType() {
        return URDialogType.EXCEPTION;
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        JButton jButton1 = new JButton();
        this.outputTextArea = new JTextArea();
        this.threadNameLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.outputTextArea.setColumns(66);
        this.outputTextArea.setEditable(false);
        this.outputTextArea.setRows(20);
        jScrollPane1.setViewportView(this.outputTextArea);
        jPanel1.add(jScrollPane1);
        this.add(jPanel1, "Center");
        this.threadNameLabel.setText("jLabel2");
        jPanel2.add(this.threadNameLabel);
        this.add(jPanel2, "North");
        jPanel3.setLayout(new FlowLayout(2));
        if (this.robotMessage != null && this.robotMessage.getAttachment() != null) {
            JPanel flightRecorderStatusPanel = new JPanel();
            JLabel errorReportStatusLabel = new JLabel();
            String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
            String timeStamp = new SimpleDateFormat(DATE_FORMAT).format(new Date());
            errorReportStatusLabel.setText(this.textResource.reportGeneratedInfoLine(timeStamp));
            flightRecorderStatusPanel.add(errorReportStatusLabel);
            if (this.goToLog != null) {
                JButton goToLogButton = new JButton(this.textResource.saveLog());
                goToLogButton.setEnabled(this.goToLog.canGoTo());
                goToLogButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ExceptionDialogPanel.this.goToLog.goTo((Object)ExceptionDialogPanel.this.robotMessage);
                        ExceptionDialogPanel.this.setReturnValueAndClose(DialogReturnValue.CLOSE);
                    }
                });
                flightRecorderStatusPanel.add(goToLogButton);
            }
            jPanel3.add(flightRecorderStatusPanel);
        }
        jButton1.setText(this.textResource.Close());
        jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExceptionDialogPanel.this.jButton1ActionPerformed();
            }
        });
        jPanel3.add(jButton1);
        this.add(jPanel3, "South");
    }

    private void jButton1ActionPerformed() {
        this.setReturnValueAndClose(DialogReturnValue.CLOSE);
    }

    public int hashCode() {
        int hashCode = this.threadNameLabel.getText().hashCode() - this.outputTextArea.getText().hashCode();
        if (this.robotMessage != null) {
            hashCode -= this.robotMessage.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExceptionDialogPanel)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (EqualsUtil.equalsType((Object)obj, (Object)((Object)this))) {
            ExceptionDialogPanel other = (ExceptionDialogPanel)((Object)obj);
            return EqualsUtil.equals((Object)this.threadNameLabel.getText(), (Object)other.threadNameLabel.getText()) && EqualsUtil.equals((Object)this.outputTextArea.getText(), (Object)other.outputTextArea.getText()) && EqualsUtil.equals((Object)this.robotMessage, (Object)other.robotMessage);
        }
        return false;
    }
}

