/*
 * Decompiled with CFR 0.152.
 */
package gui.tools.dialogs;

import com.ur.i18n.TextResource;
import com.ur.polyscope.geomfeature.ProgramFeatureService;
import com.ur.polyscope.immi.Immi;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.swing.expression.field.ExpressionContentProvider;
import com.ur.swing.expression.field.ExpressionEditorJTextField;
import com.ur.swing.expression.field.ExpressionInserter;
import com.ur.view.variables.domain.VariableLookupService;
import gui.installation.RobotInstallationLookupService;
import gui.installation.services.ProgramLookupService;
import gui.swing.renderers.ExpressionFeatureRenderingStrategy;
import gui.tools.ExpressionFunctionComboBoxContent;
import gui.tools.dialogs.ComboBoxRenderingStrategy;
import gui.tools.dialogs.ExpressionIOProvider;
import gui.tools.dialogs.ExpressionPoseComboBoxModel;
import gui.tools.dialogs.ExpressionVariableComboBoxModel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class ExpressionContentProviderImpl
implements ExpressionContentProvider {
    private ExpressionIOProvider ioService;
    private final VariableLookupService variableLookupService;
    private ProgramLookupService programLookupService;
    private RobotInstallationLookupService lookupService;
    private ExpressionFunctionComboBoxContent functionContent;
    private ProgramFeatureService programFeatureService;
    private TextResource textResource;
    private final InstallationComponentLookup installationComponentLookup;
    private final ExpressionInserter expressionInserter;

    @Inject
    public ExpressionContentProviderImpl(ExpressionIOProvider ioService, VariableLookupService variableLookupService, ProgramLookupService programLookupService, RobotInstallationLookupService lookupService, ExpressionFunctionComboBoxContent functionContent, ProgramFeatureService programFeatureService, InstallationComponentLookup installationComponentLookup, ExpressionInserter expressionInserter, TextResource textResource) {
        this.ioService = ioService;
        this.variableLookupService = variableLookupService;
        this.programLookupService = programLookupService;
        this.lookupService = lookupService;
        this.functionContent = functionContent;
        this.programFeatureService = programFeatureService;
        this.installationComponentLookup = installationComponentLookup;
        this.expressionInserter = expressionInserter;
        this.textResource = textResource;
    }

    public boolean longIONames() {
        return this.installationComponentLookup != null ? ((Immi)this.installationComponentLookup.getComponent(Immi.class)).isEnabled() : false;
    }

    public JComboBox poseSelection(ExpressionEditorJTextField textField, boolean isDoubleWidth) {
        WideComboBox result = new WideComboBox();
        result.setRenderer(new ComboBoxRenderingStrategy(isDoubleWidth, new ExpressionFeatureRenderingStrategy()));
        result.setModel(this.getPoses());
        this.bindTextFieldToComboBox(textField, result);
        return result;
    }

    public JComboBox functionSelection(ExpressionEditorJTextField textField, boolean isDoubleWidth) {
        WideComboBox result = new WideComboBox();
        result.setRenderer(new ComboBoxRenderingStrategy(isDoubleWidth));
        result.setModel(this.getFunctions());
        this.bindTextFieldToComboBox(textField, result);
        return result;
    }

    public JComboBox inputSelection(ExpressionEditorJTextField textField, boolean isDoubleWidth) {
        WideComboBox result = new WideComboBox();
        result.setRenderer(new ComboBoxRenderingStrategy(isDoubleWidth));
        result.setModel(this.getInputs());
        this.bindTextFieldToComboBox(textField, result);
        return result;
    }

    public JComboBox outputSelection(ExpressionEditorJTextField textField, boolean isDoubleWidth) {
        WideComboBox result = new WideComboBox();
        result.setRenderer(new ComboBoxRenderingStrategy(isDoubleWidth));
        result.setModel(this.getOutputs());
        this.bindTextFieldToComboBox(textField, result);
        return result;
    }

    public JComboBox variableSelection(final ExpressionEditorJTextField textField, boolean isDoubleWidth) {
        final WideComboBox result = new WideComboBox();
        result.setRenderer(new ComboBoxRenderingStrategy(false));
        result.setModel(this.getVariables());
        result.setSelectedIndex(0);
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (result.getSelectedItem() != null && result.getSelectedIndex() > 0) {
                    Object selected = result.getSelectedItem();
                    ExpressionContentProviderImpl.this.expressionInserter.insertObjectOnSelect(textField, selected);
                    result.setSelectedIndex(0);
                    textField.updateInputTextField();
                    textField.requestFocus();
                }
            }
        });
        return result;
    }

    private void bindTextFieldToComboBox(final ExpressionEditorJTextField textField, final JComboBox result) {
        result.setSelectedIndex(0);
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (result.getSelectedItem() != null && result.getSelectedIndex() > 0) {
                    Object selected = result.getSelectedItem();
                    ExpressionContentProviderImpl.this.expressionInserter.insertObjectOnBind(textField, selected);
                    result.setSelectedIndex(0);
                    textField.updateInputTextField();
                    textField.requestFocus();
                }
            }
        });
    }

    public DefaultComboBoxModel getInputs() {
        DefaultComboBoxModel<Pin> result = new DefaultComboBoxModel<Pin>(this.ioService.getInputs());
        result.insertElementAt((Pin)this.textResource.tokenInputAbbrev(), 0);
        return result;
    }

    public DefaultComboBoxModel getOutputs() {
        DefaultComboBoxModel<Pin> result = new DefaultComboBoxModel<Pin>(this.ioService.getOutputs());
        result.insertElementAt((Pin)this.textResource.tokenOutputAbbrev(), 0);
        return result;
    }

    public DefaultComboBoxModel getVariables() {
        return new ExpressionVariableComboBoxModel(this.variableLookupService, this.textResource);
    }

    public DefaultComboBoxModel getPoses() {
        return new ExpressionPoseComboBoxModel(this.lookupService, this.programFeatureService, this.programLookupService, this.textResource);
    }

    public DefaultComboBoxModel getFunctions() {
        CustomComboModel model = new CustomComboModel();
        model.addElement(this.textResource.placeholderFunction());
        String[] stringArray = this.functionContent.getFunctionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            model.addElement(element);
            ++n2;
        }
        for (Map.Entry<ExpressionFunctionComboBoxContent.UrCapHeading, List<String>> entry : this.functionContent.getUrCapVendorFunctionMap().entrySet()) {
            model.addElement(entry.getKey());
            for (String function : entry.getValue()) {
                model.addElement(function);
            }
        }
        return model;
    }

    private class CustomComboModel
    extends DefaultComboBoxModel {
        private CustomComboModel() {
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject instanceof ExpressionFunctionComboBoxContent.UrCapHeading) {
                return;
            }
            if (anObject != null && ExpressionContentProviderImpl.this.functionContent.getSeparator().equals(anObject.toString())) {
                return;
            }
            super.setSelectedItem(anObject);
        }
    }

    static class WideComboBox
    extends JComboBox {
        private boolean layingOut = false;

        WideComboBox() {
        }

        @Override
        public void doLayout() {
            try {
                this.layingOut = true;
                super.doLayout();
            }
            finally {
                this.layingOut = false;
            }
        }

        @Override
        public Dimension getSize() {
            Dimension dim = super.getSize();
            if (!this.layingOut) {
                dim.width = Math.max(dim.width, this.getPreferredSize().width);
            }
            return dim;
        }
    }
}

