/*
 * Decompiled with CFR 0.152.
 */
package gui.tools.dialogs;

import com.ur.i18n.TextResource;
import com.ur.move.PositionReference;
import com.ur.polyscope.geomfeature.ProgramFeatureService;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.swing.renderers.contributed.ContributedHeading;
import gui.geom.CameraView;
import gui.installation.RobotInstallationLookupService;
import gui.installation.services.ProgramLookupService;
import gui.polyscope.setup.treenodes.geom.GeomPoseNodeContributed;
import gui.program.ProgramRootNode;
import gui.program.position.WaypointNode;
import gui.tools.util.FeatureComboBoxHelper;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;

class ExpressionPoseComboBoxModel
extends DefaultComboBoxModel {
    private final ProgramLookupService programLookupService;

    ExpressionPoseComboBoxModel(RobotInstallationLookupService lookupService, ProgramFeatureService programFeatureService, ProgramLookupService programLookupService, TextResource textResource) {
        this.programLookupService = programLookupService;
        this.addElement(textResource.placeholderPose());
        this.addPositions();
        List<GeomFeature> selectableFeatures = FeatureComboBoxHelper.getSelectableFeatures(lookupService, programFeatureService);
        this.addNonContributedFeatures(selectableFeatures);
        this.addContributedFeatures(selectableFeatures);
    }

    private void addPositions() {
        Set<PositionReference> prSet = this.findAllPositionReferencesInTree(this.programLookupService.getProgramRootNode());
        HashMap<String, PositionReference> uniquePRNameMap = new HashMap<String, PositionReference>();
        for (PositionReference pr : prSet) {
            WaypointNode wpn;
            if (pr.isUndefined() || uniquePRNameMap.containsKey(pr.getName()) || pr instanceof WaypointNode && (wpn = (WaypointNode)pr).getPositionNodeType() == PositionNodeType.VARIABLE) continue;
            uniquePRNameMap.put(pr.getName(), pr);
        }
        TreeSet<PositionReference> sortedPositions = new TreeSet<PositionReference>(new ValueComparator());
        sortedPositions.addAll(uniquePRNameMap.values());
        for (PositionReference pr : sortedPositions) {
            this.addElement(pr);
        }
    }

    private void addContributedFeatures(List<GeomFeature> selectableFeatures) {
        Map<ContributedHeading, List<GeomPoseNodeContributed>> contributedMap = FeatureComboBoxHelper.createContributedMap(selectableFeatures);
        for (Map.Entry<ContributedHeading, List<GeomPoseNodeContributed>> entry : contributedMap.entrySet()) {
            this.addElement(entry.getKey());
            for (GeomPoseNodeContributed contributed : entry.getValue()) {
                this.addElement(contributed);
            }
        }
    }

    private void addNonContributedFeatures(List<GeomFeature> selectableFeatures) {
        List<GeomFeature> nonContributedFeatures = FeatureComboBoxHelper.getNonContributedFeatures(selectableFeatures);
        for (GeomFeature each : nonContributedFeatures) {
            if (each.isUndefined() || each instanceof CameraView) continue;
            this.addElement(each);
        }
    }

    private Set<PositionReference> findAllPositionReferencesInTree(ProgramRootNode root) {
        HashSet<PositionReference> result = new HashSet<PositionReference>();
        if (root != null) {
            Enumeration e = root.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                AbstractProgramNode wpCandidate = (AbstractProgramNode)e.nextElement();
                if (!(wpCandidate instanceof PositionReference)) continue;
                result.add((PositionReference)wpCandidate);
            }
        }
        return result;
    }

    private static class ValueComparator
    implements Comparator<PositionReference>,
    Serializable {
        private ValueComparator() {
        }

        @Override
        public int compare(PositionReference a, PositionReference b) {
            return a.getName().compareTo(b.getName());
        }
    }
}

