/*
 * Decompiled with CFR 0.152.
 */
package gui.tools.dialogs;

import com.ur.i18n.TextResource;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.swing.renderers.contributed.ContributedHeading;
import com.ur.view.variables.core.Variable;
import com.ur.view.variables.core.VariableSet;
import com.ur.view.variables.domain.VariableLookupService;
import gui.polyscope.setup.treenodes.geom.GeomPoseNodeContributed;
import gui.program.services.GeomFeatureVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;

class ExpressionVariableComboBoxModel
extends DefaultComboBoxModel {
    ExpressionVariableComboBoxModel(VariableLookupService variableLookupService, TextResource textResource) {
        this.addElement(textResource.placeholderVariable());
        VariableSet vs = variableLookupService.getAllProgramAndInstallationVariables();
        ArrayList<Variable> features = new ArrayList<Variable>();
        for (Variable each : vs) {
            if (each instanceof GeomFeatureVariable) {
                features.add(each);
                continue;
            }
            this.addElement(each);
        }
        HashMap<ContributedHeading, List<GeomPoseNodeContributed>> contributedMap = new HashMap<ContributedHeading, List<GeomPoseNodeContributed>>();
        for (Variable variable : features) {
            String name = variable.getName();
            SpatialFeature feature = variableLookupService.featureByName(name);
            if (feature == null) continue;
            if (feature instanceof GeomPoseNodeContributed) {
                this.collectContributedNode(contributedMap, (GeomPoseNodeContributed)feature);
                continue;
            }
            this.addElement(feature);
        }
        for (Map.Entry entry : contributedMap.entrySet()) {
            this.addElement(entry.getKey());
            for (GeomPoseNodeContributed contributed : (List)entry.getValue()) {
                this.addElement(contributed);
            }
        }
    }

    private void collectContributedNode(Map<ContributedHeading, List<GeomPoseNodeContributed>> contributedMap, GeomPoseNodeContributed feature) {
        ContributedHeading heading = new ContributedHeading(feature.getContributorInfo().getOwnerDisplayName());
        List<GeomPoseNodeContributed> poses = contributedMap.get(heading);
        if (poses == null) {
            poses = new ArrayList<GeomPoseNodeContributed>();
            contributedMap.put(heading, poses);
        }
        poses.add(feature);
    }
}

