/*
 * Decompiled with CFR 0.152.
 */
package gui.tools.dialogs;

import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.resources.ViewImageResource;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.URDialogPanel;
import com.ur.swing.dialog.URDialogType;
import com.ur.util.swing.HTML;
import gui.tools.LanguagePack;
import gui.tools.dialogs.MessageDialogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class MessageDialogPanel
extends URDialogPanel {
    public static final String LEFT_BUTTON = "leftArrowKey.MessageDialogPanel";
    public static final String RIGHT_BUTTON = "rightArrowKey.MessageDialogPanel";
    public static final String DETAILS_BOTTOM_PANEL = "detailPanelBottom.MessageDialogPanel";
    public static final String DETAILS_TOP_PANEL = "detailPanelTop.MessageDialogPanel";
    public static final String SHOW_DETAILS_LABEL = "showDetailsLabel.MessageDialogPanel";
    public static final String MESSAGE_LABEL = "messageLabel.MessageDialogPanel";
    public static final String DETAILS_BELOW = "detailsBelow.MessageDialogPanel";
    private static final int MARGIN = 15;
    private JButton leftButton = new JButton();
    private JButton rightButton = new JButton();
    private JLabel messageLabel = new JLabel();
    private JLabel detailsLabel = new JLabel();
    private JLabel showDetailsLabel = new JLabel();
    private JLabel errorReportStatusLabel = new JLabel();
    private JPanel detailsTopPanel = new JPanel();
    private JPanel detailsBottomPanel = new JPanel();
    private JPanel bottomPanel;
    private Runnable rightButtonAction = null;
    private boolean useLegacyReturnValues = false;
    private JPanel linePanel;

    public MessageDialogPanel(String message, MessageDialogType messageType) {
        this(message, messageType, true, false);
    }

    public MessageDialogPanel(String explanation, String suggestion, MessageDialogType messageType) {
        this(String.valueOf(HTML.p((String)explanation)) + HTML.br() + HTML.p((String)HTML.fontBold((String)suggestion)), messageType, true, false);
    }

    public MessageDialogPanel(String message, MessageDialogType messageType, boolean showContinueProgramButton, boolean showStopProgramButton) {
        this.useLegacyReturnValues = true;
        this.initComponents(messageType, message == null ? "" : message, 300);
        this.leftButton.setVisible(showStopProgramButton);
        this.rightButton.setVisible(showContinueProgramButton);
    }

    public MessageDialogPanel(MessageDialogType messageType, String message, String leftButtonText, String rightButtonText) {
        this(messageType, leftButtonText, new DialogParameters(message, null, null, "", rightButtonText, null));
    }

    private MessageDialogPanel(MessageDialogType messageType, String leftButtonText, DialogParameters dialogParameters) {
        String message = dialogParameters.message;
        Map detailsAboveButtons1 = dialogParameters.scriptError;
        Map detailsAboveButtons2 = dialogParameters.urCapInfo;
        String detailsBelowButtons = dialogParameters.detailsBelowButtons;
        String rightButtonText = dialogParameters.actionText;
        int maxWidth = 500;
        this.initComponents(messageType, message == null ? "" : message, maxWidth);
        this.addToDetailsTop(detailsAboveButtons1, detailsAboveButtons2);
        this.detailsTopPanel.setVisible(detailsAboveButtons1 != null && !detailsAboveButtons1.isEmpty());
        this.leftButton.setVisible(!StringUtils.isNullOrEmpty((String)leftButtonText));
        this.leftButton.setText(leftButtonText);
        this.rightButton.setVisible(!StringUtils.isNullOrEmpty((String)rightButtonText));
        this.rightButton.setText(rightButtonText);
        if (detailsBelowButtons != null) {
            String truncated = HTML.truncateLongWordsWithDots((double)maxWidth, (String)detailsBelowButtons);
            if (!HTML.isHtml((String)truncated)) {
                truncated = HTML.convertToHtml((String)truncated);
            }
            this.detailsLabel.setText(HTML.html((String)truncated));
            if (this.detailsLabel.getPreferredSize().width > maxWidth) {
                this.detailsLabel.setText(HTML.html((String)HTML.maxWidth((int)maxWidth, (String)truncated)));
            }
        }
        this.bottomPanel.setVisible(!StringUtils.isNullOrEmpty((String)detailsBelowButtons));
        this.rightButtonAction = dialogParameters.action;
        if (this.bottomPanel.isVisible()) {
            this.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        }
        this.setDetailsVisible(false);
    }

    private void addToDetailsTop(Map<String, String> detailsAboveButtons1, Map<String, String> detailsAboveButtons2) {
        if (detailsAboveButtons1 == null) {
            return;
        }
        GridBagConstraints gb = new GridBagConstraints();
        gb.anchor = 23;
        int row = 0;
        for (Map.Entry<String, String> label : detailsAboveButtons1.entrySet()) {
            this.addLabelEntryToDetailsTop(label, ++row, gb);
        }
        if (detailsAboveButtons2 != null && !detailsAboveButtons2.isEmpty()) {
            this.addEmptyCell(++row, gb);
            for (Map.Entry<String, String> label : detailsAboveButtons2.entrySet()) {
                this.addLabelEntryToDetailsTop(label, ++row, gb);
            }
        }
    }

    private void addEmptyCell(int row, GridBagConstraints gb) {
        gb.gridx = 0;
        gb.gridy = row;
        gb.fill = 0;
        gb.weightx = 0.0;
        this.detailsTopPanel.add((Component)new JLabel(" "), gb);
        gb.gridx = 1;
        gb.fill = 2;
        gb.weightx = 1.0;
        this.detailsTopPanel.add((Component)new JLabel(" "), gb);
    }

    private void addLabelEntryToDetailsTop(Map.Entry<String, String> label, int row, GridBagConstraints gb) {
        gb.gridx = 0;
        gb.gridy = row;
        gb.fill = 0;
        gb.weightx = 0.0;
        JLabel title = new JLabel();
        title.setText(HTML.html((String)HTML.maxWidth((int)130, (String)label.getKey())));
        title.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        title.setVerticalAlignment(1);
        this.detailsTopPanel.add((Component)title, gb);
        gb.gridx = 1;
        gb.fill = 2;
        gb.weightx = 1.0;
        JLabel value = new JLabel();
        value.setText(HTML.html((String)HTML.maxWidth((int)350, (String)HTML.convertToHtml((String)HTML.truncateTextWithDots((double)460.0, (String)label.getValue())))));
        value.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        value.setVerticalAlignment(1);
        this.detailsTopPanel.add((Component)value, gb);
    }

    public JPanel getPanel() {
        return this;
    }

    public URDialogType getDialogType() {
        return URDialogType.MESSAGE;
    }

    public void setOKButtonText(String text) {
        this.rightButton.setText(text);
    }

    private JPanel joinComponentsVertical(Component ... components) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            jPanel.add(c);
            ++n2;
        }
        return jPanel;
    }

    private JPanel wrapLabelToPanel(JLabel jLabel, String alignment) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, alignment);
        return jPanel;
    }

    public void setShowDetailsLabel(String text) {
        this.showDetailsLabel.setText(text);
    }

    public void setRobotMessage(RobotMessage robotMessage) {
        if (robotMessage.getAttachment() != null) {
            this.errorReportStatusLabel.setText(LanguagePack.getTextResource().reportGeneratedInfoLine(robotMessage.getAttachment().getId()));
            this.errorReportStatusLabel.setVisible(true);
            this.resizeAndRepositionParentWindow();
        }
    }

    private void initComponents(MessageDialogType messageType, String message, int maxWidth) {
        this.messageLabel.setName(MESSAGE_LABEL);
        this.messageLabel.setMinimumSize(new Dimension(119, 15));
        this.setLayout(new BorderLayout());
        this.messageLabel.setVerticalTextPosition(1);
        this.messageLabel.setHorizontalAlignment(4);
        JPanel messagePanel = new JPanel(new FlowLayout(0, 0, 0));
        messagePanel.add(this.messageLabel);
        this.add(messagePanel, "First");
        JPanel flightRecorderStatusPanel = new JPanel();
        this.errorReportStatusLabel.setVisible(false);
        flightRecorderStatusPanel.add(this.errorReportStatusLabel);
        JPanel buttonPanel = new JPanel();
        this.leftButton.setName(LEFT_BUTTON);
        this.leftButton.setText(LanguagePack.getTextResource().stopProgram());
        this.leftButton.setVisible(false);
        this.leftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageDialogPanel.this.leftButtonActionPerformed();
            }
        });
        buttonPanel.add(this.leftButton);
        this.rightButton.setName(RIGHT_BUTTON);
        this.rightButton.setText(LanguagePack.getTextResource().OK());
        this.rightButton.setVisible(false);
        this.rightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageDialogPanel.this.rightButtonActionPerformed();
            }
        });
        buttonPanel.add(this.rightButton);
        this.showDetailsLabel.setText(LanguagePack.getTextResource().AdvancedViewScript());
        this.showDetailsLabel.setName(SHOW_DETAILS_LABEL);
        this.showDetailsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MessageDialogPanel.this.setDetailsVisible(!MessageDialogPanel.this.isDetailsVisible());
                MessageDialogPanel.this.resizeAndRepositionParentWindow();
            }
        });
        JSeparator line = new JSeparator();
        this.linePanel = new JPanel(new BorderLayout());
        this.linePanel.add(line);
        this.linePanel.setBorder(BorderFactory.createEmptyBorder(7, 5, 3, 0));
        JPanel showDetailsPanel = new JPanel(new BorderLayout());
        showDetailsPanel.add((Component)this.showDetailsLabel, "Before");
        showDetailsPanel.add(this.linePanel);
        showDetailsPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 0, 15));
        this.detailsTopPanel.setName(DETAILS_TOP_PANEL);
        this.detailsTopPanel.setBorder(BorderFactory.createEmptyBorder(15, 15 + MessageDialogUtils.getIconByType(MessageDialogType.WARNING).getIconWidth() + this.messageLabel.getIconTextGap(), 15, 15));
        this.detailsTopPanel.setLayout(new GridBagLayout());
        this.detailsTopPanel.setVisible(false);
        this.detailsLabel.setName(DETAILS_BELOW);
        this.detailsBottomPanel = this.wrapLabelToPanel(this.detailsLabel, "Before");
        this.detailsBottomPanel.setBorder(BorderFactory.createEmptyBorder(15, MessageDialogUtils.getIconByType(MessageDialogType.WARNING).getIconWidth() + this.messageLabel.getIconTextGap(), 0, 0));
        this.detailsBottomPanel.setName(DETAILS_BOTTOM_PANEL);
        this.bottomPanel = this.joinComponentsVertical(showDetailsPanel, this.detailsBottomPanel);
        this.bottomPanel.setVisible(false);
        this.add(this.joinComponentsVertical(this.detailsTopPanel, flightRecorderStatusPanel, buttonPanel, this.bottomPanel), "South");
        this.setBorder(BorderFactory.createEmptyBorder(15, 15, 0, 15));
        this.messageLabel.setIcon(MessageDialogUtils.getIconByType(messageType));
        this.messageLabel.setText(HTML.html((String)HTML.maxWidth((int)maxWidth, (String)HTML.truncateLongWordsWithDots((double)maxWidth, (String)message))));
    }

    private void setDetailsVisible(boolean visible) {
        this.showDetailsLabel.setIcon(visible ? ViewImageResource.collapseIcon1212() : ViewImageResource.expandIcon1212());
        this.linePanel.setVisible(visible);
        this.detailsBottomPanel.setVisible(visible);
    }

    private boolean isDetailsVisible() {
        return this.detailsBottomPanel.isVisible();
    }

    private void leftButtonActionPerformed() {
        DialogReturnValue returnValue = this.useLegacyReturnValues ? DialogReturnValue.STOP_PROGRAM : DialogReturnValue.LEFT_BUTTON;
        this.setReturnValueAndClose(returnValue);
    }

    private void rightButtonActionPerformed() {
        DialogReturnValue returnValue = this.useLegacyReturnValues ? DialogReturnValue.OK : DialogReturnValue.RIGHT_BUTTON;
        this.setReturnValueAndClose(returnValue);
        if (this.rightButtonAction != null) {
            SwingUtilities.invokeLater(this.rightButtonAction);
        }
    }

    public int hashCode() {
        return this.messageLabel.getText().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (EqualsUtil.equalsType((Object)obj, (Object)((Object)this))) {
            MessageDialogPanel other = (MessageDialogPanel)((Object)obj);
            return EqualsUtil.equals((Object)other.messageLabel.getText(), (Object)this.messageLabel.getText());
        }
        return false;
    }

    public static MessageDialogPanel createWarningDialog(DialogParameters dialogParameters) {
        String okButton = LanguagePack.getTextResource().OK();
        return new MessageDialogPanel(MessageDialogType.WARNING, okButton, dialogParameters);
    }

    public static MessageDialogPanel createWarningDialog(String message, Map<String, String> detailsAboveButtons, String detailsBelowButtons, String actionText, Runnable action) {
        String okButton = LanguagePack.getTextResource().OK();
        return new MessageDialogPanel(MessageDialogType.WARNING, okButton, new DialogParameters(message, detailsAboveButtons, null, detailsBelowButtons, actionText, action));
    }

    public static MessageDialogPanel createWarningDialog(String message, Map<String, String> detailsAboveButtons, String detailsBelowButtons, String actionText, Runnable action, String showDetailsLabel) {
        String okButton = LanguagePack.getTextResource().OK();
        MessageDialogPanel messageDialogPanel = new MessageDialogPanel(MessageDialogType.WARNING, okButton, new DialogParameters(message, detailsAboveButtons, null, detailsBelowButtons, actionText, action));
        messageDialogPanel.setShowDetailsLabel(showDetailsLabel);
        return messageDialogPanel;
    }

    public static MessageDialogPanel createWarningDialog(String message, Map<String, String> detailsAboveButtons, String detailsBelowButtons, String actionText, Runnable action, String showDetailsLabel, RobotMessage robotMessage) {
        MessageDialogPanel panel = MessageDialogPanel.createWarningDialog(message, detailsAboveButtons, detailsBelowButtons, actionText, action, showDetailsLabel);
        panel.setRobotMessage(robotMessage);
        return panel;
    }

    public static class DialogParameters {
        private String message = "";
        private Map<String, String> scriptError = new LinkedHashMap<String, String>();
        private Map<String, String> urCapInfo = new LinkedHashMap<String, String>();
        private String detailsBelowButtons = "";
        private String actionText = "";
        private Runnable action = null;

        public DialogParameters(String message, Map<String, String> scriptError, Map<String, String> urCapInfo, String detailsBelowButtons, String actionText, Runnable action) {
            this.message = message;
            this.scriptError = scriptError;
            this.urCapInfo = urCapInfo;
            this.detailsBelowButtons = detailsBelowButtons;
            this.actionText = actionText;
            this.action = action;
        }
    }
}

