/*
 * Decompiled with CFR 0.152.
 */
package gui.tools.dialogs;

import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.WidgetFactory;
import com.ur.swing.baseview.BaseAccordionView;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.MultiPaneMessagePanelFactory;
import com.ur.swing.dialog.URDialogPanel;
import com.ur.swing.dialog.URDialogType;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.view.Settings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

class MultiPaneMessagePanel
extends URDialogPanel {
    private static final String CONTENT_PANEL = "content.confirmMessageDialog";
    private static final String NAVIGATION_PANEL = "navigation.confirmMessageDialog";
    private final WidgetFactory widgetFactory;
    private final BaseAccordionView navigation;
    private JPanel navigationPanel;
    private JPanel contentPanel;
    private JPanel buttonPanel;

    MultiPaneMessagePanel(WidgetFactory widgetFactory, BaseAccordionView baseAccordionView, Iterable<MultiPaneMessagePanelFactory.Pane> panes, String confirmButtonText) {
        this.widgetFactory = widgetFactory;
        this.navigation = baseAccordionView;
        this.navigation.setLanguage(Settings.getLanguage());
        this.initializePanel(panes, confirmButtonText);
    }

    MultiPaneMessagePanel(WidgetFactory widgetFactory, BaseAccordionView baseAccordionView, Iterable<MultiPaneMessagePanelFactory.Pane> panes, String confirmButtonText, String cancelButtonText) {
        this.widgetFactory = widgetFactory;
        this.navigation = baseAccordionView;
        this.navigation.setLanguage(Settings.getLanguage());
        this.initializePanel(panes, confirmButtonText);
        this.addCancelButton(cancelButtonText);
    }

    JPanel getNavigationPanel() {
        return this.navigation;
    }

    JPanel getContentPanel() {
        return this.contentPanel;
    }

    public JPanel getPanel() {
        return this;
    }

    public URDialogType getDialogType() {
        return URDialogType.MULTI_PANE_MESSAGE;
    }

    private void initializePanel(Iterable<MultiPaneMessagePanelFactory.Pane> panes, String confirmButtonText) {
        this.initComponents();
        this.buildNavigation(panes);
        this.addConfirmButton(confirmButtonText);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, G5LookAndFeel.BETWEEN_CARD_COLOR));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.navigationPanel = new JPanel();
        this.add(this.navigationPanel, "West");
        this.contentPanel = new JPanel(new CardLayout());
        this.contentPanel.setName(CONTENT_PANEL);
        this.add(this.contentPanel, "Center");
        this.buttonPanel = new JPanel();
        this.add(this.buttonPanel, "South");
    }

    private void buildNavigation(Iterable<MultiPaneMessagePanelFactory.Pane> panes) {
        this.navigation.setName(NAVIGATION_PANEL);
        for (MultiPaneMessagePanelFactory.Pane each : panes) {
            String title = each.getTitle();
            JComponent panel = each.getContent();
            this.contentPanel.add((Component)panel, title);
            SwitchContentAction button = new SwitchContentAction(title);
            this.navigation.addItem((Action)button);
            this.navigation.fitSizeToButtons();
        }
        this.navigationPanel.add((Component)this.navigation);
    }

    private void addConfirmButton(String confirmButtonText) {
        JButton confirmationButton = this.widgetFactory.createButton((Action)new AbstractActionDefinition(confirmButtonText){
            {
                this.putValue("InternalName", "confirm.confirmMessageDialog");
                this.putValue("Name", string);
                this.putValue("Function", ActionDefinition.Function.PRIMARY);
            }

            public void actionPerformed(ActionEvent e) {
                MultiPaneMessagePanel.this.setReturnValueAndClose(DialogReturnValue.OK);
            }
        });
        this.buttonPanel.add(confirmationButton);
    }

    private void addCancelButton(String cancelButtonText) {
        JButton cancelButton = this.widgetFactory.createButton((Action)new AbstractActionDefinition(cancelButtonText){
            {
                this.putValue("InternalName", "cancel.confirmMessageDialog");
                this.putValue("Name", string);
                this.putValue("Function", ActionDefinition.Function.SECONDARY);
            }

            public void actionPerformed(ActionEvent e) {
                MultiPaneMessagePanel.this.setReturnValueAndClose(DialogReturnValue.CANCEL);
            }
        });
        this.buttonPanel.add(cancelButton);
    }

    private class SwitchContentAction
    extends AbstractAction {
        private final String panelName;

        SwitchContentAction(String panelName) {
            this.panelName = panelName;
            this.putValue("Name", panelName);
            this.putValue("InternalName", panelName);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CardLayout cardLayout = (CardLayout)MultiPaneMessagePanel.this.contentPanel.getLayout();
            cardLayout.show(MultiPaneMessagePanel.this.contentPanel, this.panelName);
        }
    }
}

