/*
 * Decompiled with CFR 0.152.
 */
package gui.tools.dialogs;

import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.OptionMessage;
import com.ur.swing.dialog.URDialogPanel;
import com.ur.swing.dialog.URDialogType;
import com.ur.util.swing.HTML;
import gui.tools.LanguagePack;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OptionMessageDialogPanel
extends URDialogPanel {
    public static final String OPTION_1_BUTTON = "option.1.optionMessageDialog";
    public static final String OPTION_2_BUTTON = "option.2.optionMessageDialog";
    public static final String CANCEL_BUTTON = "cancel.optionMessageDialog";
    private final OptionMessage optionMessage;
    private final JButton option1Button;
    private final JButton option2Button;
    private final JButton cancelButton;
    private final String message;

    public OptionMessageDialogPanel(OptionMessage optionMessage) {
        this.optionMessage = optionMessage;
        this.message = HTML.html((String)HTML.maxWidth((int)400, (String)optionMessage.getMessage()));
        this.option1Button = new JButton();
        this.option2Button = new JButton();
        this.cancelButton = new JButton();
        this.initComponents();
        this.option1Button.setName(OPTION_1_BUTTON);
        this.option2Button.setName(OPTION_2_BUTTON);
        this.cancelButton.setName(CANCEL_BUTTON);
    }

    public JPanel getPanel() {
        return this;
    }

    public URDialogType getDialogType() {
        return URDialogType.OPTION;
    }

    private void initComponents() {
        JPanel iconPanel = new JPanel();
        JLabel iconLabel = new JLabel();
        JPanel messagePanel = new JPanel();
        JLabel messageLabel = new JLabel();
        JPanel buttonPanel = new JPanel();
        this.setLayout(new BorderLayout());
        iconLabel.setHorizontalAlignment(0);
        iconLabel.setIcon(this.optionMessage.getIcon());
        iconPanel.add(iconLabel);
        this.add(iconPanel, "West");
        messageLabel.setText("replace me with string argument");
        messageLabel.setVerticalAlignment(1);
        messageLabel.setText(this.message);
        messagePanel.add(messageLabel);
        this.add(messagePanel, "Center");
        this.option1Button.setText(this.optionMessage.getOption1());
        this.option1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionMessageDialogPanel.this.setReturnValueAndClose(DialogReturnValue.OPTION_1);
            }
        });
        buttonPanel.add(this.option1Button);
        this.option2Button.setText(this.optionMessage.getOption2());
        this.option2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionMessageDialogPanel.this.setReturnValueAndClose(DialogReturnValue.OPTION_2);
            }
        });
        buttonPanel.add(this.option2Button);
        String cancelText = this.optionMessage.getCancelText();
        if (cancelText == null) {
            cancelText = LanguagePack.getTextResource().Cancel();
        }
        this.cancelButton.setText(cancelText);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionMessageDialogPanel.this.setReturnValueAndClose(DialogReturnValue.CANCEL);
            }
        });
        buttonPanel.add(this.cancelButton);
        this.add(buttonPanel, "South");
    }
}

