/*
 * Decompiled with CFR 0.152.
 */
package gui.tools.dialogs;

import com.ur.swing.dialog.DialogRunnable;
import com.ur.swing.dialog.URDialogType;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import gui.tools.DialogCreator;
import gui.tools.URDialogShownListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;

public class PopupShowingListener
extends WindowAdapter {
    private final JDialog dialog;
    private final URDialogType dialogType;
    private final DialogRunnable dialogRunnable;
    private final DialogCreator dialogCreator;

    public PopupShowingListener(JDialog dialog, DialogRunnable dialogRunnable, final URDialogType dialogType, DialogCreator dialogCreator) {
        this.dialog = dialog;
        this.dialogType = dialogType;
        this.dialogRunnable = dialogRunnable;
        this.dialogCreator = dialogCreator;
        EventNotificationService.notify(URDialogShownListener.class, (NotificationStrategy)new NotificationStrategy<URDialogShownListener>(){

            public void notify(URDialogShownListener listener) {
                listener.dialogShown(dialogType);
            }
        });
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.dialog.removeWindowListener(this);
        this.dialogRunnable.close();
        this.dialogCreator.closeDialog(this.dialog);
        EventNotificationService.notify(URDialogShownListener.class, (NotificationStrategy)new NotificationStrategy<URDialogShownListener>(){

            public void notify(URDialogShownListener listener) {
                listener.dialogClosed(PopupShowingListener.this.dialogType);
            }
        });
    }
}

