/*
 * Decompiled with CFR 0.152.
 */
package gui.tools.dialogs.SafetyModeDialog;

import com.ur.log.GoToLog;
import com.ur.log.logentry.robotmessage.RobotMessage;
import gui.tools.DialogCreator;
import gui.tools.dialogs.SafetyModeDialog.SafetyDialogAction;
import java.awt.event.ActionEvent;

public class SafetyDialogActionFactory {
    public static final String DEFAULT_SAFETY_BUTTON = "SafetyModeDialog.DEFAULT_SAFETY_BUTTON";
    public static final String LOG_BUTTON = "SafetyModeDialog.LOG_BUTTON";
    public static final String CANCEL_BUTTON = "SafetyModeDialog.CANCEL_BUTTON";
    private final DialogCreator dialogCreator;

    public SafetyDialogActionFactory(DialogCreator dialogCreator) {
        this.dialogCreator = dialogCreator;
    }

    public SafetyDialogAction getDefaultAction(String text) {
        return new SafetyDialogAction(text, DEFAULT_SAFETY_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SafetyDialogActionFactory.this.dialogCreator.closeSafetyModeDialog();
            }
        };
    }

    public SafetyDialogAction getGoToLogServiceAction(String text, final RobotMessage message, final GoToLog logService) {
        SafetyDialogAction logServiceAction = new SafetyDialogAction(text, LOG_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logService.goTo((Object)message);
                SafetyDialogActionFactory.this.dialogCreator.closeSafetyModeDialog();
            }

            @Override
            public boolean canShow() {
                return message.getAttachment() != null;
            }
        };
        logServiceAction.setEnabled(logService.canGoTo());
        return logServiceAction;
    }

    public SafetyDialogAction getAction(String text, String name) {
        return new SafetyDialogAction(text, name){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SafetyDialogActionFactory.this.dialogCreator.closeSafetyModeDialog();
            }
        };
    }

    public SafetyDialogAction getDefaultRunnableAction(String text, final Runnable task) {
        return new SafetyDialogAction(text, DEFAULT_SAFETY_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                task.run();
                SafetyDialogActionFactory.this.dialogCreator.closeSafetyModeDialog();
            }
        };
    }

    public SafetyDialogAction getRunnableAction(String text, String name, final Runnable task) {
        return new SafetyDialogAction(text, name){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                task.run();
                SafetyDialogActionFactory.this.dialogCreator.closeSafetyModeDialog();
            }
        };
    }
}

