/*
 * Decompiled with CFR 0.152.
 */
package gui.tools.dialogs.SafetyModeDialog;

import com.ur.lang.StringUtils;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.SafetyModeCategory;
import com.ur.log.logentry.robotmessage.SafetyModes;
import com.ur.polyscope.controllerinterface.errorcode.ErrorCode;
import com.ur.resources.ViewImageResource;
import com.ur.swing.dialog.URDialogPanel;
import com.ur.swing.dialog.URDialogType;
import com.ur.util.swing.HTML;
import com.ur.view.constants.dev.SafetyMode;
import gui.tools.LanguagePack;
import gui.tools.dialogs.SafetyModeDialog.SafetyDialogAction;
import java.awt.Container;
import java.awt.Font;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SafetyModeDialogPanel
extends URDialogPanel {
    public static final String SAFETY_MODE_DIALOG = "SafetyModeDialog.SafetyModeDialogPanel";
    private static final int TEXT_AREA_MAXIMUM_WIDTH = 440;
    private SafetyDialogAction[] commands;
    private final SafetyMode safetyMode;
    private final String message;

    public SafetyModeDialogPanel(RobotMessage robotMessage, SafetyDialogAction[] commands) {
        this.safetyMode = robotMessage.safetyMode;
        this.commands = commands;
        this.setName(SAFETY_MODE_DIALOG);
        SafetyModeCategory safetyModeCategory = SafetyModes.getSafetyModeCategory((SafetyMode)this.safetyMode);
        this.message = safetyModeCategory == SafetyModeCategory.FAULT ? String.valueOf(robotMessage.getSourceString()) + " : " + robotMessage.getStringForMessageCode() : (safetyModeCategory == SafetyModeCategory.RECOVERY ? LanguagePack.getTextResource().robotInRecoveryMode() : (safetyModeCategory == SafetyModeCategory.EMERGENCY_STOP ? LanguagePack.getTextResource().popupEmergencyStoppedToproceed(robotMessage.getStringForMessageCode()) : robotMessage.getStringForMessageCode()));
        this.initComponents(robotMessage, commands);
    }

    public SafetyMode getSafetyMode() {
        return this.safetyMode;
    }

    private void initComponents(RobotMessage robotMessage, SafetyDialogAction[] commands) {
        JPanel errorReportInfoPanel;
        Icon icon;
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JLabel title = new JLabel();
        JLabel warning = new JLabel();
        JLabel securityStopReasonLabel = new JLabel();
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        switch (SafetyModes.getSafetyModeCategory((SafetyMode)this.safetyMode)) {
            case FAULT: {
                icon = ViewImageResource.formFault32x32();
                break;
            }
            case VIOLATION: {
                icon = ViewImageResource.cancel();
                break;
            }
            case EMERGENCY_STOP: {
                icon = ViewImageResource.emergencyStopSymbol50x50();
                break;
            }
            case PROTECTIVE_STOP: {
                icon = ViewImageResource.metalWarning();
                break;
            }
            case RECOVERY: {
                icon = ViewImageResource.metalWarning();
                break;
            }
            default: {
                icon = ViewImageResource.blank();
            }
        }
        warning.setIcon(icon);
        jPanel3.add(warning);
        title.setText(com.ur.log.logentry.LanguagePack.getMasterboardSafetyStateText((SafetyMode)this.safetyMode));
        title.setFont(new Font("Dialog", 1, 24));
        title.setHorizontalAlignment(0);
        jPanel3.add(title);
        this.add(jPanel3);
        securityStopReasonLabel.setText(HTML.html((String)HTML.maxWidth((int)400, (String)this.message)));
        jPanel1.add(securityStopReasonLabel);
        this.add(jPanel1);
        JPanel errorInformationPanel = SafetyModeDialogPanel.getErrorInformationPanel(robotMessage, 440);
        if (errorInformationPanel != null) {
            this.add(errorInformationPanel);
        }
        if ((errorReportInfoPanel = this.getErrorReportInfoPanel(robotMessage, 440)) != null) {
            this.add(errorReportInfoPanel);
        }
        SafetyDialogAction[] safetyDialogActionArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            SafetyDialogAction command = safetyDialogActionArray[n2];
            if (command.canShow()) {
                jPanel2.add(this.getButton(command));
            }
            ++n2;
        }
        this.add(jPanel2);
    }

    private JButton getButton(SafetyDialogAction action) {
        JButton button = new JButton();
        button.setAction(action);
        button.setName(action.getValue("Name").toString());
        button.setText(action.getText());
        return button;
    }

    private JPanel getErrorReportInfoPanel(RobotMessage robotMessage, int textAreaMaximumWidth) {
        if (robotMessage == null || robotMessage.getAttachment() == null) {
            return null;
        }
        JPanel errorReportStatusPanel = new JPanel();
        JLabel errorReportStatusLabel = new JLabel();
        String dateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat);
        String timeStamp = LocalDateTime.now().format(formatter);
        String errorReportMessage = LanguagePack.getTextResource().reportGeneratedInfoLine(timeStamp);
        errorReportStatusLabel.setText(HTML.html((String)HTML.maxWidth((int)textAreaMaximumWidth, (String)errorReportMessage)));
        errorReportStatusPanel.add(errorReportStatusLabel);
        return errorReportStatusPanel;
    }

    private static JPanel getErrorInformationPanel(RobotMessage robotMessage, int textAreaMaximumWidth) {
        if (robotMessage == null || robotMessage.errorCode == ErrorCode.NO_ERROR) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String text = com.ur.log.logentry.LanguagePack.getFriendlyMessageCodeExplanation((int)robotMessage.errorCode.getId(), (int)robotMessage.errorArgument);
        if (!StringUtils.startsAndEndsWith((String)"!", (String)text)) {
            sb.append(HTML.fontBold((String)LanguagePack.getTextResource().explanation()));
            sb.append(HTML.br());
            sb.append(text);
            sb.append(HTML.br());
        }
        if (!StringUtils.startsAndEndsWith((String)"!", (String)(text = com.ur.log.logentry.LanguagePack.getFriendlyMessageCodeSuggestion((int)robotMessage.errorCode.getId(), (int)robotMessage.errorArgument)))) {
            if (sb.length() > 0) {
                sb.append(HTML.br());
            }
            sb.append(HTML.fontBold((String)LanguagePack.getTextResource().suggestion()));
            sb.append(HTML.br());
            sb.append(text);
        }
        if (sb.length() == 0) {
            return null;
        }
        JPanel errorDetailsPanel = new JPanel();
        JLabel errorDetailsLabel = new JLabel();
        String htmlWrappedText = HTML.html((String)HTML.maxWidth((int)textAreaMaximumWidth, (String)sb.toString()));
        errorDetailsLabel.setText(htmlWrappedText);
        errorDetailsPanel.add(errorDetailsLabel);
        return errorDetailsPanel;
    }

    public boolean equals(Object other) {
        if (Objects.nonNull(other) && other.getClass() == ((Object)((Object)this)).getClass()) {
            SafetyModeDialogPanel smd = (SafetyModeDialogPanel)((Object)other);
            if (this.commands.length != smd.commands.length) {
                return false;
            }
            EqualsBuilder equalsBuilder = new EqualsBuilder().append((Object)this.message, (Object)smd.message).append((Object)this.safetyMode, (Object)smd.safetyMode);
            int i = 0;
            while (i < this.commands.length) {
                equalsBuilder.append((Object)this.commands[i], (Object)smd.commands[i]);
                ++i;
            }
            return equalsBuilder.isEquals();
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append(this.safetyMode != null ? this.safetyMode.hashCode() : 0);
        SafetyDialogAction[] safetyDialogActionArray = this.commands;
        int n = this.commands.length;
        int n2 = 0;
        while (n2 < n) {
            SafetyDialogAction action = safetyDialogActionArray[n2];
            hashCodeBuilder.append(action.hashCode());
            ++n2;
        }
        hashCodeBuilder.append(this.message != null ? this.message.hashCode() : 0);
        return hashCodeBuilder.hashCode();
    }

    public JPanel getPanel() {
        return this;
    }

    public URDialogType getDialogType() {
        return URDialogType.SAFETY_MODE;
    }
}

