/*
 * Decompiled with CFR 0.152.
 */
package gui.tools.dialogs;

import com.ur.resources.ViewImageResource;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.URDialogPanel;
import com.ur.swing.dialog.URDialogType;
import com.ur.util.swing.HTML;
import gui.tools.LanguagePack;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SaveProgramChangesDialog
extends URDialogPanel {
    public static final String YES_BUTTON = "yes.saveProgramChangesDialog";
    public static final String NO_BUTTON = "no.saveProgramChangesDialog";
    public static final String CANCEL_BUTTON = "cancel.saveProgramChangesDialog";
    private JLabel jLabel1;
    private String programName;

    public SaveProgramChangesDialog(String programName) {
        this.programName = HTML.convertToHtml((String)programName);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this;
    }

    public URDialogType getDialogType() {
        return URDialogType.SAVE_PROGRAM_CHANGES;
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        JButton noButton = new JButton();
        noButton.setName(NO_BUTTON);
        JButton yesButton = new JButton();
        yesButton.setName(YES_BUTTON);
        JButton cancelButton = new JButton();
        cancelButton.setName(CANCEL_BUTTON);
        this.setLayout(new BorderLayout());
        this.jLabel1.setIcon(ViewImageResource.metalQuestion());
        this.jLabel1.setText(HTML.html((String)LanguagePack.getTextResource().saveProgramChanges(this.programName)));
        jPanel2.add(this.jLabel1);
        this.add(jPanel2, "Center");
        yesButton.setText(LanguagePack.getTextResource().saveChanges());
        yesButton.setFocusable(false);
        yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveProgramChangesDialog.this.yesButtonActionPerformed();
            }
        });
        jPanel1.add(yesButton);
        noButton.setText(LanguagePack.getTextResource().continueWithoutSaving());
        noButton.setFocusable(false);
        noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveProgramChangesDialog.this.noButtonActionPerformed();
            }
        });
        jPanel1.add(noButton);
        cancelButton.setText(LanguagePack.getTextResource().Cancel());
        cancelButton.setFocusable(false);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveProgramChangesDialog.this.cancelButtonActionPerformed();
            }
        });
        jPanel1.add(cancelButton);
        this.add(jPanel1, "South");
    }

    private void noButtonActionPerformed() {
        this.setReturnValueAndClose(DialogReturnValue.NO);
    }

    private void yesButtonActionPerformed() {
        this.setReturnValueAndClose(DialogReturnValue.YES);
    }

    private void cancelButtonActionPerformed() {
        this.setReturnValueAndClose(DialogReturnValue.CANCEL);
    }

    public String getMessage() {
        return this.jLabel1.getText();
    }
}

