/*
 * Decompiled with CFR 0.152.
 */
package gui.tools.dialogs.input;

import com.ur.i18n.TextResource;
import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.swing.TextProvider;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidValuesValidator;
import com.ur.swing.validation.ValidationStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NameValidationFactory {
    public static AutoCorrectionValidator getVariableNameValidatorWithWhiteList(NamingService namingService, Class<? extends NamedEntity> namedEntityClass, String errorMessageAlreadyUsed, String errorMessageInvalidName, TextResource textResource, String ... whiteList) {
        VariableNameValidatorWithWhiteList validator = new VariableNameValidatorWithWhiteList(false, namingService, namedEntityClass, errorMessageAlreadyUsed, errorMessageInvalidName, textResource);
        validator.addValidValues(whiteList);
        return validator;
    }

    public static ValidationStrategy getVariableNameAllowingEmptyValidator(final TextProvider originalTextProvider, NamingService namingService, Class<? extends NamedEntity> namedEntityClass, TextResource textResource) {
        return new AutoCorrectVariableNameValidator(true, namingService, namedEntityClass, textResource){

            @Override
            public boolean isValid(String uncheckedString) {
                if (EqualsUtil.equals((Object)uncheckedString, (Object)originalTextProvider.getText())) {
                    return true;
                }
                return super.isValid(uncheckedString);
            }
        };
    }

    public static AutoCorrectVariableNameValidator getVariableNameValidator(NamingService namingService, Class<? extends NamedEntity> namedEntityClass, TextResource textResource) {
        return new AutoCorrectVariableNameValidator(false, namingService, namedEntityClass, textResource);
    }

    public static AutoCorrectVariableNameValidator getVariableNameValidator(final TextProvider originalTextProvider, NamingService namingService, Class<? extends NamedEntity> namedEntityClass, TextResource textResource) {
        return new AutoCorrectVariableNameValidator(false, namingService, namedEntityClass, textResource){

            @Override
            public boolean isValid(String uncheckedString) {
                if (uncheckedString == null) {
                    uncheckedString = "";
                }
                if (EqualsUtil.equals((Object)uncheckedString.trim(), (Object)originalTextProvider.getText())) {
                    return true;
                }
                return super.isValid(uncheckedString);
            }
        };
    }

    private static class AutoCorrectVariableNameValidator
    extends AutoCorrectionNameValidator {
        public AutoCorrectVariableNameValidator(boolean allowEmpty, NamingService namingService, Class<? extends NamedEntity> namedEntityClass, TextResource textResource) {
            super(namingService, namedEntityClass, textResource.variableNameAlreadyExists(), textResource.illegalVariableName(), textResource);
            if (allowEmpty) {
                this.addValidValues("");
            }
        }
    }

    private static class AutoCorrectionNameValidator
    implements ValidationStrategy,
    AutoCorrectionValidator,
    ValidValuesValidator {
        private final NamingService namingService;
        private final Class<? extends NamedEntity> namedEntityClass;
        private final String alreadyUsedErrorMessage;
        private final String illegalNameErrorMessage;
        private TextResource textResource;
        private List<String> validValues = new ArrayList<String>();

        public AutoCorrectionNameValidator(NamingService namingService, Class<? extends NamedEntity> namedEntityClass, String alreadyUsedErrorMessage, String illegalNameErrorMessage, TextResource textResource) {
            this.alreadyUsedErrorMessage = alreadyUsedErrorMessage;
            this.illegalNameErrorMessage = illegalNameErrorMessage;
            this.namingService = namingService;
            this.namedEntityClass = namedEntityClass;
            this.textResource = textResource;
        }

        public void addValidValues(String ... validValues) {
            this.validValues.addAll(Arrays.asList(validValues));
        }

        public void setValidValues(String ... validValues) {
            this.validValues = new ArrayList<String>(Arrays.asList(validValues));
        }

        public boolean isValid(String uncheckedString) {
            if (uncheckedString == null) {
                uncheckedString = "";
            }
            if (this.validValues.contains(uncheckedString.trim())) {
                return true;
            }
            if (this.namingService.isNameValid(this.namedEntityClass, uncheckedString)) {
                return !this.namingService.isNameUsed(this.namedEntityClass, uncheckedString);
            }
            return false;
        }

        public String getErrorMessage(String text) {
            if (text.trim().isEmpty()) {
                return "";
            }
            int maximumTextWidth = this.namingService.maxNameLength(this.namedEntityClass);
            if (this.namingService.isNameValid(this.namedEntityClass, text)) {
                if (this.namingService.isNameUsed(this.namedEntityClass, text.trim())) {
                    return this.alreadyUsedErrorMessage;
                }
                return "";
            }
            if (text.length() > maximumTextWidth) {
                return this.textResource.maximumTextLength(maximumTextWidth);
            }
            return this.illegalNameErrorMessage;
        }

        public String getNearestValidValue(String value) {
            if (this.isValid(value)) {
                return value;
            }
            return this.namingService.makeUniqueName(this.namedEntityClass, value);
        }
    }

    public static class VariableNameValidatorWithWhiteList
    extends AutoCorrectionNameValidator {
        public VariableNameValidatorWithWhiteList(boolean allowEmpty, NamingService namingService, Class<? extends NamedEntity> namedEntityClass, String errorMessageAlreadyUsed, String illegalVariableName, TextResource textResource) {
            super(namingService, namedEntityClass, errorMessageAlreadyUsed, illegalVariableName, textResource);
            if (allowEmpty) {
                this.addValidValues("");
            }
        }
    }
}

