/*
 * Decompiled with CFR 0.152.
 */
package gui.tools.util;

import com.ur.polyscope.geomfeature.ProgramFeature;
import com.ur.polyscope.geomfeature.ProgramFeatureService;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.urcap.contributor.ContributorInfo;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.swing.renderers.contributed.ContributedHeading;
import gui.polyscope.setup.treenodes.geom.GeomPoseNodeContributed;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FeatureComboBoxHelper {
    private FeatureComboBoxHelper() {
    }

    public static List<GeomFeature> getSelectableFeatures(InstallationComponentLookup lookupService, ProgramFeatureService programFeatureService) {
        List<GeomFeature> selectableFeatures = ((SetupFeatureContainerNode)lookupService.getComponent(SetupFeatureContainerNode.class)).getSelectableFeatures();
        FeatureComboBoxHelper.addProgramFeatures(selectableFeatures, programFeatureService);
        return selectableFeatures;
    }

    public static List<GeomFeature> getNonContributedFeatures(List<GeomFeature> selectableFeatures) {
        ArrayList<GeomFeature> result = new ArrayList<GeomFeature>();
        for (GeomFeature selectableFeature : selectableFeatures) {
            if (selectableFeature instanceof GeomPoseNodeContributed) continue;
            result.add(selectableFeature);
        }
        return result;
    }

    public static Map<ContributedHeading, List<GeomPoseNodeContributed>> createContributedMap(List<GeomFeature> selectableFeatures) {
        HashMap<ContributedHeading, List<GeomPoseNodeContributed>> result = new HashMap<ContributedHeading, List<GeomPoseNodeContributed>>();
        for (GeomFeature selectableFeature : selectableFeatures) {
            if (!(selectableFeature instanceof GeomPoseNodeContributed)) continue;
            ContributorInfo contributorInfo = ((GeomPoseNodeContributed)selectableFeature).getContributorInfo();
            ContributedHeading heading = new ContributedHeading(contributorInfo.getOwnerDisplayName());
            ArrayList<GeomPoseNodeContributed> contributions = (ArrayList<GeomPoseNodeContributed>)result.get(heading);
            if (contributions == null) {
                contributions = new ArrayList<GeomPoseNodeContributed>();
                result.put(heading, contributions);
            }
            contributions.add((GeomPoseNodeContributed)selectableFeature);
        }
        return result;
    }

    private static void addProgramFeatures(List<GeomFeature> selectableFeatures, ProgramFeatureService programFeatureService) {
        List programFeatures = programFeatureService.getProgramFeatures();
        for (ProgramFeature programFeature : programFeatures) {
            if (!(programFeature instanceof GeomFeature)) continue;
            selectableFeatures.add((GeomFeature)programFeature);
        }
    }
}

