/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.resources.ViewImageResource;
import com.ur.swing.CardPanel;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.baseview.BaseTreeView;
import com.ur.swing.baseview.SidePlaceholders;
import com.ur.swing.extensible.LeftOf;
import com.ur.swing.extensible.PostTreeCellRenderer;
import com.ur.swing.extensible.TreeView;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import gui.tree.TreeExpansionComplete;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.LayoutStyle;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public abstract class TreePanel
extends CardPanel
implements TreeWillExpandListener,
TreeView,
LeftOf {
    public static final String SAVE_BUTTON = "saveButton.TreePanel";
    public static final String WIDEN_PROGRAM_TREE = "treeResize:TreePanel";
    protected static final int EXPANDED_WIDTH = 360;
    public static final int COMPACTED_WIDTH = 180;
    protected JTree tree;
    private JComponent footerBar;
    private JComponent headerBar;
    protected JLabel saveIcon;
    private JLabel loadIcon;
    protected JLabel treeNameLabel;
    private SidePlaceholders placeholders;
    private BaseTreeView treeView;
    protected WidgetFactory widgetFactory;
    private TextResource textResource;
    private static boolean treeExpansionDone;

    protected TreePanel(ViewContext viewContext, SidePlaceholders placeholders) {
        this.widgetFactory = viewContext.createWidgetFactory();
        this.placeholders = placeholders;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.initComponents();
        this.saveIcon.setName(SAVE_BUTTON);
        this.treeView.getTree().addTreeWillExpandListener(this);
        this.treeView.getSelectionModel().setSelectionMode(1);
    }

    public TreeView getTreeView() {
        return this.treeView;
    }

    public static void setTreeExpansionDone(boolean treeExpansionDone) {
        TreePanel.treeExpansionDone = treeExpansionDone;
    }

    public static boolean isTreeExpansionDone() {
        return treeExpansionDone;
    }

    public JViewport getViewport() {
        return this.treeView.getViewport();
    }

    public JScrollPane getScrollPane() {
        return this.treeView.getScrollPane();
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        AbstractProgramNode pn;
        TreePath tp = e.getPath();
        Object o = tp.getLastPathComponent();
        if (o instanceof AbstractProgramNode && !(pn = (AbstractProgramNode)o).isTreeExpandable()) {
            throw new ExpandVetoException(e);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) {
    }

    protected void makeTreeTransparent() {
        this.tree.setOpaque(false);
    }

    protected void hideFooter() {
        this.footerBar.setVisible(false);
    }

    protected void setSaveEnabled(boolean enabled) {
        this.saveIcon.setEnabled(enabled);
    }

    protected void hideLoadIcon() {
        this.loadIcon.setVisible(false);
    }

    protected void insertComponentIntoPlaceholderPanel(JComponent component) {
        this.placeholders.setRight(component);
    }

    public void expandTree() {
        int row = 0;
        TreePanel.setTreeExpansionDone(false);
        while (row < this.tree.getRowCount()) {
            this.tree.expandRow(row);
            ++row;
        }
        TreePanel.setTreeExpansionDone(true);
    }

    protected void expandTreeNonGuiBlocking() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    final int[] row = new int[1];
                    TreePanel.setTreeExpansionDone(false);
                    while (row[0] < TreePanel.this.tree.getRowCount()) {
                        SwingUtil.invokeAndWait((Runnable)new Runnable(){
                            long endTime = System.nanoTime() + 100000000L;

                            @Override
                            public void run() {
                                while (row[0] < (this).TreePanel.this.tree.getRowCount() && System.nanoTime() < this.endTime) {
                                    (this).TreePanel.this.tree.expandRow(row[0]);
                                    row[0] = row[0] + 1;
                                }
                            }
                        });
                        Waiting.pause((long)20L, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                }
                finally {
                    TreePanel.setTreeExpansionDone(true);
                    TreePanel.this.notifyTreeExpansionInBackgroundCompleted();
                }
            }
        }).start();
    }

    private void notifyTreeExpansionInBackgroundCompleted() {
        EventNotificationService.notify(TreeExpansionComplete.class, (NotificationStrategy)new NotificationStrategy<TreeExpansionComplete>(){

            public void notify(TreeExpansionComplete treeExpansionComplete) {
                treeExpansionComplete.expansionDone();
            }
        });
    }

    public void resetTreeSize() {
        this.treeView.setPreferredSize(new Dimension(180, this.treeView.getHeight()));
    }

    public void resizeProgramTreeToWidth(int width) {
        this.treeView.setPreferredSize(new Dimension(width, this.treeView.getHeight()));
    }

    private void initComponents() {
        this.headerBar = new JPanel();
        this.saveIcon = new JLabel();
        this.loadIcon = new JLabel();
        this.treeNameLabel = new JLabel();
        this.footerBar = new JPanel();
        this.treeView = new BaseTreeView(this.widgetFactory);
        this.tree = this.treeView.getTree();
        this.headerBar.setPreferredSize(new Dimension(180, 24));
        this.saveIcon.setIcon(ViewImageResource.gtkSave());
        this.saveIcon.setName("treeSaveIcon");
        this.saveIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TreePanel.this.saveIconMouseClicked(evt);
            }
        });
        this.loadIcon.setIcon(ViewImageResource.gtkOpen());
        this.loadIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                TreePanel.this.handleLoadIconMousePressed(evt);
            }
        });
        this.treeView.getTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TreePanel.this.handleTreeMouseClicked(evt);
            }
        });
        this.treeView.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                TreePanel.this.handleTreeSelectionChange(evt);
            }
        });
        this.treeNameLabel.setText(this.textResource.placeholderUnnamed());
        this.treeNameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TreePanel.this.treeNameLabelMouseClicked();
            }
        });
        GroupLayout headerBarLayout = new GroupLayout(this.headerBar);
        this.headerBar.setLayout(headerBarLayout);
        headerBarLayout.setHorizontalGroup(headerBarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerBarLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.saveIcon, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadIcon, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.treeNameLabel, -2, 170, -2).addContainerGap()));
        headerBarLayout.setVerticalGroup(headerBarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerBarLayout.createSequentialGroup().addGroup(headerBarLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.saveIcon, -2, 24, -2).addComponent(this.loadIcon, -2, 24, -2).addComponent(this.treeNameLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.footerBar.setPreferredSize(new Dimension(180, 26));
        this.footerBar.setLayout(new CardLayout());
        this.setLayout(new BorderLayout());
        this.treeView.setPreferredSize(new Dimension(180, 38));
        this.placeholders.setCenter((JComponent)this.treeView);
        this.placeholders.setParent((JComponent)((Object)this));
    }

    private void treeNameLabelMouseClicked() {
        this.treeView.getTree().setSelectionRow(0);
    }

    private void saveIconMouseClicked(MouseEvent evt) {
        if (this.saveIcon.isEnabled()) {
            this.handleSaveIconMouseClicked(evt);
        }
    }

    protected void handleSaveIconMouseClicked(MouseEvent evt) {
    }

    protected void handleLoadIconMousePressed(MouseEvent evt) {
    }

    protected void handleTreeMouseClicked(MouseEvent evt) {
    }

    protected void handleTreeSelectionChange(TreeSelectionEvent selectionEvent) {
    }

    public void setHeader(JComponent panel) {
        this.headerBar = panel;
        this.treeView.setHeader(this.headerBar);
    }

    public void setFooter(JComponent panel) {
        this.footerBar = panel;
        this.treeView.setFooter(this.footerBar);
    }

    public void setTreeCellRenderer(TreeCellRenderer renderer) {
        this.treeView.setTreeCellRenderer(renderer);
    }

    public void appendPostTreeCellRenderer(PostTreeCellRenderer renderer) {
        this.treeView.appendPostTreeCellRenderer(renderer);
    }

    public void setLeftPanel(JComponent component) {
        this.placeholders.setLeft(component);
    }

    public void setTreeBackground(Color bg) {
        this.treeView.setBackground(bg);
    }

    public JComponent getHeader() {
        return this.headerBar;
    }

    public SidePlaceholders getSidePlaceholders() {
        return this.placeholders;
    }
}

