/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.polyscope.driver.api.dialog.DialogWithName;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.program.ProgramRootNode;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.checksum.CrcComponent;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.util.logging.Log;
import gui.installation.services.ProgramLookupService;
import gui.polyscope.SaveProgramService;
import gui.program.ErrorMessageException;
import gui.program.PreProgramLoad;
import java.io.File;
import javax.inject.Inject;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractProgramChecksumHandler
extends ProgramEventListener.Template
implements PreProgramLoad {
    public static final String COULD_NOT_READ_FROM_PROGRAM_FILE = "Could not read from program file";
    private ProgramLookupService programLookupService;
    private InstallationComponentLookup robotInstallationLookupService;
    private ErrorDialogCreator dialogCreator;
    private SafetyTextResource safetyTextResource;
    private SaveProgramService saveProgramService;
    private boolean matchingChecksum = true;

    @Inject
    public AbstractProgramChecksumHandler(ProgramLookupService programLookupService, InstallationComponentLookup robotInstallationLookupService, ErrorDialogCreator dialogCreator, SafetyTextResource safetyTextResource, SaveProgramService saveProgramService) {
        this.programLookupService = programLookupService;
        this.robotInstallationLookupService = robotInstallationLookupService;
        this.dialogCreator = dialogCreator;
        this.safetyTextResource = safetyTextResource;
        this.saveProgramService = saveProgramService;
    }

    String getInstallationCrcValue() {
        SafetySetup safetySetup = (SafetySetup)this.robotInstallationLookupService.getComponent(SafetySetup.class);
        return ((VersionComponent)safetySetup.getComponent(VersionComponent.class)).getLoadedCRCValue();
    }

    private void setProgramCrcValue(ProgramRootNode programRootNode, String crcValue) {
        ((CrcComponent)programRootNode.getComponent(CrcComponent.class)).setCrcValue(crcValue);
    }

    private void verifyCrcMatchOrShowError(String programCrcValue, String installationCrc) {
        if (programCrcValue == null || programCrcValue.equals(installationCrc)) {
            this.matchingChecksum = true;
        } else {
            this.matchingChecksum = false;
            if (this.isAutomaticOrReadOnly()) {
                throw new ErrorMessageException(new ErrorMessage(DialogWithName.SAFETY.getName(), this.safetyTextResource.Safety(), this.safetyTextResource.crcMismatchAutomatic(), ""));
            }
            this.dialogCreator.showErrorDialog(new ErrorMessage(DialogWithName.SAFETY.getName(), this.safetyTextResource.Safety(), this.safetyTextResource.crcMismatchManual(), ""), null);
        }
    }

    protected abstract boolean isAutomaticOrReadOnly();

    public void onPreProgramSave() {
        try {
            gui.program.ProgramRootNode programRootNode = this.programLookupService.getProgramRootNode();
            String installationCrc = this.getInstallationCrcValue();
            this.setProgramCrcValue((ProgramRootNode)programRootNode, installationCrc);
        }
        catch (Exception ex) {
            Log.error((String)ex.getMessage());
        }
    }

    public void onPreProgramLoad(File programFile) {
        this.verifyCrcMatchOrShowError(this.readCrcFromProgram(programFile), this.getInstallationCrcValue());
    }

    public void onPostPostNewProgram(ProgramRootNode programRootNode) {
        if (!this.matchingChecksum) {
            this.saveProgramService.programChanged();
        }
    }

    /*
     * Exception decompiling
     */
    private String readCrcFromProgram(File programFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class CrcHandler
    extends DefaultHandler {
        private String crc;

        private CrcHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("URProgram")) {
                int i = 0;
                while (i < attributes.getLength()) {
                    if (attributes.getQName(i).equals("crcValue")) {
                        this.crc = attributes.getValue(i);
                    }
                    ++i;
                }
            }
        }

        public String getCrc() {
            return this.crc;
        }
    }
}

