/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumEvent;
import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumListener;
import com.ur.polyscope.safety.checksum.ChecksumService;
import com.ur.polyscope.safety.checksum.SafetyChecksum;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.ShowActiveSafetyLimitsAction;
import com.ur.safety.checksum.SafetyChecksumIconFactory;
import com.ur.swing.SwingUtil;
import java.lang.ref.WeakReference;

public class ActiveSafetyChecksumChanged
implements ActiveSafetyChecksumListener {
    private WeakReference<ShowActiveSafetyLimitsAction> reference;
    private SafetyChecksum oldSafetyChecksum;
    private final ChecksumService checksumService;
    private SafetyTextResource safetyTextResource;
    private SafetyChecksumIconFactory safetyChecksumIconFactory;

    public ActiveSafetyChecksumChanged(ShowActiveSafetyLimitsAction action, ChecksumService checksumService, SafetyTextResource safetyTextResource, SafetyChecksumIconFactory safetyChecksumIconFactory) {
        this.reference = new WeakReference<ShowActiveSafetyLimitsAction>(action);
        this.checksumService = checksumService;
        this.safetyTextResource = safetyTextResource;
        this.safetyChecksumIconFactory = safetyChecksumIconFactory;
    }

    public void activeSafetyChecksumChanged(ActiveSafetyChecksumEvent e) {
        if (this.checksumHasChanged()) {
            this.doShowToolTip();
        }
        this.update();
    }

    private ShowActiveSafetyLimitsAction getAction() {
        return (ShowActiveSafetyLimitsAction)this.reference.get();
    }

    private boolean checksumHasChanged() {
        return !this.checksumService.getActiveSafetyChecksum().equals(SafetyChecksum.NULL) && this.oldSafetyChecksum != null && !this.checksumService.getActiveSafetyChecksum().equals(this.oldSafetyChecksum);
    }

    private void doShowToolTip() {
        SwingUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ActiveSafetyChecksumChanged.this.reference.get() == null) {
                    return;
                }
                String displayMessage = ActiveSafetyChecksumChanged.this.safetyTextResource.safetySettingsChangedToolTip();
                ActiveSafetyChecksumChanged.this.getAction().showTooltip(displayMessage);
            }
        });
    }

    public void update() {
        if (this.reference.get() == null) {
            return;
        }
        SafetyChecksum checksum = this.checksumService.getActiveSafetyChecksum();
        this.getAction().putValue("SmallIcon", this.safetyChecksumIconFactory.createSafetyChecksumIcon(checksum));
        if (checksum != SafetyChecksum.NULL) {
            this.oldSafetyChecksum = checksum;
        }
    }
}

