/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.security.SafetyLockListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class DefaultSafetyLockListener
implements SafetyLockListener {
    private final SafetyLock lock;
    private List<JComponent> components = new ArrayList<JComponent>();
    private List<JComponent> reducedModeComponents = new ArrayList<JComponent>();
    private SafetySettingsLookupService provider;

    public DefaultSafetyLockListener(SafetyLock lock, SafetySettingsLookupService provider, JComponent ... components) {
        this.lock = lock;
        this.provider = provider;
        JComponent[] jComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent c = jComponentArray[n2];
            this.addComponent(c);
            ++n2;
        }
    }

    @Override
    public void doUnlock() {
        for (JComponent each : this.components) {
            each.setEnabled(true);
        }
        SafetySetup safetySetup = this.provider.getSafetySetup();
        if (safetySetup != null && safetySetup.isReducedModeDefined()) {
            for (JComponent each : this.reducedModeComponents) {
                each.setEnabled(true);
            }
        }
    }

    @Override
    public void doLock() {
        for (JComponent each : this.components) {
            each.setEnabled(false);
        }
        for (JComponent each : this.reducedModeComponents) {
            each.setEnabled(false);
        }
    }

    public void addComponent(JComponent component) {
        component.setEnabled(!this.lock.isLocked());
        this.components.add(component);
    }

    public void addReducedModeComponent(JComponent component) {
        this.reducedModeComponents.add(component);
    }
}

