/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.monitor.model.JointType;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.security.SafetyLockListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public class EnableJointPositionLimitLockListener
implements SafetyLockListener {
    protected final SafetyLock lock;
    protected Map<JComponent, JointType> components = new HashMap<JComponent, JointType>();
    protected Map<JComponent, JointType> reducedModeComponents = new HashMap<JComponent, JointType>();
    protected SafetySettingsLookupService provider;

    public EnableJointPositionLimitLockListener(SafetyLock lock, SafetySettingsLookupService provider) {
        this.lock = lock;
        this.provider = provider;
    }

    @Override
    public void doUnlock() {
        SafetySetup safetySetup = this.provider.getSafetySetup();
        if (safetySetup != null) {
            for (Map.Entry<JComponent, JointType> each : this.components.entrySet()) {
                this.setEnabled(safetySetup, each);
            }
            if (safetySetup.isReducedModeDefined()) {
                for (Map.Entry<JComponent, JointType> each : this.reducedModeComponents.entrySet()) {
                    this.setEnabled(safetySetup, each);
                }
            }
        }
    }

    @Override
    public void doLock() {
        for (Map.Entry<JComponent, JointType> each : this.components.entrySet()) {
            each.getKey().setEnabled(false);
        }
        for (Map.Entry<JComponent, JointType> each : this.reducedModeComponents.entrySet()) {
            each.getKey().setEnabled(false);
        }
    }

    public void addComponent(JComponent component, JointType jointType) {
        component.setEnabled(!this.lock.isLocked());
        this.components.put(component, jointType);
    }

    public void addReducedModeComponent(JComponent component, JointType jointType) {
        this.reducedModeComponents.put(component, jointType);
    }

    private void setEnabled(SafetySetup safetySetup, Map.Entry<JComponent, JointType> each) {
        if (((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).getWithPositionLimits(each.getValue())) {
            each.getKey().setEnabled(true);
        } else {
            each.getKey().setEnabled(false);
        }
    }
}

