/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.lang.EqualsUtil;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.io.SafetyIOInputFunction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public abstract class RebindWhenReducedAndNonReducedModeAvailable
implements PropertyChangeListener {
    SafetySettingsLookupService safetySettingsLookupService;
    private boolean currentlyReducedModeCapable;

    public RebindWhenReducedAndNonReducedModeAvailable(SafetySettingsLookupService safetySettingsLookupService) {
        this.safetySettingsLookupService = safetySettingsLookupService;
        this.currentlyReducedModeCapable = this.isReducedModeDefined();
    }

    private boolean isReducedModeDefined() {
        return this.safetySettingsLookupService.getSafetySetup().isReducedModeDefined();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (EqualsUtil.equalsOneOf((Object)propertyName, (Object[])SafetyIOInputFunction.getPropertyNames()) || EqualsUtil.equals((Object)"mode", (Object)propertyName) && EqualsUtil.equalsOneOf((Object)((Object)SafetyLimitMode.TRIGGER), (Object[])new SafetyLimitMode[]{(SafetyLimitMode)((Object)evt.getNewValue()), (SafetyLimitMode)((Object)evt.getOldValue())})) {
            this.updateWhenReducedModeHasChanged();
        }
    }

    public void initReducedModeCapable() {
        this.currentlyReducedModeCapable = this.isReducedModeDefined();
    }

    private void updateWhenReducedModeHasChanged() {
        boolean isReducedModeDefined = this.isReducedModeDefined();
        if (this.currentlyReducedModeCapable != isReducedModeDefined) {
            this.rebindFormValidation();
            this.currentlyReducedModeCapable = isReducedModeDefined;
        }
    }

    protected abstract void rebindFormValidation();
}

