/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.injection.Builder;
import com.ur.lang.Defense;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.polyscope.safety.version.SafetyControlBoardVersionSite;
import com.ur.polyscope.version.urversion.URVersion;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.util.logging.Log;
import com.ur.view.polyscope.persistence.installation.RobotInstallationPersistence;
import gui.main.URGUI;
import java.io.File;
import java.io.IOException;

public final class SafetyCRCUpdater {
    private final Builder builder = URGUI.bindServices(null);

    private SafetyCRCUpdater() {
        URVersion safetyAVersion = new URVersion(0, 0, 0);
        URVersion safetyBVersion = new URVersion(0, 0, 0);
        ((SafetyControlBoardVersionSite)this.builder.get(SafetyControlBoardVersionSite.class)).setSafetyControlBoardVersions(safetyAVersion, safetyBVersion, true);
    }

    private void updateSafetyCRCInInstallation(File installationFile) throws IOException {
        Installation installation = RobotInstallationPersistence.load((File)installationFile);
        SafetySetup safetySetup = (SafetySetup)installation.getComponent(SafetySetup.class);
        String crc = ((SafetySettingsLookupService)this.builder.get(SafetySettingsLookupService.class)).generateChecksum(safetySetup);
        ((VersionComponent)safetySetup.getComponent(VersionComponent.class)).setCRCValue(crc);
        ((RobotInstallationSite)this.builder.get(RobotInstallationSite.class)).setInstallation(installation);
        new RobotInstallationPersistence().save(installation);
    }

    public static void main(String[] args) {
        Defense.isCondition((args.length > 0 ? 1 : 0) != 0, (String)"At least one installation file path expected. \nIf generating test cases, argument must be a valid .xml file");
        SafetyCRCUpdater updater = new SafetyCRCUpdater();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String each = stringArray[n2];
            try {
                updater.updateSafetyCRCInInstallation(new File(each));
            }
            catch (IOException e) {
                Log.error((String)"Failed to update Safety CRC for Installation", (Throwable)e);
                System.exit(1);
            }
            ++n2;
        }
        System.exit(0);
    }
}

