/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.polyscope.initializerobot.veto.VetoListener;
import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.polyscope.viewfacade.lang.ErrorablePanel;
import com.ur.safety.SafetyControlsCard;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.monitor.PowerOffOnEditSafetyLockListener;
import com.ur.safety.security.PolyScopeSafetyPasswordPanel;
import com.ur.safety.security.SafetyLock;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.event.EventNotificationService;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.inject.Inject;
import javax.swing.JPanel;

public class SafetyCardPanel
extends CardPanel {
    private final ErrorablePanel errorablePanel;
    private final SafetyLock safetyLock;

    @Inject
    public SafetyCardPanel(SafetyLock safetyLock, SafetySettingsLookupService lookupService, ErrorablePanel errorablePanel, PolyScopeSafetyPasswordPanel passwordPanel, ViewContext viewContext) {
        this.errorablePanel = errorablePanel;
        this.safetyLock = safetyLock;
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        JPanel footer = new JPanel(new BorderLayout());
        footer.add((Component)passwordPanel, "Center");
        footer.add((Component)new SafetyControlsCard(safetyLock, lookupService.getCaretaker(), (Errorable)errorablePanel, viewContext), "East");
        this.add((Component)errorablePanel, "Center");
        this.add(footer, "South");
    }

    public void enter(Object o) {
        this.errorablePanel.enterActiveChild(o);
        super.enter(o);
    }

    public Object exit() {
        EventNotificationService.notify(VetoListener.class, listener -> listener.cancelVeto(PowerOffOnEditSafetyLockListener.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
        this.errorablePanel.exitActiveChild();
        this.safetyLock.lockSafety();
        return super.exit();
    }
}

