/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.i18n.TextResource;
import com.ur.polyscope.driver.api.dialog.DialogWithName;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.dialog.WarningMessage;
import gui.tools.DialogCreator;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SafetyCaretakerDialogs {
    private final TextResource textResource;
    private final DialogCreator dialogCreator;

    @Inject
    public SafetyCaretakerDialogs(TextResource textResource, DialogCreator dialogCreator) {
        this.textResource = textResource;
        this.dialogCreator = dialogCreator;
    }

    public boolean hasRevertedSafetyChanges(Runnable onRevertRequested) {
        if (this.dialogCreator.showConfirmationDialog(this.revertOrCancleConfirmationMessage()) == DialogReturnValue.OK) {
            onRevertRequested.run();
            return true;
        }
        return false;
    }

    private ConfirmationMessage revertOrCancleConfirmationMessage() {
        return new ConfirmationMessage(DialogWithName.REVERT_SAFETY_CONFIGURATION.getName(), this.textResource.confirmRevertSafetySettingsOrCancelTitle(), this.textResource.confirmRevertSafetySettingsOrCancelExplanation(), this.textResource.confirmRevertSafetySettingsOrCancelAction(), this.textResource.confirmRevertSafetySettingsOrCancelCancel());
    }

    public void informUserOfRevert(final Runnable runnable) {
        this.dialogCreator.showWarningMessageDialog(this.revertConfirmationMessage(), new OkDialogListener(){

            public void onOkClicked() {
                runnable.run();
            }
        });
    }

    private WarningMessage revertConfirmationMessage() {
        return new WarningMessage(DialogWithName.REVERT_SAFETY_CONFIGURATION.getName(), this.textResource.confirmRevertSafetySettingsTitle(), this.textResource.confirmRevertSafetySettingsExplanation());
    }

    public void warnChecksumChangedForInstallation() {
        this.dialogCreator.showWarningMessageDialog(this.createChecksumChangedForInstallation(), null);
    }

    private WarningMessage createChecksumChangedForInstallation() {
        return new WarningMessage(DialogWithName.SAFETY_CHECKSUM_MAY_CHANGE.getName(), this.textResource.ChecksumChangedForInstallationTitle(), this.textResource.ChecksumChangedForInstallationText());
    }

    public void warnRobotNotSupporting3PositionSwitch() {
        this.dialogCreator.showWarningMessageDialog(this.createRobotNotSupporting3PositionSwitch(), null);
    }

    public WarningMessage createRobotNotSupporting3PositionSwitch() {
        return new WarningMessage(this.textResource.RobotDoesNotSupport3PositionSwitchTitle(), this.textResource.RobotDoesNotSupport3PositionSwitchText());
    }

    public DialogReturnValue applyOrCancelSafety() {
        return this.dialogCreator.showConfirmationDialog(this.confirmApplySafetySettingsOrCancel());
    }

    public DialogReturnValue applyOrRevertSafety() {
        return this.dialogCreator.showConfirmationDialog(this.confirmApplySafetySettingsOrRevert());
    }

    private ConfirmationMessage confirmApplySafetySettingsOrCancel() {
        return new ConfirmationMessage(DialogWithName.APPLY_SAFETY_CONFIGURATION.getName(), this.textResource.confirmApplySafetySettingsOrCancelTitle(), this.textResource.confirmApplySafetySettingsOrCancelExplanation(), this.textResource.confirmApplySafetySettingsOrCancelAction(), this.textResource.confirmApplySafetySettingsOrCancelCancel());
    }

    private ConfirmationMessage confirmApplySafetySettingsOrRevert() {
        return new ConfirmationMessage(DialogWithName.APPLY_SAFETY_CONFIGURATION.getName(), this.textResource.confirmApplySafetySettingsOrRevertTitle(), this.textResource.confirmApplySafetySettingsOrRevertExplanation(), this.textResource.confirmApplySafetySettingsOrRevertAction(), this.textResource.confirmApplySafetySettingsOrRevertCancel());
    }

    public DialogReturnValue resolveErrorsOrRevertSafety() {
        return this.dialogCreator.showConfirmationDialog(this.confirmResolveSafetyErrors());
    }

    public void resolveErrorsInSafety(final Runnable onResolve) {
        this.dialogCreator.showConfirmationDialog(this.errorInSafetySetup(), new ConfirmationDialogListener(){

            public void onOkClicked() {
                onResolve.run();
            }
        });
    }

    private ConfirmationMessage errorInSafetySetup() {
        return new ConfirmationMessage(this.textResource.errorInSafetySetupTitle(), this.textResource.errorInSafetySetupExplanation(), this.textResource.confirmResolveSafetyErrorsAction(), this.textResource.Cancel());
    }

    private ConfirmationMessage confirmResolveSafetyErrors() {
        return new ConfirmationMessage(this.textResource.confirmResolveSafetyErrorsTitle(), this.textResource.confirmResolveSafetyErrorsExplanation(), this.textResource.confirmResolveSafetyErrorsAction(), this.textResource.confirmResolveSafetyErrorsCancel());
    }
}

