/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.polyscope.safety.SafetySettingsCaretaker;
import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.security.SafetyLockListener;
import com.ur.swing.ViewContext;
import com.ur.swing.help.HelpIdAssigner;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SafetyControlsCard
extends JPanel
implements ActionListener {
    public static final String APPLY_SETTINGS = "applySettings." + SafetyControlsCard.class.getSimpleName();
    protected SafetyLock lock;
    protected SafetySettingsCaretaker caretaker;
    protected Errorable errorable;
    protected JButton applySafetySettingsButton;
    private HelpIdAssigner helpIdAssigner;
    private final ViewContext viewContext;

    public SafetyControlsCard(SafetyLock lock, SafetySettingsCaretaker caretaker, Errorable errorable, ViewContext viewContext) {
        this.lock = lock;
        this.caretaker = caretaker;
        this.errorable = errorable;
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
        this.viewContext = viewContext;
        this.initComponents();
        this.updateEnabledStateForApplySettings();
        lock.addSafetyLockListener(new UpdateButtonWithLockState());
        errorable.addStatusListener((Errorable.StatusListener)new UpdateButtonWithErrorState());
    }

    protected void updateEnabledStateForApplySettings() {
        this.applySafetySettingsButton.setEnabled(this.errorable.getStatus() != Errorable.Status.ERROR && !this.lock.isLocked());
    }

    private void initComponents() {
        this.applySafetySettingsButton = new JButton();
        this.applySafetySettingsButton.setText(((SafetyTextResource)this.viewContext.getTextResource(SafetyTextResource.class)).applySettings());
        this.applySafetySettingsButton.setName(APPLY_SETTINGS);
        this.applySafetySettingsButton.addActionListener(this);
        this.applySafetySettingsButton.setEnabled(true);
        this.setLayout(new FlowLayout(2));
        this.add(this.applySafetySettingsButton);
        this.helpIdAssigner.assignHelpId((JComponent)this.applySafetySettingsButton, "gui:installation_safety_apply");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.caretaker.applyChangesToController(SafetySettingsCaretaker.AskUserToApply.OR_CANCEL, true);
    }

    public JButton getApplyButton() {
        return this.applySafetySettingsButton;
    }

    private final class UpdateButtonWithErrorState
    implements Errorable.StatusListener {
        private UpdateButtonWithErrorState() {
        }

        public void statusChanged(Errorable.Status status) {
            SafetyControlsCard.this.updateEnabledStateForApplySettings();
        }
    }

    private final class UpdateButtonWithLockState
    implements SafetyLockListener {
        private UpdateButtonWithLockState() {
        }

        @Override
        public void doUnlock() {
            SafetyControlsCard.this.updateEnabledStateForApplySettings();
        }

        @Override
        public void doLock() {
            SafetyControlsCard.this.updateEnabledStateForApplySettings();
        }
    }
}

