/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.resources.ViewImageResource;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.security.SafetyLockListener;
import com.ur.swing.IconProvider;
import com.ur.swing.SwingUtil;
import com.ur.util.event.EventNotificationService;
import com.ur.util.swing.CompoundIcon;
import com.ur.util.swing.EmptyIcon;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

public class SafetyIconProvider
implements IconProvider<Object> {
    private final SafetyLock safetyLock;
    private final Errorable errorable;
    private SafetySettingsLookupService lookupService;

    public SafetyIconProvider(final Container container, SafetySettingsLookupService lookupService, SafetyLock safetyLock, Errorable errorable) {
        this.lookupService = lookupService;
        this.safetyLock = safetyLock;
        this.errorable = errorable;
        errorable.addStatusListener(status -> container.repaint());
        this.safetyLock.addSafetyLockListener(new SafetyLockListener(){

            @Override
            public void doUnlock() {
                container.repaint();
            }

            @Override
            public void doLock() {
                container.repaint();
            }
        });
        final UpdateSynchronizedSafetyOnChange propertyChangeListener = new UpdateSynchronizedSafetyOnChange(container);
        EventNotificationService.register((Object)this, SafetyChangeListener.class, (Object)new SafetyChangeListener.Template(){

            @Override
            public void safetyOnControllerUpdated(SafetySetup setup, SafetySetup previousSetup) {
                SwingUtil.invokeLater(() -> container.repaint());
            }

            @Override
            public void safetyLoaded(SafetySetup setup) {
                SwingUtil.invokeLater(() -> {
                    setup.addPropertyChangeListener((PropertyChangeListener)propertyChangeListener);
                    container.repaint();
                });
            }
        });
        lookupService.getSafetySetup().addPropertyChangeListener((PropertyChangeListener)propertyChangeListener);
    }

    public Icon getIcon(Object value) {
        Icon baseIcon;
        boolean formWarning = this.errorable.getStatus() == Errorable.Status.WARNING;
        boolean formError = this.errorable.getStatus() == Errorable.Status.ERROR;
        boolean hasSafetySetupBeenAltered = this.lookupService.getCaretaker().hasSafetySetupBeenAltered();
        Icon icon = baseIcon = hasSafetySetupBeenAltered ? ViewImageResource.safetyNotSynchronized() : ViewImageResource.safetySynchronized();
        Icon superScriptIcon = formError ? ViewImageResource.formError() : (formWarning ? ViewImageResource.formWarning() : EmptyIcon._12X12);
        Icon subScriptIcon = this.safetyLock.isLocked() ? ViewImageResource.lock12x12() : EmptyIcon._12X12;
        return new CompoundIcon(2, baseIcon, superScriptIcon, subScriptIcon);
    }

    private static final class UpdateSynchronizedSafetyOnChange
    implements PropertyChangeListener {
        private final Container container;

        private UpdateSynchronizedSafetyOnChange(Container container) {
            this.container = container;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.container.repaint();
        }
    }
}

