/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.lang.StringUtils;
import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.JointType;
import com.ur.monitor.model.Pose6d;
import com.ur.move.JointPositionMessageProvider;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.boundaries.externalapi.BoundaryPlaneVisualizationStrategy;
import com.ur.safety.boundaries.externalapi.ToolOrientationVisualizationStrategy;
import com.ur.safety.generallimits.core.SafetyLimits;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.util.domain.Q;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.util.Optional;
import javax.inject.Inject;

public class SafetyMessageProvider
implements JointPositionMessageProvider {
    private static final UnitsConverter DEG_CONVERTER = Units.getDegreesConverter();
    private static final String degUnits = DEG_CONVERTER.getUnit();
    private static final double JOINT_LIMIT_PROXIMITY_THRESHOLD = DEG_CONVERTER.convertTo(2.0);
    private final SafetySettingsLookupService safetySettingsProvider;
    private final SafetyTextResource textResource;
    private final ToolOrientationVisualizationStrategy orientationVisualizationStrategy;
    private final BoundaryPlaneVisualizationStrategy planeVisualizationStrategy;

    @Inject
    private SafetyMessageProvider(SafetySettingsLookupService safetySettingsProvider, SafetyTextResource textResource, ToolOrientationVisualizationStrategy orientationVisualizationStrategy, BoundaryPlaneVisualizationStrategy planeVisualizationStrategy) {
        this.safetySettingsProvider = safetySettingsProvider;
        this.textResource = textResource;
        this.orientationVisualizationStrategy = orientationVisualizationStrategy;
        this.planeVisualizationStrategy = planeVisualizationStrategy;
    }

    public String getWarningMessage(JointPositionVector jointPositions, Pose6d toolPose) {
        Pose6d currentTcpOffset;
        if (!this.safetySettingsProvider.getControllerSafetySetup().isPresent()) {
            return "";
        }
        Optional<SafetySetup> safetySetup = this.safetySettingsProvider.getControllerSafetySetup();
        String boundaryWarningMessage = this.getBoundaryPlaneWarningMessage(safetySetup, toolPose, currentTcpOffset = RobotState.getLatestRobotState().tcpOffset);
        if (StringUtils.isNullOrEmpty((String)boundaryWarningMessage)) {
            boundaryWarningMessage = this.getToolBoundaryWarningMessage(safetySetup, toolPose, currentTcpOffset);
        }
        if (StringUtils.isNullOrEmpty((String)boundaryWarningMessage)) {
            return this.getSafetyJointLimitWarningMessage(jointPositions);
        }
        return boundaryWarningMessage;
    }

    private String getToolBoundaryWarningMessage(Optional<SafetySetup> safetySetup, Pose6d toolPose, Pose6d currentTcpOffset) {
        ToolOrientationVisualizationStrategy.OrientationLimitProximity proximity = ToolOrientationVisualizationStrategy.OrientationLimitProximity.WELL_WITHIN_THE_LIMIT;
        if (safetySetup.isPresent()) {
            proximity = this.orientationVisualizationStrategy.getLimitProximity((SafetySetup)safetySetup.get(), toolPose, currentTcpOffset);
        }
        switch (proximity) {
            case LIMIT_VIOLATED: {
                return this.textResource.targetViolatesSafetyBoundary();
            }
            case CRITICALLY_CLOSE_TO_LIMIT: 
            case CLOSE_TO_LIMIT: {
                return this.textResource.targetCloseToSafetyBoundary();
            }
        }
        return "";
    }

    private String getBoundaryPlaneWarningMessage(Optional<SafetySetup> safetySetup, Pose6d toolPose, Pose6d currentTcpOffset) {
        BoundaryPlaneVisualizationStrategy.PlaneProximity proximity = BoundaryPlaneVisualizationStrategy.PlaneProximity.WELL_WITHIN_THE_LIMIT;
        if (safetySetup.isPresent()) {
            SafetyBoundaries boundaries = (SafetyBoundaries)((SafetySetup)safetySetup.get()).getComponent(SafetyBoundaries.class);
            proximity = this.planeVisualizationStrategy.getLimitProximity(boundaries, toolPose, currentTcpOffset);
        }
        switch (proximity) {
            case LIMIT_VIOLATED: {
                return this.textResource.targetViolatesSafetyBoundary();
            }
            case CRITICALLY_CLOSE_TO_LIMIT: 
            case CLOSE_TO_LIMIT: {
                return this.textResource.targetCloseToSafetyBoundary();
            }
        }
        return "";
    }

    private String getSafetyJointLimitWarningMessage(JointPositionVector jointPositionVector) {
        Optional<SafetyLimitsComponent> safetyLimitsComponent = this.safetySettingsProvider.getControllerComponent(SafetyLimitsComponent.class);
        if (!safetyLimitsComponent.isPresent()) {
            return "";
        }
        SafetyLimits safetyLimits = SafetySetup.isReducedModeEnabled() ? ((SafetyLimitsComponent)safetyLimitsComponent.get()).getReducedLimits() : ((SafetyLimitsComponent)safetyLimitsComponent.get()).getNormalLimits();
        JointType jointTypeCloseToLimit = null;
        boolean isCloseMinimumLimit = false;
        double distance = 0.0;
        Q minJointVector = safetyLimits.getMinJointVector();
        Q maxJointVector = safetyLimits.getMaxJointVector();
        JointType[] jointTypeArray = JointType.values();
        int n = jointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JointType jointType = jointTypeArray[n2];
            double jointPosition = jointPositionVector.getJoint(jointType);
            distance = jointPosition - minJointVector.getJoint(jointType).getTotalAngle();
            if (distance <= JOINT_LIMIT_PROXIMITY_THRESHOLD) {
                jointTypeCloseToLimit = jointType;
                isCloseMinimumLimit = true;
                break;
            }
            distance = maxJointVector.getJoint(jointType).getTotalAngle() - jointPosition;
            if (distance <= JOINT_LIMIT_PROXIMITY_THRESHOLD) {
                jointTypeCloseToLimit = jointType;
                break;
            }
            ++n2;
        }
        if (jointTypeCloseToLimit != null) {
            String jointName = this.textResource.joint((Enum<JointType>)jointTypeCloseToLimit);
            double distanceDegrees = DEG_CONVERTER.convertFrom(distance);
            if (distance < 0.0) {
                return isCloseMinimumLimit ? this.textResource.targetViolatesJointMinimumLimit(jointName, distanceDegrees, degUnits) : this.textResource.targetViolatesJointMaximumLimit(jointName, distanceDegrees, degUnits);
            }
            return isCloseMinimumLimit ? this.textResource.targetCloseToJointMinimumLimit(jointName, distanceDegrees, degUnits) : this.textResource.targetCloseToJointMaximumLimit(jointName, distanceDegrees, degUnits);
        }
        return "";
    }
}

