/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.viewfacade.safety.SafetySettingsComparator;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.util.Optional;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;

public class SafetySettingsComparatorImpl
implements SafetySettingsComparator {
    private SafetySettingsLookupService safetyProvider;

    @Inject
    SafetySettingsComparatorImpl(SafetySettingsLookupService safetyProvider) {
        this.safetyProvider = safetyProvider;
    }

    private SafetySetup getSafetySetup(Installation loadedInstallation) {
        return loadedInstallation != null ? (SafetySetup)loadedInstallation.getComponent(SafetySetup.class) : null;
    }

    public boolean isControllerSafetySettingDifferent(Installation installation) {
        Optional<SafetySetup> controllerSafetySetup = this.safetyProvider.getControllerSafetySetup();
        if (controllerSafetySetup.isPresent()) {
            String controllerCRC;
            SafetySetup safetySetup = this.getSafetySetup(installation);
            String guiCRC = this.safetyProvider.generateChecksum(safetySetup);
            return !EqualsUtil.equals((Object)guiCRC, (Object)(controllerCRC = this.safetyProvider.generateChecksum((SafetySetup)controllerSafetySetup.get()))) || !((SafetyBoundaries)((SafetySetup)controllerSafetySetup.get()).getComponent(SafetyBoundaries.class)).isValidGuiConfiguration();
        }
        return false;
    }

    public Set<InstallationComponent> createInstallationComponentsWithExistingSafety(InstallationComponentLookup componentLookup) {
        SafetySetup oldSafetySetup = (SafetySetup)componentLookup.getComponent(SafetySetup.class);
        HashSet<InstallationComponent> installationComponents = new HashSet<InstallationComponent>();
        installationComponents.add((InstallationComponent)oldSafetySetup);
        return installationComponents;
    }
}

