/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.disk.Directories;
import com.ur.i18n.TextResource;
import com.ur.lang.EqualsUtil;
import com.ur.log.logentry.robotmessage.RobotMessageProducer;
import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.OptionsSection;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.safety.SafetySettingsCaretaker;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.SafetySetupComponent;
import com.ur.polyscope.safety.SafetySetupErrorListener;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.polyscope.safety.checksum.SafetyFeatureSupport;
import com.ur.polyscope.safety.checksum.SafetyFeatureSupportListener;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.polyscope.safety.version.SafetyControlBoardVersionSite;
import com.ur.polyscope.viewfacade.lang.ErrorablePanel;
import com.ur.polyscope.viewfacade.safety.SafetyTabNavigationEvent;
import com.ur.safety.SafetyCaretakerDialogs;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.SafetyEndianConverter;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetySetupErrorListenerImpl;
import com.ur.safety.SafetyWriterUtils;
import com.ur.safety.Settings;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.checksum.ChecksumGenerator;
import com.ur.safety.checksum.SafetyChecksumGenerator;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_1_0;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_3_1;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_3_2;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_5_0;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_5_10;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_5_11;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_5_2;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_5_3;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_5_4;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_5_5;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_5_6;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_5_7;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_5_8;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_5_9;
import com.ur.safety.io.AbstractSafetyIOConfiguration;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOInputFunction;
import com.ur.safety.safehome.SafeHomeConfiguration;
import com.ur.safety.tolerances.SafetyComplianceTolerances;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.util.Optional;
import com.ur.util.event.EventManager;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import gui.tools.URFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class SafetySettingsLookupServiceImpl
implements SafetySettingsLookupService,
SafetySettingsCaretaker {
    private static final Logger LOG = LogFactory.createLogger(SafetySettingsLookupServiceImpl.class);
    private final SafetyComplianceTolerances tolerances = new SafetyComplianceTolerances();
    private final Map<ChecksumVersion, SafetyChecksumGenerator> generators = new HashMap<ChecksumVersion, SafetyChecksumGenerator>();
    private final InstallationComponentLookup installationLookupService;
    private final SafetyControlBoardVersionSite versionSite;
    private final Provider<SafetySetup> safetySetupProvider;
    private final TextResource textResource;
    private final ChecksumGenerator checksumGenerator;
    private final ErrorablePanel errorablePanel;
    private final EventManager eventManager;
    private final ControllerInterface controllerInterface;
    private final SafetyCaretakerDialogs safetyCaretakerDialogs;
    private SafetySetup safetySetupFromController;
    private Boolean onMac;

    @Inject
    SafetySettingsLookupServiceImpl(InstallationComponentLookup installationLookupService, SafetyControlBoardVersionSite versionSite, Provider<SafetySetup> safetySetupProvider, SafetyEndianConverter safetyEndianConverter, ControllerInterface controllerInterface, RobotConfigurationProvider robot, TextResource textResource, SafetyCaretakerDialogs safetyCaretakerDialogs, ChecksumGenerator checksumGenerator, ErrorablePanel errorablePanel, EventManager eventManager) {
        this.installationLookupService = installationLookupService;
        this.versionSite = versionSite;
        this.safetySetupProvider = safetySetupProvider;
        this.controllerInterface = controllerInterface;
        this.textResource = textResource;
        this.errorablePanel = errorablePanel;
        this.eventManager = eventManager;
        this.safetyCaretakerDialogs = safetyCaretakerDialogs;
        this.generators.put(null, SafetyChecksumGenerator.NULL);
        this.generators.put(ChecksumVersion.NULL, SafetyChecksumGenerator.NULL);
        this.generators.put(ChecksumVersion.VERSION_1_0, new SafetyChecksumGenerator_1_0(robot.getRobotChecksum()));
        this.generators.put(ChecksumVersion.VERSION_3_1, new SafetyChecksumGenerator_3_1(robot.getRobotChecksum()));
        this.generators.put(ChecksumVersion.VERSION_3_2, new SafetyChecksumGenerator_3_2(robot.getRobotChecksum()));
        this.generators.put(ChecksumVersion.VERSION_5_0, new SafetyChecksumGenerator_5_0(safetyEndianConverter, robot.getRobotChecksum()));
        this.generators.put(ChecksumVersion.VERSION_5_2, new SafetyChecksumGenerator_5_2(safetyEndianConverter, robot.getRobotChecksum()));
        this.generators.put(ChecksumVersion.VERSION_5_3, new SafetyChecksumGenerator_5_3(safetyEndianConverter, robot.getRobotChecksum()));
        this.generators.put(ChecksumVersion.VERSION_5_4, new SafetyChecksumGenerator_5_4(safetyEndianConverter, robot.getRobotChecksum()));
        this.generators.put(ChecksumVersion.VERSION_5_5, new SafetyChecksumGenerator_5_5(safetyEndianConverter, robot.getRobotChecksum()));
        this.generators.put(ChecksumVersion.VERSION_5_6, new SafetyChecksumGenerator_5_6(safetyEndianConverter, robot.getRobotChecksum()));
        this.generators.put(ChecksumVersion.VERSION_5_7, new SafetyChecksumGenerator_5_7(safetyEndianConverter, robot.getRobotChecksum()));
        this.generators.put(ChecksumVersion.VERSION_5_8, new SafetyChecksumGenerator_5_8(safetyEndianConverter, robot.getRobotChecksum()));
        this.generators.put(ChecksumVersion.VERSION_5_9, new SafetyChecksumGenerator_5_9(safetyEndianConverter, robot.getRobotChecksum()));
        this.generators.put(ChecksumVersion.VERSION_5_10, new SafetyChecksumGenerator_5_10(safetyEndianConverter, robot.getRobotChecksum()));
        this.generators.put(ChecksumVersion.VERSION_5_11, new SafetyChecksumGenerator_5_11(safetyEndianConverter, robot.getRobotChecksum()));
        this.checksumGenerator = checksumGenerator;
        EventNotificationService.register((Object)this, SafetyFeatureSupportListener.class, (Object)new RestartSCBIfNecessary());
        EventNotificationService.register((Object)this, SafetySetupErrorListener.class, (Object)new SafetySetupErrorListenerImpl(errorablePanel));
    }

    @Override
    public Map<ChecksumVersion, SafetyChecksumGenerator> getGenerators() {
        return this.generators;
    }

    @Override
    public <T extends SafetySetupComponent> T getSafetyComponent(Class<T> safetySetupComponent) {
        if (this.getSafetySetup() == null) {
            return null;
        }
        return (T)this.getSafetySetup().getComponent(safetySetupComponent);
    }

    @Override
    public <T extends SafetySetupComponent> Optional<T> getControllerComponent(Class<T> safetyComponentClass) {
        Optional<SafetySetup> safetySetup = this.getControllerSafetySetup();
        if (safetySetup.isPresent()) {
            return Optional.of((Object)((SafetySetup)safetySetup.get()).getComponent(safetyComponentClass));
        }
        return Optional.empty();
    }

    @Override
    public SafetySetup getSafetySetup() {
        return this.installationLookupService.hasInstallation() ? (SafetySetup)this.installationLookupService.getComponent(SafetySetup.class) : null;
    }

    @Override
    public Optional<SafetySetup> getControllerSafetySetup() {
        return this.safetySetupFromController == null ? Optional.empty() : Optional.of((Object)this.safetySetupFromController);
    }

    @Override
    public SafetyComplianceTolerances getSafetyComplianceTolerances() {
        return this.tolerances;
    }

    @Override
    public SafetySettingsCaretaker getCaretaker() {
        return this;
    }

    public boolean canRevert() {
        Optional<SafetySetup> optionalControllerSafetySetup = this.getControllerSafetySetup();
        if (optionalControllerSafetySetup.isPresent()) {
            SafetySetup controllerSafetySetup = (SafetySetup)optionalControllerSafetySetup.get();
            return this.isControllerSafetySettingsDifferentFromPolyScopeSafetySettings(controllerSafetySetup);
        }
        return false;
    }

    private boolean isControllerSafetySettingsDifferentFromPolyScopeSafetySettings(SafetySetup controllerSafetySetup) {
        Options controllerOptions = new Options();
        controllerSafetySetup.copyTo(controllerOptions);
        Options polyscopeOptions = new Options();
        this.getSafetySetup().copyTo(polyscopeOptions);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(controllerOptions.getKeys(), 16), false).anyMatch(sectionKey -> this.safetySectionIsDifferent((String)sectionKey, controllerOptions, polyscopeOptions));
    }

    private boolean safetySectionIsDifferent(String sectionKey, Options controllerOptions, Options polyscopeOptions) {
        OptionsSection controllerSection = controllerOptions.getSection(sectionKey);
        OptionsSection polyscopeSection = polyscopeOptions.getSection(sectionKey);
        return controllerSection.getKeys().stream().anyMatch(key -> !controllerSection.getString(key).equals(polyscopeSection.getString(key)));
    }

    public void resetControllerWithSafetySetup(SafetySetup oldSetup) {
        this.revertToControllerState(oldSetup);
        this.applyChangesToController(SafetySettingsCaretaker.AskUserToApply.NO_CONFIRMATION, false);
    }

    public void revertToControllerState() {
        Optional<SafetySetup> controllerSafetySetup = this.getControllerSafetySetup();
        if (controllerSafetySetup.isPresent()) {
            this.revertToControllerState((SafetySetup)controllerSafetySetup.get());
        } else {
            this.revertToControllerState(null);
        }
    }

    private void revertToControllerState(SafetySetup controller) {
        if (controller == null) {
            this.safetySetupFromController = null;
            return;
        }
        SafetySetup polyscope = this.getSafetySetup();
        Options options = new Options();
        controller.copyTo(options);
        polyscope.readFrom(options);
        EventNotificationService.notify(SafetyChangeListener.class, listener -> listener.safetyLoaded(polyscope));
        ((VersionComponent)polyscope.getComponent(VersionComponent.class)).setVerified(options);
    }

    public void setSafetySetupFromController(SafetySetup controllerSafetySetup) {
        SafetySetup previousSetupFromController = this.safetySetupFromController;
        this.safetySetupFromController = controllerSafetySetup;
        if (this.hasSafetySetupBeenAltered()) {
            FileUtils.writeToFile((String)controllerSafetySetup.writeAsString(), (File)new File(Directories.urcontrol(), "from_controller_safety.conf"));
            Log.error((String)"Safety has been altered");
            EventNotificationService.notify(SafetyChangeListener.class, SafetyChangeListener::safetyMismatchWithController);
        } else {
            Options options = new Options();
            ((SafetySetup)this.installationLookupService.getComponent(SafetySetup.class)).copyTo(options);
            SafetySetup copyOfOriginalSafetySetup = (SafetySetup)this.safetySetupProvider.get();
            ((VersionComponent)copyOfOriginalSafetySetup.getComponent(VersionComponent.class)).setChecksumVersion(((VersionComponent)((SafetySetup)this.installationLookupService.getComponent(SafetySetup.class)).getComponent(VersionComponent.class)).getChecksumVersion());
            copyOfOriginalSafetySetup.readFrom(options);
            this.safetySetupFromController = copyOfOriginalSafetySetup;
            EventNotificationService.notify(SafetyChangeListener.class, listener -> listener.safetyOnControllerUpdated(copyOfOriginalSafetySetup, previousSetupFromController));
        }
        new RobotMessageProducer().generateAndNotify(String.valueOf(this.textResource.safetyChecksumChangeMessage()) + " " + this.checksumGenerator.generateCheckSum(controllerSafetySetup).getString());
    }

    public boolean revertChanges(SafetySettingsCaretaker.AskUserToRevert askUserToRevert) {
        if (askUserToRevert == SafetySettingsCaretaker.AskUserToRevert.OR_CANCEL) {
            return this.safetyCaretakerDialogs.hasRevertedSafetyChanges(this::revertToControllerState);
        }
        this.safetyCaretakerDialogs.informUserOfRevert(this::revertToControllerState);
        return true;
    }

    public boolean applyOrRevertChangesToController(boolean updateVersion) {
        if (this.doesSafetyHaveErrors()) {
            return false;
        }
        return this.applyOrRevert(updateVersion);
    }

    private boolean doesSafetyHaveErrors() {
        if (!this.errorablePanel.hasErrors()) {
            return false;
        }
        if (this.canRevert()) {
            if (this.safetyCaretakerDialogs.resolveErrorsOrRevertSafety() == DialogReturnValue.OK) {
                this.navigateToSafetyPanelWithError();
            } else {
                this.revertToControllerState();
            }
        } else {
            this.safetyCaretakerDialogs.resolveErrorsInSafety(this::navigateToSafetyPanelWithError);
        }
        return true;
    }

    private void navigateToSafetyPanelWithError() {
        this.errorablePanel.getFirstPanelWithErrors().ifPresent(errorable -> this.eventManager.fireEvent(SafetyTabNavigationEvent.class, safetyTabNavigationEvent -> safetyTabNavigationEvent.navigateToTab(errorable)));
    }

    private boolean applyOrRevert(boolean updateVersion) {
        boolean didApplyChanges;
        if (this.hasSafetySetupBeenAlteredInLatestVersion() && !(didApplyChanges = this.applyChangesToController(SafetySettingsCaretaker.AskUserToApply.OR_REVERT, updateVersion))) {
            this.revertToControllerState();
            return false;
        }
        return true;
    }

    public boolean applyChangesToController(SafetySettingsCaretaker.AskUserToApply informUserOfShutdown, boolean updateVersion) {
        if (this.askUserIfUpdateIsNecessary(informUserOfShutdown)) {
            this.tryApplyAndRestartSafetyControlBoard(updateVersion);
            return true;
        }
        return false;
    }

    protected void tryApplyAndRestartSafetyControlBoard(boolean updateVersion) {
        if (this.controllerInterface.isConnected()) {
            this.controllerInterface.runScript("power off");
        }
        EventNotificationService.notify(SafetyChangeListener.class, listener -> listener.safetyRequestedToBeApplied(this.getSafetySetup()));
        this.writeSafetyAndTCPConf(updateVersion);
        if (this.controllerInterface.isConnected()) {
            this.handleDockerOnMac();
            this.controllerInterface.runScript("restart scb\n");
        }
    }

    private void handleDockerOnMac() {
        if (this.isOnMac()) {
            LOG.info("MAC OS detected, sleeping for a while before continuing...", new Object[0]);
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                LOG.error("MAC OS detected, interrupted while waiting...", (Throwable)e);
            }
        }
    }

    private boolean isOnMac() {
        try {
            if (this.onMac == null) {
                this.onMac = "Mac OS X".equalsIgnoreCase(System.getProperty("os.name"));
            }
        }
        catch (Exception e) {
            this.onMac = false;
            LOG.error("Error occurred while checking platform OS", (Throwable)e);
        }
        return this.onMac;
    }

    public void writeSafetyAndTCPConf(boolean updateVersion) {
        this.ensureChecksumVersionIsCorrect(updateVersion);
        this.writeSafetyConf(this.getSafetySetup(), "safety.conf");
        this.writeTCPConf(this.getSafetySetup(), ".tcp.conf");
    }

    private boolean g5CanUpgradeVersion() {
        ChecksumVersion currentVersion = this.getSafetyComponent(VersionComponent.class).getChecksumVersion();
        return currentVersion.atLeast(Settings.getFirstG5ChecksumVersion()) && currentVersion != Settings.getLatestChecksumVersion();
    }

    private void ensureChecksumVersionIsCorrect(boolean updateVersion) {
        SafetyFeatureSupport safetyFeatureSupport = this.versionSite.getSafetyFeatureSupport();
        if (this.g5CanUpgradeVersion() && updateVersion) {
            if (this.getSafetyComponent(VersionComponent.class).isCheckSumVersionSpecified()) {
                this.informCheckSumVersionChanged(safetyFeatureSupport);
            }
            ((VersionComponent)this.getSafetySetup().getComponent(VersionComponent.class)).setCRCValue("");
            ((VersionComponent)this.getSafetySetup().getComponent(VersionComponent.class)).setChecksumVersion(Settings.getLatestChecksumVersion());
        }
        if (safetyFeatureSupport == SafetyFeatureSupport.UNKNOWN) {
            return;
        }
        ChecksumVersion latestVersion = safetyFeatureSupport.latestChecksum();
        ChecksumVersion currentVersion = this.getSafetyComponent(VersionComponent.class).getChecksumVersion();
        if (currentVersion.before(Settings.getFirstG5ChecksumVersion()) && currentVersion != latestVersion) {
            if (this.getSafetyComponent(VersionComponent.class).isCheckSumVersionSpecified()) {
                this.informCheckSumVersionChanged(safetyFeatureSupport);
            }
            if (!latestVersion.atLeast(ChecksumVersion.VERSION_3_2)) {
                this.getSafetyComponent(VersionComponent.class).setVerified(false);
                this.getSafetyComponent(SafetyIOConfiguration.class).setInput(AbstractSafetyIOConfiguration.IOPair.UNASSIGNED, SafetyIOInputFunction.THREE_POSITION_ENABLING_INPUT);
                this.getSafetyComponent(SafetyIOConfiguration.class).setInput(AbstractSafetyIOConfiguration.IOPair.UNASSIGNED, SafetyIOInputFunction.OPERATIONAL_MODE_INPUT);
            }
            ((VersionComponent)this.getSafetySetup().getComponent(VersionComponent.class)).setCRCValue("");
            ((VersionComponent)this.getSafetySetup().getComponent(VersionComponent.class)).setChecksumVersion(latestVersion);
        }
    }

    private void informCheckSumVersionChanged(SafetyFeatureSupport safetyFeatureSupport) {
        if (safetyFeatureSupport.supportsThreePositionSwitch()) {
            this.safetyCaretakerDialogs.warnChecksumChangedForInstallation();
        } else if (((SafetyIOConfiguration)this.getSafetySetup().getComponent(SafetyIOConfiguration.class)).getThreePositionEnablingInputs().equals(AbstractSafetyIOConfiguration.IOPair.UNASSIGNED)) {
            this.safetyCaretakerDialogs.warnChecksumChangedForInstallation();
        } else {
            this.safetyCaretakerDialogs.warnRobotNotSupporting3PositionSwitch();
        }
    }

    private void writeSafetyConf(SafetySetup safetySetup, String filename) {
        String contents = safetySetup.writeAsString();
        String generateChecksum = this.generateChecksum(safetySetup);
        contents = String.valueOf(contents) + SafetyWriterUtils.createHeaderLine("Checksum");
        contents = String.valueOf(contents) + SafetyWriterUtils.createContentLine("safetyParameters", generateChecksum);
        ChecksumVersion checksumVersion = ((VersionComponent)safetySetup.getComponent(VersionComponent.class)).getChecksumVersion();
        if (checksumVersion.atLeast(ChecksumVersion.VERSION_3_2)) {
            contents = String.valueOf(contents) + SafetyWriterUtils.createContentLine("majorVersion", checksumVersion.getMajor());
            contents = String.valueOf(contents) + SafetyWriterUtils.createContentLine("minorVersion", checksumVersion.getMinor());
        }
        this.writeFile(filename, contents);
        this.syncWriteFile(filename);
    }

    private void syncWriteFile(String filename) {
        String remoteFilePath = Settings.getControllerConfigurationAndSettingsPath();
        if (remoteFilePath != null) {
            String localFilePath = String.valueOf(Directories.urcontrol().getPath()) + File.separator + filename;
            try {
                URFileUtils.syncWriteFile((String)localFilePath, (String)remoteFilePath);
            }
            catch (IOException ex) {
                Log.error((String)("Failed to sync " + filename + " file"), (Throwable)ex);
            }
        }
    }

    private void writeTCPConf(SafetySetup safetySetup, String filename) {
        this.writeFile(filename, ((SafetyBoundaries)safetySetup.getComponent(SafetyBoundaries.class)).createTCPSettings());
        this.syncWriteFile(filename);
    }

    private void writeFile(String filename, String contents) {
        try {
            URFileUtils.writeFile((String)(String.valueOf(Directories.urcontrol().getPath()) + File.separator + filename), (String)contents);
        }
        catch (Exception ex) {
            Log.error((String)("Failed to update the " + filename + " file"), (Throwable)ex);
        }
    }

    public boolean hasSafetySetupBeenAlteredInLatestVersion() {
        if (this.getSafetyComponent(VersionComponent.class).getChecksumVersion().before(Settings.getFirstG5ChecksumVersion())) {
            return this.hasSafetySetupBeenAltered();
        }
        if (this.isControllerSafetySetupAvailable()) {
            String controllerCRC;
            String guiCRC = this.generateChecksumByLatestVersion(this.getSafetySetup());
            return this.isChecksumDifferent(guiCRC, controllerCRC = this.generateChecksumByLatestVersion((SafetySetup)this.getControllerSafetySetup().get())) || this.isSafetyBoundariesInvalid();
        }
        return true;
    }

    public boolean hasSafetySetupBeenAltered() {
        if (this.isControllerSafetySetupAvailable()) {
            String controllerCRC;
            String guiCRC = this.generateChecksum(this.getSafetySetup());
            return this.isChecksumDifferent(guiCRC, controllerCRC = this.generateChecksum((SafetySetup)this.getControllerSafetySetup().get())) || this.isSafetyBoundariesInvalid();
        }
        return true;
    }

    private boolean isControllerSafetySetupAvailable() {
        return this.getControllerSafetySetup().isPresent();
    }

    private boolean isChecksumDifferent(String guiCRC, String controllerCRC) {
        return !EqualsUtil.equals((Object)guiCRC, (Object)controllerCRC);
    }

    private boolean isSafetyBoundariesInvalid() {
        SafetySetup safetySetup = (SafetySetup)this.getControllerSafetySetup().get();
        return !((SafetyBoundaries)safetySetup.getComponent(SafetyBoundaries.class)).isValidGuiConfiguration();
    }

    @Override
    public boolean isSameAsActive(SafetySetup safetySetup) {
        Optional<SafetySetup> controllerSafetySetup = this.getControllerSafetySetup();
        if (controllerSafetySetup.isPresent()) {
            String toBeAppliedChecksum = this.generateChecksum(safetySetup);
            String controllerChecksum = this.generateChecksum((SafetySetup)controllerSafetySetup.get());
            return EqualsUtil.equals((Object)toBeAppliedChecksum, (Object)controllerChecksum);
        }
        return safetySetup == null;
    }

    private String generateChecksumByLatestVersion(SafetySetup safetySetup) {
        ChecksumVersion latestVersion = Settings.getLatestChecksumVersion();
        return this.generateChecksum(safetySetup, latestVersion);
    }

    @Override
    public String generateChecksum(SafetySetup safetySetup) {
        return this.generateChecksum(safetySetup, ((VersionComponent)safetySetup.getComponent(VersionComponent.class)).getChecksumVersion());
    }

    @Override
    public String generateChecksum(SafetySetup safetySetup, ChecksumVersion checksumVersion) {
        SafetyChecksumGenerator generator = this.generators.get(checksumVersion);
        return generator.generateChecksum(safetySetup);
    }

    protected boolean askUserIfUpdateIsNecessary(SafetySettingsCaretaker.AskUserToApply informUserOfShutdown) {
        DialogReturnValue result = DialogReturnValue.OK;
        switch (informUserOfShutdown) {
            case OR_CANCEL: {
                result = this.safetyCaretakerDialogs.applyOrCancelSafety();
                break;
            }
            case OR_REVERT: {
                result = this.safetyCaretakerDialogs.applyOrRevertSafety();
            }
        }
        return result == DialogReturnValue.OK;
    }

    public boolean isSafeHomeEnabled() {
        return this.getSafetyComponent(SafeHomeConfiguration.class).isEnabled();
    }

    public float[] getSafeHomePosition() {
        return this.getSafetyComponent(SafeHomeConfiguration.class).getSafeHomePosition();
    }

    public boolean isSafeHomeSyncedToHome(JointPositionVector homePositionVector) {
        return this.getSafetyComponent(SafeHomeConfiguration.class).isSafeHomeSyncedToHome(homePositionVector);
    }

    public int[] getSafeHomeOutputs() {
        SafetyIOConfiguration safetyIOConfiguration = this.getSafetyComponent(SafetyIOConfiguration.class);
        return new int[]{safetyIOConfiguration.getSafeHomeOutputs().getA(), safetyIOConfiguration.getSafeHomeOutputs().getB()};
    }

    public boolean isSafeHomeAssignedToOutputs() {
        return this.getSafetyComponent(SafetyIOConfiguration.class).getSafeHomeOutputs().isAssigned();
    }

    private class RestartSCBIfNecessary
    implements SafetyFeatureSupportListener {
        private RestartSCBIfNecessary() {
        }

        public void safetyFeatureSupportChanged(SafetyFeatureSupport newSafetyFeatureSupport) {
            SafetySetup setup = SafetySettingsLookupServiceImpl.this.getSafetySetup();
            if (setup != null) {
                ChecksumVersion setupChecksum = ((VersionComponent)setup.getComponent(VersionComponent.class)).getChecksumVersion();
                boolean setupRequiures3PSSupport = SafetyFeatureSupport.supportsThreePositionSwitch((ChecksumVersion)setupChecksum);
                boolean newSafetySupports3PS = newSafetyFeatureSupport.supportsThreePositionSwitch();
                if (newSafetySupports3PS != setupRequiures3PSSupport) {
                    SafetySettingsLookupServiceImpl.this.tryApplyAndRestartSafetyControlBoard(false);
                }
            }
        }
    }
}

