/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.HTMLPage;
import com.ur.safety.SafetySetupPanesLookAndFeel;
import com.ur.safety.SafetySetupToHtmlRenderer;
import com.ur.swing.dialog.MultiPaneMessagePanelFactory;
import com.ur.util.swing.HTML;
import java.awt.Color;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SafetySetupPanesRenderer {
    private final SafetySetupToHtmlRenderer htmlRenderer;
    private final SafetySetupPanesLookAndFeel lookAndFeel;

    @Inject
    public SafetySetupPanesRenderer(SafetySetupToHtmlRenderer htmlRenderer, SafetySetupPanesLookAndFeel lookAndFeel) {
        this.htmlRenderer = htmlRenderer;
        this.lookAndFeel = lookAndFeel;
    }

    public Iterable<MultiPaneMessagePanelFactory.Pane> generateMultiPaneMessage(SafetySetup safetySetup) {
        Iterable<HTMLPage> safetyAsHTML = this.htmlRenderer.generateContent(safetySetup);
        ArrayList<MultiPaneMessagePanelFactory.Pane> panes = new ArrayList<MultiPaneMessagePanelFactory.Pane>();
        for (HTMLPage each : safetyAsHTML) {
            JPanel panel = new JPanel();
            JLabel pageContent = new JLabel(HTML.html((String)HTML.maxWidth((int)this.lookAndFeel.panelWidth, (String)each.getContent())));
            pageContent.setVerticalAlignment(0);
            pageContent.setHorizontalAlignment(0);
            panel.add(pageContent);
            panel.setBackground(Color.WHITE);
            panel.setName(each.getPageTitle());
            panes.add(new MultiPaneMessagePanelFactory.Pane(each.getPageTitle(), (JComponent)panel));
        }
        return panes;
    }

    public void setDisplayUnits(SafetySetupToHtmlRenderer.DisplayUnits displayUnits) {
        this.htmlRenderer.setDisplayUnits(displayUnits);
    }
}

