/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.HTMLPage;
import com.ur.safety.SafetySetupToHtmlContribution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;

public class SafetySetupToHtmlRenderer {
    private final Set<SafetySetupToHtmlContribution> contributions;
    private boolean useSIUnits;

    @Inject
    public SafetySetupToHtmlRenderer(Set<SafetySetupToHtmlContribution> contributions) {
        this.contributions = contributions;
        this.setDisplayUnits(null);
    }

    public void setDisplayUnits(DisplayUnits unitsToDisplay) {
        this.useSIUnits = unitsToDisplay == DisplayUnits.UNCONVERTED;
    }

    public Iterable<HTMLPage> generateContent(SafetySetup safetySetup) {
        ArrayList<HTMLPage> pages = new ArrayList<HTMLPage>();
        for (SafetySetupToHtmlContribution each : this.contributions) {
            pages.add(each.createContributedPage(safetySetup, this.useSIUnits));
        }
        return Collections.unmodifiableList(pages);
    }

    public static enum DisplayUnits {
        UNCONVERTED,
        CONVERTED;

    }
}

