/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.lang.persist.WriteableModuleSettings;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.polyscope.valueobjects.converters.UnitType;
import com.ur.swing.LanguageConfiguration;

public final class Settings {
    private static final String LATEST_CHECKSUM_VERSION = "latestChecksumVersion";
    private static final String CONTROLLER_CONFIGURATION_AND_SETTINGS_PATH = "controllerConfigAndSettingsPath";
    private static final String PROFISAFE_ENABLED = "profisafeEnabled";
    public static final String DYNAMIC_SAFETY_LIMITS_ENABLED = "dynamicSafetyEnabled";
    private static final WriteableModuleSettings safetySettings = new WriteableModuleSettings("safety.properties");

    private Settings() {
    }

    public static ChecksumVersion getFirstG5ChecksumVersion() {
        return ChecksumVersion.VERSION_5_0;
    }

    public static ChecksumVersion getLatestChecksumVersion() {
        ChecksumVersion latestVersion = VersionComponent.LATEST_VERSION;
        if (safetySettings.properties().containsKey(LATEST_CHECKSUM_VERSION)) {
            String safetyVersionFromProperties = safetySettings.properties().getProperty(LATEST_CHECKSUM_VERSION, latestVersion.toString());
            return ChecksumVersion.fromString((String)safetyVersionFromProperties);
        }
        if (latestVersion.before(ChecksumVersion.VERSION_5_9) && Settings.isDynamicSafetyLimitsEnabled()) {
            return ChecksumVersion.VERSION_5_9;
        }
        return latestVersion;
    }

    public static String getControllerConfigurationAndSettingsPath() {
        return safetySettings.properties().getProperty(CONTROLLER_CONFIGURATION_AND_SETTINGS_PATH, null);
    }

    public static LanguageConfiguration.SupportedLanguage getLanguage() {
        return com.ur.view.Settings.getLanguage();
    }

    public static UnitType getUnits() {
        return com.ur.view.Settings.getUnits();
    }

    public static boolean isRunningInDevelopmentMode() {
        return com.ur.view.Settings.isRunningInDevelopmentMode();
    }

    public static void setUnitsForTesting(UnitType units) {
        com.ur.view.Settings.setUnitsForTesting((UnitType)units);
    }

    public static boolean isProfisafeEnabled() {
        return Boolean.parseBoolean(safetySettings.properties().getProperty(PROFISAFE_ENABLED, "true"));
    }

    public static boolean isDynamicSafetyLimitsEnabled() {
        return Boolean.parseBoolean(safetySettings.properties().getProperty(DYNAMIC_SAFETY_LIMITS_ENABLED, "false"));
    }
}

