/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety;

import com.ur.injection.Builder;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumListener;
import com.ur.polyscope.safety.checksum.ChecksumService;
import com.ur.safety.ActiveSafetyChecksumChanged;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetySetupPanesRenderer;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.SafetyToolTip;
import com.ur.safety.checksum.SafetyChecksumIconFactory;
import com.ur.swing.ActionDefinition;
import com.ur.swing.BindingRegistration;
import com.ur.swing.TooltipFactory;
import com.ur.swing.dialog.InformationMessage;
import com.ur.swing.dialog.MultiPaneMessagePanelFactory;
import com.ur.util.Optional;
import com.ur.util.event.EventManager;
import gui.tools.DialogCreator;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.JComponent;

public class ShowActiveSafetyLimitsAction
extends AbstractAction
implements SafetyToolTip {
    private BindingRegistration messageRegistration = BindingRegistration.NULL_REGISTRATION;
    private JComponent component;
    private TooltipFactory tooltipFactory;
    private final SafetySetupPanesRenderer panesRenderer;
    private final SafetySettingsLookupService safetySettingsLookupService;
    private final Builder builder;
    private final SafetyTextResource textResource;
    private final DialogCreator dialogCreator;

    @Inject
    public ShowActiveSafetyLimitsAction(SafetySetupPanesRenderer panesRenderer, SafetySettingsLookupService safetySettingsLookupService, EventManager eventManager, ChecksumService checksumService, Builder builder, TooltipFactory tooltipFactory, SafetyTextResource textResource, DialogCreator dialogCreator, SafetyChecksumIconFactory safetyChecksumIconFactory) {
        this.panesRenderer = panesRenderer;
        this.safetySettingsLookupService = safetySettingsLookupService;
        this.builder = builder;
        this.tooltipFactory = tooltipFactory;
        this.textResource = textResource;
        this.dialogCreator = dialogCreator;
        this.putValue("Function", ActionDefinition.Function.APPLICATION_HEADER);
        this.putValue("HelpId", "gui:safety_checksum");
        ActiveSafetyChecksumChanged listener = new ActiveSafetyChecksumChanged(this, checksumService, textResource, safetyChecksumIconFactory);
        listener.update();
        eventManager.addWeakListener((Object)this, ActiveSafetyChecksumListener.class, (Object)listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Optional<SafetySetup> safetySetup = this.safetySettingsLookupService.getControllerSafetySetup();
        if (safetySetup.isPresent()) {
            Iterable<MultiPaneMessagePanelFactory.Pane> panes = this.panesRenderer.generateMultiPaneMessage((SafetySetup)safetySetup.get());
            InformationMessage message = new InformationMessage(this.textResource.activeSafetyLimitsTitle(), "", this.textResource.Close());
            this.dialogCreator.showMultiPaneInformationDialog((MultiPaneMessagePanelFactory)this.builder.get(MultiPaneMessagePanelFactory.class), message, panes, null);
        }
    }

    public void setComponent(JComponent component) {
        this.component = component;
    }

    @Override
    public void showTooltip(String message) {
        boolean componentEnabled = this.component.isEnabled();
        this.component.setEnabled(true);
        this.messageRegistration.removeRegistration();
        this.messageRegistration = this.tooltipFactory.showInformationTooltipCloseAnyClick(this.component, message);
        this.component.setEnabled(componentEnabled);
    }
}

