/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.core;

import com.ur.lang.EqualsBuilder;
import com.ur.lang.EqualsUtil;
import com.ur.lang.HashCodeBuilder;
import com.ur.math.Length;
import com.ur.monitor.RobotState;
import com.ur.monitor.model.Pose6d;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.geomfeature.BaseSpatialFeature;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.boundaries.core.FeatureConfigurableLimit;
import com.ur.safety.boundaries.core.HessianNormalFormPlane;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Vector3d;

public class BoundaryPlane
extends FeatureConfigurableLimit {
    public static final Extension NULL_EXTENSION = new Extension(){

        @Override
        public void setBoundaryPlane(BoundaryPlane boundaryPlane) {
        }

        @Override
        public void clear() {
        }

        @Override
        public void copyFromGeomFeature(GeomFeature feature) {
        }
    };
    private String name;
    private Length displacement;
    private HessianNormalFormPlane hessianNormalFormPlane;
    private final List<Extension> extensions = new ArrayList<Extension>();

    public BoundaryPlane(SafetyLimitMode mode, String name, HessianNormalFormPlane plane, Length displacement, List<Extension> extensions) {
        super(mode);
        this.name = name;
        this.hessianNormalFormPlane = plane;
        this.displacement = displacement;
        this.extensions.addAll(extensions);
        this.extensions.forEach(extension -> extension.setBoundaryPlane(this));
        this.updateTransform();
    }

    private Vector3 getPlaneNormal() {
        return this.hessianNormalFormPlane.getPlaneNormal();
    }

    private Length getDistanceToOrigin() {
        return this.hessianNormalFormPlane.getDistanceToOrigin();
    }

    public Vector3 getActivePlaneNormal() {
        return this.mode != SafetyLimitMode.DISABLED ? this.hessianNormalFormPlane.getPlaneNormal() : HessianNormalFormPlane.DISABLED.getPlaneNormal();
    }

    public Length getActiveDistanceToOrigin() {
        return this.mode != SafetyLimitMode.DISABLED ? this.hessianNormalFormPlane.getDistanceToOrigin() : Length.ZERO;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTrigger() {
        return this.mode == SafetyLimitMode.TRIGGER;
    }

    public Length getDisplacement() {
        return this.displacement;
    }

    public void setName(String newValue) {
        String oldValue = this.name;
        this.name = newValue;
        this.fireEvent(new PropertyChangeEvent(this, "name", oldValue, newValue));
    }

    public void setDisplacement(Length newValue) {
        if (EqualsUtil.equals((Object)newValue, (Object)this.displacement)) {
            return;
        }
        Length oldValue = this.displacement;
        Length displacementDelta = newValue.minus(this.displacement);
        this.adjustPlaneParameters(displacementDelta);
        this.displacement = newValue;
        this.fireEvent(new PropertyChangeEvent(this, "displacement", oldValue, newValue));
    }

    private void adjustPlaneParameters(Length displacementDelta) {
        if (HessianNormalFormPlane.isDefined(this.hessianNormalFormPlane)) {
            HessianNormalFormPlane displacedPlane = this.hessianNormalFormPlane.movedBy(displacementDelta);
            this.setHessianNormalPlaneParameters(displacedPlane);
        }
    }

    @Override
    public boolean isUndefined() {
        return super.isUndefined() && !HessianNormalFormPlane.isDefined(this.hessianNormalFormPlane);
    }

    @Override
    public void copyFromGeomFeature(GeomFeature feature) {
        super.copyFromGeomFeature(feature);
        if (feature == null) {
            this.setHessianNormalPlaneParameters(HessianNormalFormPlane.DISABLED);
            this.setDisplacement(Length.ZERO);
            this.extensions.forEach(Extension::clear);
        } else {
            this.setHessianNormalPlaneParameters(this.extractPlaneParametersFrom(feature, this.displacement));
            this.extensions.forEach(it -> it.copyFromGeomFeature(feature));
        }
    }

    @Override
    public boolean hasFeatureSourceChanged(GeomFeature feature) {
        if (feature == null) {
            return false;
        }
        if (super.hasFeatureSourceChanged(feature)) {
            return true;
        }
        HessianNormalFormPlane otherPlane = this.extractPlaneParametersFrom(feature, this.displacement);
        return !this.hessianNormalFormPlane.epsilonEquals(otherPlane, 0.001);
    }

    private HessianNormalFormPlane extractPlaneParametersFrom(GeomFeature feature, Length displacement) {
        Vector3d planeNormal = new Vector3d();
        feature.getTransformRotation().getColumn(2, planeNormal);
        if (!(feature instanceof BaseSpatialFeature)) {
            planeNormal.negate();
        }
        Vector3d positionOnPlane = feature.getTransformPosition();
        Length signedDistanceToOrigin = Length.from((double)(-positionOnPlane.dot(planeNormal)), (Length.Unit)Length.Unit.SI).plus(displacement);
        return new HessianNormalFormPlane(Vector3.fromVector3d((Vector3d)planeNormal), signedDistanceToOrigin);
    }

    private void updateTransform() {
        if (HessianNormalFormPlane.isDefined(this.hessianNormalFormPlane)) {
            this.updateTransformRotation(this.hessianNormalFormPlane.getPlaneNormal());
            this.updateTransformTranslation();
        } else {
            this.transform.setIdentity();
        }
    }

    private void updateTransformTranslation() {
        Vector3d translation = this.hessianNormalFormPlane.getPlaneNormal().toVector3d();
        translation.scale(-this.hessianNormalFormPlane.getDistanceToOrigin().getIn(Length.Unit.SI));
        this.transform.setTranslation(translation);
    }

    public HessianNormalFormPlane getPlaneParameters() {
        return this.hessianNormalFormPlane;
    }

    public HessianNormalFormPlane getActivePlaneParameters() {
        return this.mode != SafetyLimitMode.DISABLED ? this.hessianNormalFormPlane : HessianNormalFormPlane.DISABLED;
    }

    public HessianNormalFormPlane getPlaneParametersForSafetyMode(SafetyLimitMode mode) {
        return this.isLimitDefined(mode) ? this.getPlaneParameters() : HessianNormalFormPlane.DISABLED;
    }

    @Deprecated
    public void setHessianNormalPlaneParameters(HessianNormalFormPlane planeParameters) {
        HessianNormalFormPlane oldPlane = this.hessianNormalFormPlane;
        this.hessianNormalFormPlane = planeParameters;
        this.updateTransform();
        this.fireEvent(new PropertyChangeEvent(this, "hessianPlaneParameters", oldPlane, this.hessianNormalFormPlane));
    }

    public <T extends Extension> T getExtension(Class<T> extensionType) {
        return (T)((Extension)this.extensions.stream().filter(extensionType::isInstance).findFirst().map(extensionType::cast).orElse(null));
    }

    public void setExtensions(Iterable<Extension> extensions) {
        this.extensions.clear();
        extensions.forEach(extension -> {
            extension.setBoundaryPlane(this);
            this.extensions.add((Extension)extension);
        });
    }

    public boolean completelyEquals(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        BoundaryPlane other = (BoundaryPlane)obj;
        double[] planeNormalArray = this.getPlaneNormal().toDoubleArray();
        double[] planeNormalOtherArray = other.getPlaneNormal().toDoubleArray();
        double[] transform = new double[16];
        double[] transformOther = new double[16];
        this.getTransform().get(transform);
        other.getTransform().get(transformOther);
        return new EqualsBuilder(1.0E-5).append(planeNormalArray, planeNormalOtherArray).append((Object)this.getDistanceToOrigin(), (Object)other.getDistanceToOrigin()).append(this.extensions, other.extensions).append((Object)this.getName(), (Object)other.getName()).append((Object)this.getSourceFeatureId(), (Object)other.getSourceFeatureId()).append(transform, transformOther).isEquals();
    }

    public int hashCode() {
        double[] planeNormalArray = this.getActivePlaneNormal().toDoubleArray();
        return new HashCodeBuilder(URMath.HASH_CODE_PRECISION).append((Object)this.mode).append(planeNormalArray).append((Object)this.getActiveDistanceToOrigin()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BoundaryPlane other = (BoundaryPlane)obj;
        if (other.getSafetyMode() != this.getSafetyMode()) {
            return false;
        }
        double[] planeNormalArray = this.getActivePlaneNormal().toDoubleArray();
        double[] planeNormalOtherArray = other.getActivePlaneNormal().toDoubleArray();
        List<Extension> thisExtensions = this.isEnabled() ? this.extensions : Collections.singletonList(NULL_EXTENSION);
        List<Extension> otherExtensions = other.isEnabled() ? other.extensions : Collections.singletonList(NULL_EXTENSION);
        return new EqualsBuilder(1.0E-5).append(planeNormalArray, planeNormalOtherArray).append(this.getActiveDistanceToOrigin().getIn(Length.Unit.SI), other.getActiveDistanceToOrigin().getIn(Length.Unit.SI)).append(thisExtensions, otherExtensions).isEquals();
    }

    public String toString() {
        return String.valueOf(this.mode.getName()) + " " + this.getActivePlaneParameters().toString();
    }

    public static class ElbowExtension
    implements Extension {
        private boolean elbowRestricted;
        private BoundaryPlane boundaryPlane;

        public ElbowExtension(boolean elbowRestricted) {
            this.elbowRestricted = elbowRestricted;
        }

        @Override
        public void setBoundaryPlane(BoundaryPlane boundaryPlane) {
            this.boundaryPlane = boundaryPlane;
        }

        @Override
        public void clear() {
        }

        @Override
        public void copyFromGeomFeature(GeomFeature feature) {
        }

        public boolean isElbowRestricted() {
            return this.elbowRestricted;
        }

        public void setElbowRestricted(boolean elbowRestricted) {
            if (this.elbowRestricted != elbowRestricted) {
                boolean oldValue = this.elbowRestricted;
                this.elbowRestricted = elbowRestricted;
                this.boundaryPlane.fireEvent(new PropertyChangeEvent(this.boundaryPlane, "elbowRestricted", oldValue, this.elbowRestricted));
            }
        }

        public int hashCode() {
            return new HashCodeBuilder(URMath.HASH_CODE_PRECISION).append(this.elbowRestricted).toHashCode();
        }

        public boolean equals(Object other) {
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            return this.elbowRestricted == ((ElbowExtension)other).elbowRestricted;
        }
    }

    public static interface Extension {
        public void setBoundaryPlane(BoundaryPlane var1);

        public void clear();

        public void copyFromGeomFeature(GeomFeature var1);
    }

    public static class FlangeExtension
    implements Extension {
        private boolean flangeRestricted;
        private BoundaryPlane boundaryPlane;

        public FlangeExtension(boolean flangeRestricted) {
            this.flangeRestricted = flangeRestricted;
        }

        @Override
        public void setBoundaryPlane(BoundaryPlane boundaryPlane) {
            this.boundaryPlane = boundaryPlane;
        }

        @Override
        public void clear() {
        }

        @Override
        public void copyFromGeomFeature(GeomFeature feature) {
        }

        public boolean isFlangeRestricted() {
            return this.flangeRestricted;
        }

        public void setFlangeRestricted(boolean flangeRestricted) {
            if (this.flangeRestricted != flangeRestricted) {
                boolean oldValue = this.flangeRestricted;
                this.flangeRestricted = flangeRestricted;
                this.boundaryPlane.fireEvent(new PropertyChangeEvent(this.boundaryPlane, "flangeRestricted", oldValue, this.flangeRestricted));
            }
        }

        public int hashCode() {
            return new HashCodeBuilder(URMath.HASH_CODE_PRECISION).append(this.flangeRestricted).toHashCode();
        }

        public boolean equals(Object other) {
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            return this.flangeRestricted == ((FlangeExtension)other).flangeRestricted;
        }
    }

    public static class TCPHackExtension
    implements Extension {
        private Pose6d tcpOffset;

        public TCPHackExtension(Pose6d tcpOffset) {
            this.tcpOffset = tcpOffset;
        }

        @Override
        public void setBoundaryPlane(BoundaryPlane boundaryPlane) {
        }

        @Override
        public void clear() {
            this.tcpOffset = null;
        }

        @Override
        public void copyFromGeomFeature(GeomFeature feature) {
            this.tcpOffset = feature instanceof BaseSpatialFeature ? RobotState.getLatestRobotState().tcpOffset : feature.getTcpOffset();
        }

        public Pose6d getTcpOffset() {
            return this.tcpOffset;
        }

        public void setTcpOffset(Pose6d tcpOffset) {
            this.tcpOffset = tcpOffset;
        }

        public int hashCode() {
            return new HashCodeBuilder(URMath.HASH_CODE_PRECISION).append((Object)this.tcpOffset).toHashCode();
        }

        public boolean equals(Object other) {
            return other != null && this.getClass() == other.getClass();
        }
    }
}

