/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.core;

import com.ur.bean.PropertyChangeSite;
import com.ur.bean.URPropertyChangeSupport;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.safety.SafetyLimitMode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.UUID;
import javax.media.j3d.Transform3D;

public abstract class FeatureConfigurableLimit
implements PropertyChangeSite {
    protected static final double MAXIMUM_VALUE_FOR_FEATURE_TO_BE_CONSIDERED_EQUAL = 0.001;
    protected final Transform3D transform = new Transform3D();
    protected SafetyLimitMode mode;
    private UUID sourceId = null;
    private final transient URPropertyChangeSupport changeSupport;

    public FeatureConfigurableLimit(SafetyLimitMode mode) {
        this.mode = mode;
        this.changeSupport = new URPropertyChangeSupport((Object)this);
    }

    public boolean isLimitDefined(SafetyLimitMode mode) {
        switch (mode) {
            case NORMAL: 
            case REDUCED: 
            case BOTH: {
                return this.mode == mode || this.mode == SafetyLimitMode.BOTH;
            }
            case TRIGGER: {
                return this.mode == SafetyLimitMode.TRIGGER;
            }
            case DISABLED: {
                return false;
            }
        }
        return true;
    }

    protected void updateTransformRotation(Vector3 newZAxis) {
        this.transform.setRotation(URMath.getRotationMatrixForZAxis((Vector3)newZAxis));
    }

    public boolean isDefinedAndEnabled() {
        return !this.isUndefined() && this.isEnabled();
    }

    public boolean isUndefined() {
        return this.sourceId == null;
    }

    public boolean hasFeatureSourceChanged(GeomFeature feature) {
        return feature != null && this.sourceId == null;
    }

    public void copyFromGeomFeature(GeomFeature feature) {
        this.setSourceFeatureId(feature == null ? null : feature.getId());
    }

    public SafetyLimitMode getSafetyMode() {
        return this.mode;
    }

    public UUID getSourceFeatureId() {
        return this.sourceId;
    }

    public Transform3D getTransform() {
        return this.transform;
    }

    public void setSafetyMode(SafetyLimitMode newValue) {
        SafetyLimitMode oldValue = this.mode;
        this.mode = newValue;
        this.fireEvent(new PropertyChangeEvent(this, "mode", (Object)oldValue, (Object)newValue));
    }

    public boolean isEnabled() {
        return this.mode != SafetyLimitMode.DISABLED;
    }

    @Deprecated
    public void setSourceFeatureId(UUID featureId) {
        this.sourceId = featureId;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void fireEvent(PropertyChangeEvent evt) {
        this.changeSupport.firePropertyChange(evt);
    }
}

