/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.core;

import com.ur.lang.EqualsBuilder;
import com.ur.lang.EqualsUtil;
import com.ur.math.Length;
import com.ur.monitor.model.Vector3;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class HessianNormalFormPlane {
    public static final HessianNormalFormPlane DISABLED = new HessianNormalFormPlane();
    private final Vector3 planeNormal;
    private final Length distanceToOrigin;

    public HessianNormalFormPlane() {
        this(new Vector3(0.0, 0.0, 0.0), Length.ZERO);
    }

    public HessianNormalFormPlane(double nx, double ny, double nz, Length distanceToOrigin) {
        this(new Vector3(nx, ny, nz), distanceToOrigin);
    }

    public HessianNormalFormPlane(Vector3 normal, Length distanceToOrigin) {
        this.planeNormal = normal;
        this.distanceToOrigin = distanceToOrigin;
    }

    public Vector3 getPlaneNormal() {
        return this.planeNormal;
    }

    public Length getDistanceToOrigin() {
        return this.distanceToOrigin;
    }

    public Length getDistance(Vector3 position) {
        return this.getSignedDistance(position).abs();
    }

    public Length getSignedDistance(Vector3 position) {
        return this.distanceToOrigin.plus(Length.from((double)this.planeNormal.dot(position), (Length.Unit)Length.Unit.SI));
    }

    public boolean isInPositiveHalfPlane(Vector3 position) {
        return this.getSignedDistance(position).isGreaterThan(Length.ZERO);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        if (obj == null || !HessianNormalFormPlane.class.equals(obj.getClass())) {
            return false;
        }
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public boolean epsilonEquals(Object obj, double epsilon) {
        if (obj == null || !HessianNormalFormPlane.class.equals(obj.getClass())) {
            return false;
        }
        HessianNormalFormPlane other = (HessianNormalFormPlane)obj;
        double[] planeNormalArray = this.planeNormal.toDoubleArray();
        double[] planeNormalOtherArray = other.planeNormal.toDoubleArray();
        return new EqualsBuilder(epsilon).append(planeNormalArray, planeNormalOtherArray).append((Object)this.getDistanceToOrigin(), (Object)other.getDistanceToOrigin()).isEquals();
    }

    public String toString() {
        return String.format("[%.3f, %.3f, %.3f, %.3f]", this.planeNormal.x(), this.planeNormal.y(), this.planeNormal.z(), this.distanceToOrigin.getIn(Length.Unit.SI));
    }

    public static boolean isDefined(HessianNormalFormPlane plane) {
        return plane != null && EqualsUtil.notEquals((Object)plane.getPlaneNormal(), (Object)DISABLED.getPlaneNormal());
    }

    public static HessianNormalFormPlane fromPositionAndNormal(Vector3 positionOnPlane, Vector3 planeNormal) {
        double distanceToOrigin = planeNormal.dot(positionOnPlane);
        Length planeDistanceToOrigin = Length.from((double)(-distanceToOrigin), (Length.Unit)Length.Unit.SI);
        return new HessianNormalFormPlane(planeNormal, planeDistanceToOrigin);
    }

    public HessianNormalFormPlane movedBy(Length displacement) {
        return new HessianNormalFormPlane(this.planeNormal, this.distanceToOrigin.plus(displacement));
    }
}

