/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.core;

import com.ur.bean.PropertyChangeSite;
import com.ur.bean.URPropertyChangeSupport;
import com.ur.lang.Defense;
import com.ur.lang.EqualsBuilder;
import com.ur.lang.HashCodeBuilder;
import com.ur.lang.StringUtils;
import com.ur.lang.resources.LocaleProvider;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.safety.SafetySetupComponent;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.safety.Settings;
import com.ur.safety.boundaries.core.BoundaryPlane;
import com.ur.safety.boundaries.core.ToolOrientationLimit;
import com.ur.safety.impl.SafetyTextResourceImpl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;

public class SafetyBoundaries
implements PropertyChangeSite,
SafetySetupComponent {
    public static final float MIN_PLANE_DISPLACEMENT = -5.0f;
    public static final float MAX_PLANE_DISPLACEMENT = 5.0f;
    public static final int NUMBER_OF_BOUNDARY_PLANES = 8;
    private final BoundaryPlane[] boundaryPlanes;
    private final ToolOrientationLimit toolOrientationLimit;
    private final transient URPropertyChangeSupport changeSupport;
    private transient boolean isValidGuiConfiguration = true;

    public SafetyBoundaries(BoundaryPlane[] boundaryPlanes, ToolOrientationLimit toolOrientationLimit, boolean isValidGuiConfiguration) {
        Defense.notNull((Object)boundaryPlanes, (String)"Null boundary plane array not supported");
        Defense.isCondition((boundaryPlanes.length == 8 ? 1 : 0) != 0, (String)String.format("Expected %d boundary planes but got %d", 8, boundaryPlanes.length));
        int i = 0;
        while (i < 8) {
            Defense.notNull((Object)boundaryPlanes[i], (String)"Null boundary plane not supported");
            ++i;
        }
        Defense.notNull((Object)toolOrientationLimit, (String)"Null tool orientation limit not supported");
        this.changeSupport = new URPropertyChangeSupport((Object)this);
        this.boundaryPlanes = boundaryPlanes;
        this.toolOrientationLimit = toolOrientationLimit;
        this.isValidGuiConfiguration = isValidGuiConfiguration;
    }

    public boolean isValidGuiConfiguration() {
        return this.isValidGuiConfiguration;
    }

    public ToolOrientationLimit getToolOrientationLimit() {
        return this.toolOrientationLimit;
    }

    public BoundaryPlane getBoundaryPlane(int i) {
        return this.boundaryPlanes[i];
    }

    public BoundaryPlane[] getBoundaryPlanes() {
        return (BoundaryPlane[])this.boundaryPlanes.clone();
    }

    public boolean isReducedModeDefined() {
        BoundaryPlane[] boundaryPlaneArray = this.boundaryPlanes;
        int n = this.boundaryPlanes.length;
        int n2 = 0;
        while (n2 < n) {
            BoundaryPlane boundaryPlane = boundaryPlaneArray[n2];
            if (boundaryPlane.isTrigger() && !boundaryPlane.isUndefined()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
        this.toolOrientationLimit.addPropertyChangeListener(listener);
        BoundaryPlane[] boundaryPlaneArray = this.boundaryPlanes;
        int n = this.boundaryPlanes.length;
        int n2 = 0;
        while (n2 < n) {
            BoundaryPlane each = boundaryPlaneArray[n2];
            each.addPropertyChangeListener(listener);
            ++n2;
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
        this.toolOrientationLimit.removePropertyChangeListener(listener);
        BoundaryPlane[] boundaryPlaneArray = this.boundaryPlanes;
        int n = this.boundaryPlanes.length;
        int n2 = 0;
        while (n2 < n) {
            BoundaryPlane each = boundaryPlaneArray[n2];
            each.removePropertyChangeListener(listener);
            ++n2;
        }
    }

    public void fireEvent(PropertyChangeEvent evt) {
        this.changeSupport.firePropertyChange(evt);
    }

    public int hashCode() {
        return new HashCodeBuilder(URMath.HASH_CODE_PRECISION).reflectHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return new EqualsBuilder(1.0E-5).isEquals((Object)this, obj);
    }

    public boolean completelyEquals(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        SafetyBoundaries other = (SafetyBoundaries)obj;
        int i = 0;
        while (i < 8) {
            if (!this.boundaryPlanes[i].completelyEquals(other.getBoundaryPlane(i))) {
                return false;
            }
            ++i;
        }
        return this.toolOrientationLimit.completelyEquals(other.getToolOrientationLimit());
    }

    public String createTCPSettings() {
        Pose6d tcpOffset;
        String result = "[settings]\n";
        int i = 0;
        while (i < 8) {
            Pose6d tcpOffset2;
            BoundaryPlane.TCPHackExtension tcpHackExtension = this.boundaryPlanes[i].getExtension(BoundaryPlane.TCPHackExtension.class);
            Pose6d pose6d = tcpOffset2 = tcpHackExtension == null ? null : tcpHackExtension.getTcpOffset();
            if (tcpOffset2 != null) {
                result = String.valueOf(result) + i + " = [" + StringUtils.joinStringsWith((String)",", (double[])tcpOffset2.toArray()) + "]\n";
            }
            ++i;
        }
        ToolOrientationLimit.TCPHackExtension tcpHackExtension = this.toolOrientationLimit.getExtension(ToolOrientationLimit.TCPHackExtension.class);
        Pose6d pose6d = tcpOffset = tcpHackExtension == null ? null : tcpHackExtension.getTcpOffset();
        if (tcpOffset != null) {
            result = String.valueOf(result) + "o = [" + StringUtils.joinStringsWith((String)",", (double[])tcpOffset.toArray()) + "]\n";
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("SafetyBoundaries:\n");
        int i = 0;
        while (i < 8) {
            result.append("\t").append(this.boundaryPlanes[i].toString()).append("\n");
            ++i;
        }
        result.append("\t").append(this.toolOrientationLimit.toString());
        return result.toString();
    }

    public static String getDefaultPlaneName(int planeNo) {
        return new SafetyTextResourceImpl(new LocaleProvider(){

            public Locale getLocale() {
                return Settings.getLanguage().getLocale();
            }
        }).safetyPlaneDefaultName(planeNo);
    }
}

