/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.core;

import com.ur.lang.EqualsBuilder;
import com.ur.lang.EqualsUtil;
import com.ur.lang.HashCodeBuilder;
import com.ur.monitor.RobotState;
import com.ur.monitor.model.Pose6d;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.geomfeature.BaseSpatialFeature;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.boundaries.core.FeatureConfigurableLimit;
import java.beans.PropertyChangeEvent;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

public class ToolOrientationLimit
extends FeatureConfigurableLimit {
    public static final Extension NULL_EXTENSION = new Extension(){

        @Override
        public void setToolOrientationLimit(ToolOrientationLimit toolOrientationLimit) {
        }

        @Override
        public void clear() {
        }

        @Override
        public void copyFromGeomFeature(GeomFeature feature) {
        }
    };
    public static final double TOOL_ORIENTATION_DEVIATION_MAXIMUM = Math.toRadians(181.0);
    public static final double TOOL_ORIENTATION_DEVIATION_MINIMUM = Math.toRadians(5.0);
    public static final Vector3 DISABLED_TOOL_ORIENTATION_VECTOR = new Vector3(0.0, 0.0, 1.0);
    protected static final double TOOL_ORIENTATION_DEVIATION_DEFAULT = Math.toRadians(360.0);
    private Vector3 tcpOrientationVector;
    private double maximumTcpOrientationDeviation;
    private Extension extension;

    public ToolOrientationLimit(SafetyLimitMode mode, Vector3 tcpOrientationVector, double maximumDeviation, Extension extension) {
        super(mode);
        this.tcpOrientationVector = tcpOrientationVector;
        this.maximumTcpOrientationDeviation = maximumDeviation;
        this.extension = extension;
        extension.setToolOrientationLimit(this);
        this.updateTransformRotation(tcpOrientationVector);
    }

    public Vector3 getTCPOrientationVector() {
        return this.tcpOrientationVector;
    }

    public void setTCPOrientationVector(Vector3 newValue) {
        Vector3 oldValue = this.tcpOrientationVector;
        this.tcpOrientationVector = newValue;
        this.updateTransformRotation(this.tcpOrientationVector);
        this.fireEvent(new PropertyChangeEvent(this, "TCPOrientationVector", oldValue, newValue));
    }

    public double getMaximumTcpOrientationDeviation() {
        return this.maximumTcpOrientationDeviation;
    }

    public void setMaximumTcpOrientationDeviation(double newValue) {
        double oldValue = this.maximumTcpOrientationDeviation;
        this.maximumTcpOrientationDeviation = newValue;
        this.fireEvent(new PropertyChangeEvent(this, "maximumTcpOrientationDeviation", oldValue, newValue));
    }

    protected Vector3 getTCPOrientationVectorForController() {
        return this.mode != SafetyLimitMode.DISABLED ? this.tcpOrientationVector : DISABLED_TOOL_ORIENTATION_VECTOR;
    }

    public Vector3 getTCPOrientationVectorForController(SafetyLimitMode mode) {
        return this.isLimitDefined(mode) ? this.getTCPOrientationVector() : DISABLED_TOOL_ORIENTATION_VECTOR;
    }

    protected double getMaximumTCPOrientationDeviationForController() {
        return this.mode != SafetyLimitMode.DISABLED ? this.maximumTcpOrientationDeviation : TOOL_ORIENTATION_DEVIATION_DEFAULT;
    }

    public double getMaximumTCPOrientationDeviationForController(SafetyLimitMode mode) {
        return this.isLimitDefined(mode) ? this.maximumTcpOrientationDeviation : TOOL_ORIENTATION_DEVIATION_DEFAULT;
    }

    private double getToolOrientationDeviationAngle(Vector3d toolOrientation) {
        Transform3D toolTransform = URMath.getTransform((Vector3d)new Vector3d(), (Vector3d)toolOrientation);
        Vector3d toolVector = new Vector3d();
        Matrix3d rotMat = new Matrix3d();
        toolTransform.get(rotMat);
        rotMat.getColumn(2, toolVector);
        return toolVector.angle(this.tcpOrientationVector.toVector3d());
    }

    public double getLimitCloseness(Vector3d toolOrientation) {
        if (this.maximumTcpOrientationDeviation >= Math.PI) {
            return Math.PI;
        }
        return this.maximumTcpOrientationDeviation - Math.abs(this.getToolOrientationDeviationAngle(toolOrientation));
    }

    @Override
    public boolean hasFeatureSourceChanged(GeomFeature feature) {
        Vector3 otherTcpOrientationVector;
        double[] tcpVectorArrayOther;
        if (feature == null) {
            return false;
        }
        if (super.hasFeatureSourceChanged(feature)) {
            return true;
        }
        double[] tcpVectorArray = this.tcpOrientationVector.toDoubleArray();
        return !new EqualsBuilder(0.001).append(tcpVectorArray, tcpVectorArrayOther = (otherTcpOrientationVector = this.getTcpOrientationVectorFromTransform(feature.getTransform())).toDoubleArray()).isEquals();
    }

    private Vector3 getTcpOrientationVectorFromTransform(Transform3D transform) {
        Vector3d toolOrientationVector = new Vector3d();
        Matrix3d rotMat = new Matrix3d();
        transform.get(rotMat);
        rotMat.getColumn(2, toolOrientationVector);
        toolOrientationVector.normalize();
        return Vector3.fromVector3d((Vector3d)toolOrientationVector);
    }

    public boolean isDifferentFromDefault() {
        return !this.tcpOrientationVector.equals((Object)DISABLED_TOOL_ORIENTATION_VECTOR) || !EqualsUtil.equals((double)this.maximumTcpOrientationDeviation, (double)TOOL_ORIENTATION_DEVIATION_DEFAULT, (double)1.0E-5);
    }

    @Override
    public void copyFromGeomFeature(GeomFeature feature) {
        super.copyFromGeomFeature(feature);
        Vector3 oldValue = this.tcpOrientationVector;
        if (feature == null) {
            this.tcpOrientationVector = DISABLED_TOOL_ORIENTATION_VECTOR;
            this.transform.setIdentity();
            double oldTcpDeviationValue = this.maximumTcpOrientationDeviation;
            this.maximumTcpOrientationDeviation = TOOL_ORIENTATION_DEVIATION_MAXIMUM;
            this.extension.clear();
            this.fireEvent(new PropertyChangeEvent(this, "maximumTcpOrientationDeviation", oldTcpDeviationValue, this.maximumTcpOrientationDeviation));
        } else {
            this.tcpOrientationVector = this.getTcpOrientationVectorFromTransform(feature.getTransform());
            this.updateTransformRotation(this.tcpOrientationVector);
            this.extension.copyFromGeomFeature(feature);
        }
        this.fireEvent(new PropertyChangeEvent(this, "TCPOrientationVector", oldValue, this.tcpOrientationVector));
    }

    public <T extends Extension> T getExtension(Class<T> extensionType) {
        return (T)(extensionType.isInstance(this.extension) ? (Extension)extensionType.cast(this.extension) : null);
    }

    public void setExtension(Extension extension) {
        extension.setToolOrientationLimit(this);
        this.extension = extension;
    }

    public int hashCode() {
        double[] tcpOrientationArray = this.getTCPOrientationVectorForController().toDoubleArray();
        return new HashCodeBuilder(URMath.HASH_CODE_PRECISION).append((Object)this.mode).append(tcpOrientationArray).append(this.getMaximumTCPOrientationDeviationForController()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ToolOrientationLimit)) {
            return false;
        }
        ToolOrientationLimit other = (ToolOrientationLimit)obj;
        if (other.getSafetyMode() != this.getSafetyMode()) {
            return false;
        }
        double[] tcpVectorArray = this.getTCPOrientationVectorForController().toDoubleArray();
        double[] tcpVectorArrayOther = other.getTCPOrientationVectorForController().toDoubleArray();
        return new EqualsBuilder(1.0E-5).append(tcpVectorArray, tcpVectorArrayOther).append(this.getMaximumTCPOrientationDeviationForController(), other.getMaximumTCPOrientationDeviationForController()).isEquals();
    }

    public boolean limitDataEquals(ToolOrientationLimit other) {
        double[] tcpVectorArray = this.getTCPOrientationVector().toDoubleArray();
        double[] tcpVectorArrayOther = other.getTCPOrientationVector().toDoubleArray();
        return new EqualsBuilder(1.0E-5).append(tcpVectorArray, tcpVectorArrayOther).append(this.getMaximumTcpOrientationDeviation(), other.getMaximumTcpOrientationDeviation()).isEquals();
    }

    public String toString() {
        return "ToolOrientationLimit " + this.getTCPOrientationVector().toString() + ", " + this.getMaximumTcpOrientationDeviation();
    }

    boolean completelyEquals(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        ToolOrientationLimit other = (ToolOrientationLimit)obj;
        double[] tcpVectorArray = this.getTCPOrientationVector().toDoubleArray();
        double[] tcpVectorArrayOther = other.getTCPOrientationVector().toDoubleArray();
        double[] transform = new double[16];
        double[] transformOther = new double[16];
        this.getTransform().get(transform);
        other.getTransform().get(transformOther);
        return new EqualsBuilder(1.0E-5).append(tcpVectorArray, tcpVectorArrayOther).append(this.getMaximumTcpOrientationDeviation(), other.getMaximumTcpOrientationDeviation()).append((Object)this.getSourceFeatureId(), (Object)other.getSourceFeatureId()).append(transform, transformOther).isEquals();
    }

    public static interface Extension {
        public void setToolOrientationLimit(ToolOrientationLimit var1);

        public void clear();

        public void copyFromGeomFeature(GeomFeature var1);
    }

    public static class TCPHackExtension
    implements Extension {
        private Pose6d tcpOffset;
        private ToolOrientationLimit toolOrientationLimit;

        public TCPHackExtension(Pose6d tcpOffset) {
            this.tcpOffset = tcpOffset;
        }

        @Override
        public void setToolOrientationLimit(ToolOrientationLimit toolOrientationLimit) {
            this.toolOrientationLimit = toolOrientationLimit;
        }

        public double getSignedDistance(Pose6d toolPose, Pose6d currentTcpOffset) {
            return this.tcpOffset == null ? Double.MAX_VALUE : this.toolOrientationLimit.getLimitCloseness(Pose6dTransformUtils.getPoseWithModifiedOffset((Pose6d)toolPose, (Pose6d)currentTcpOffset, (Pose6d)this.tcpOffset).getRot());
        }

        @Override
        public void clear() {
            this.tcpOffset = null;
        }

        @Override
        public void copyFromGeomFeature(GeomFeature feature) {
            this.tcpOffset = feature instanceof BaseSpatialFeature ? RobotState.getLatestRobotState().tcpOffset : feature.getTcpOffset();
        }

        public Pose6d getTcpOffset() {
            return this.tcpOffset;
        }

        public void setTcpOffset(Pose6d tcpOffset) {
            this.tcpOffset = tcpOffset;
        }

        public boolean equals(Object other) {
            return other instanceof TCPHackExtension;
        }
    }
}

