/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.domain;

import com.ur.math.Length;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.boundaries.core.BoundaryPlane;
import com.ur.safety.boundaries.core.HessianNormalFormPlane;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.boundaries.core.ToolOrientationLimit;
import com.ur.safety.boundaries.domain.BoundaryMessageParser;
import com.ur.safety.controllerinterface.SafetyConfigurationParser;
import com.ur.util.logging.Log;
import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;

public class BoundariesMessageParser {
    private final BoundaryMessageParser boundaryMessageParser;
    private ControllerBoundaryPlane[] triggerReducedModePlanes;
    private ControllerBoundaryPlane[] normalModePlanes;
    private ControllerBoundaryPlane[] reducedModePlanes;
    private ToolOrientationLimit normalOrientation;
    private ToolOrientationLimit reducedOrientation;
    private boolean isValidBoundaryConfiguration = true;

    @Inject
    public BoundariesMessageParser(BoundaryMessageParser boundaryMessageParser) {
        this.boundaryMessageParser = boundaryMessageParser;
    }

    public SafetyConfigurationParser<SafetyBoundaries> triggerPlanesParser() {
        return new ParserAdapter(this){

            @Override
            public void parse(DataInput stream, ChecksumVersion version) throws IOException {
                triggerReducedModePlanes = boundaryMessageParser.parsePlanes(stream, version);
            }
        };
    }

    public SafetyConfigurationParser<SafetyBoundaries> normalModeLimits0BoundariesParser() {
        return new ParserAdapter(this){

            @Override
            public void parse(DataInput stream, ChecksumVersion version) throws IOException {
                normalModePlanes = boundaryMessageParser.parsePlanes(stream, version);
            }
        };
    }

    public SafetyConfigurationParser<SafetyBoundaries> normalModeLimits1BoundariesParser() {
        return new ParserAdapter(this){

            @Override
            public void parse(DataInput stream, ChecksumVersion version) throws IOException {
                normalOrientation = boundaryMessageParser.parseOrientation(stream);
            }
        };
    }

    public SafetyConfigurationParser<SafetyBoundaries> reducedModeLimits0BoundariesParser() {
        return new ParserAdapter(this){

            @Override
            public void parse(DataInput stream, ChecksumVersion version) throws IOException {
                reducedModePlanes = boundaryMessageParser.parsePlanes(stream, version);
            }
        };
    }

    public SafetyConfigurationParser<SafetyBoundaries> reducedModeLimits1BoundariesParser() {
        return new ParserAdapter(this){

            @Override
            public void parse(DataInput stream, ChecksumVersion version) throws IOException {
                reducedOrientation = boundaryMessageParser.parseOrientation(stream);
            }
        };
    }

    private SafetyBoundaries getResult() {
        BoundaryPlane[] boundaryPlanes = this.extractBoundaryPlanes(this.normalModePlanes, this.reducedModePlanes, this.triggerReducedModePlanes);
        ToolOrientationLimit toolOrientationLimit = this.extractToolOrientationLimit(this.normalOrientation, this.reducedOrientation);
        return new SafetyBoundaries(boundaryPlanes, toolOrientationLimit, this.isValidBoundaryConfiguration);
    }

    private BoundaryPlane[] extractBoundaryPlanes(ControllerBoundaryPlane[] normalModePlanes, ControllerBoundaryPlane[] reducedModePlanes, ControllerBoundaryPlane[] triggerReducedModePlanes) {
        BoundaryPlane[] result = new BoundaryPlane[8];
        int i = 0;
        while (i < result.length) {
            result[i] = this.extractBoundaryPlane(normalModePlanes[i], reducedModePlanes[i], triggerReducedModePlanes[i], i);
            ++i;
        }
        return result;
    }

    private BoundaryPlane extractBoundaryPlane(ControllerBoundaryPlane normalModePlane, ControllerBoundaryPlane reducedModePlane, ControllerBoundaryPlane triggerPlane, int planeNo) {
        int safetyLimitModeInt = (HessianNormalFormPlane.isDefined(normalModePlane.planeParameters) ? 1 : 0) + (HessianNormalFormPlane.isDefined(reducedModePlane.planeParameters) ? 2 : 0) + (HessianNormalFormPlane.isDefined(triggerPlane.planeParameters) ? 4 : 0);
        switch (safetyLimitModeInt) {
            case 0: {
                return this.createBoundaryPlane(SafetyLimitMode.DISABLED, planeNo, normalModePlane);
            }
            case 1: {
                return this.createBoundaryPlane(SafetyLimitMode.NORMAL, planeNo, normalModePlane);
            }
            case 2: {
                return this.createBoundaryPlane(SafetyLimitMode.REDUCED, planeNo, reducedModePlane);
            }
            case 3: {
                if (!normalModePlane.planeParameters.epsilonEquals(reducedModePlane.planeParameters, 1.0E-5)) {
                    this.isValidBoundaryConfiguration = false;
                    Log.warning((String)"Reduced and normal mode boundary plane differ!");
                    return this.createBoundaryPlane(SafetyLimitMode.DISABLED, planeNo, normalModePlane);
                }
                return this.createBoundaryPlane(SafetyLimitMode.BOTH, planeNo, normalModePlane);
            }
            case 4: {
                return this.createBoundaryPlane(SafetyLimitMode.TRIGGER, planeNo, triggerPlane);
            }
        }
        this.isValidBoundaryConfiguration = false;
        Log.warning((String)"Plane defined as both trigger and normal and/or reduced mode boundary!");
        return this.createBoundaryPlane(SafetyLimitMode.DISABLED, planeNo, normalModePlane);
    }

    private BoundaryPlane createBoundaryPlane(SafetyLimitMode mode, int planeNo, ControllerBoundaryPlane controllerPlane) {
        return new BoundaryPlane(mode, SafetyBoundaries.getDefaultPlaneName(planeNo), controllerPlane.planeParameters, Length.ZERO, controllerPlane.extensions);
    }

    private ToolOrientationLimit extractToolOrientationLimit(ToolOrientationLimit normalModeLimit, ToolOrientationLimit reducedModeLimit) {
        int safetyLimitModeInt = (normalModeLimit.isDifferentFromDefault() ? 1 : 0) + (reducedModeLimit.isDifferentFromDefault() ? 2 : 0);
        switch (safetyLimitModeInt) {
            case 0: {
                normalModeLimit.setSafetyMode(SafetyLimitMode.DISABLED);
                break;
            }
            case 1: {
                normalModeLimit.setSafetyMode(SafetyLimitMode.NORMAL);
                break;
            }
            case 2: {
                reducedModeLimit.setSafetyMode(SafetyLimitMode.REDUCED);
                return reducedModeLimit;
            }
            case 3: {
                if (!normalModeLimit.limitDataEquals(reducedModeLimit)) {
                    this.isValidBoundaryConfiguration = false;
                    Log.warning((String)"Reduced and normal mode tool orientation limits differ!");
                    normalModeLimit.setSafetyMode(SafetyLimitMode.DISABLED);
                    return normalModeLimit;
                }
                normalModeLimit.setSafetyMode(SafetyLimitMode.BOTH);
                break;
            }
            default: {
                this.isValidBoundaryConfiguration = false;
                normalModeLimit.setSafetyMode(SafetyLimitMode.DISABLED);
                return normalModeLimit;
            }
        }
        return normalModeLimit;
    }

    static class ControllerBoundaryPlane {
        public final List<BoundaryPlane.Extension> extensions;
        final HessianNormalFormPlane planeParameters;

        ControllerBoundaryPlane(HessianNormalFormPlane planeParameters, List<BoundaryPlane.Extension> extensions) {
            this.planeParameters = planeParameters;
            this.extensions = extensions;
        }
    }

    private abstract class ParserAdapter
    extends SafetyConfigurationParser.ActiveParserTemplate<SafetyBoundaries> {
        private ParserAdapter() {
        }

        @Override
        public Class<SafetyBoundaries> getType() {
            return SafetyBoundaries.class;
        }

        @Override
        public SafetyBoundaries getResult() {
            return BoundariesMessageParser.this.getResult();
        }
    }
}

