/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.domain;

import com.ur.lang.NamingUtils;
import com.ur.math.Length;
import com.ur.monitor.model.Pose6d;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.persistence.Dictionary;
import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.OptionsSection;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.boundaries.core.BoundaryPlane;
import com.ur.safety.boundaries.core.HessianNormalFormPlane;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.boundaries.core.ToolOrientationLimit;
import com.ur.safety.installation.SafetySetupConverter;
import com.ur.safety.persistence.DictionaryPersistence;
import com.ur.safety.persistence.DictionaryPersistenceBuilder;
import com.ur.safety.persistence.DictionaryReader;
import com.ur.safety.persistence.DictionaryWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public final class BoundariesPersistence
implements SafetySetupConverter<SafetyBoundaries> {
    private static final String TOOL_ORIENTATION_SECTION = "SafetyLimits ToolOrientation";
    private final DictionaryPersistence<BoundaryPlane> planePersistence;
    private final DictionaryPersistence<ToolOrientationLimit> toolOrientationPersistence;

    private BoundariesPersistence(DictionaryPersistence<BoundaryPlane> planePersistence, DictionaryPersistence<ToolOrientationLimit> toolOrientationPersistence) {
        this.planePersistence = planePersistence;
        this.toolOrientationPersistence = toolOrientationPersistence;
    }

    public static BoundariesPersistence createG5Persistence() {
        G3BoundaryPlaneStrategy g3BoundaryPlaneStrategy = new G3BoundaryPlaneStrategy();
        G5BoundaryPlaneStrategy g5BoundaryPlaneStrategy = new G5BoundaryPlaneStrategy();
        G3ToolOrientationStrategy g3ToolOrientationStrategy = new G3ToolOrientationStrategy();
        G5ToolOrientationStrategy g5ToolOrientationStrategy = new G5ToolOrientationStrategy();
        return new BoundariesPersistence(DictionaryPersistenceBuilder.persistence(DictionaryPersistenceBuilder.writer(g5BoundaryPlaneStrategy), DictionaryPersistenceBuilder.readers(g3BoundaryPlaneStrategy, g5BoundaryPlaneStrategy)), DictionaryPersistenceBuilder.persistence(DictionaryPersistenceBuilder.writer(g5ToolOrientationStrategy), DictionaryPersistenceBuilder.readers(g3ToolOrientationStrategy, g5ToolOrientationStrategy)));
    }

    public void copyToOptions(ChecksumVersion checksumVersion, Options options, SafetyBoundaries boundaries) {
        int i = 0;
        while (i < 8) {
            BoundaryPlane plane = boundaries.getBoundaryPlane(i);
            String boundaryPlaneSectionName = this.getBoundaryPlaneSectionName(i);
            OptionsSection section = options.getSection(boundaryPlaneSectionName);
            this.planePersistence.getWriter().write(plane, (Dictionary)section, checksumVersion);
            ++i;
        }
        this.toolOrientationPersistence.getWriter().write(boundaries.getToolOrientationLimit(), (Dictionary)options.getSection(TOOL_ORIENTATION_SECTION), checksumVersion);
    }

    public void readFromOptions(SafetyBoundaries boundaries, Options options) {
        ChecksumVersion version = ChecksumVersion.fromString((String)options.getSection("Safety Checksum").getString("version", "1.0"));
        int i = 0;
        while (i < 8) {
            BoundaryPlane plane = boundaries.getBoundaryPlane(i);
            this.readFrom(version, plane, options.getSection(this.getBoundaryPlaneSectionName(i)));
            ++i;
        }
        this.readFrom(version, boundaries.getToolOrientationLimit(), options.getSection(TOOL_ORIENTATION_SECTION));
    }

    @Override
    public Class<SafetyBoundaries> getComponentType() {
        return SafetyBoundaries.class;
    }

    @Override
    public void convertToG5(SafetyBoundaries boundaries) {
        HashSet<String> planeNames = new HashSet<String>();
        int i = 0;
        while (i < 8) {
            BoundaryPlane plane = boundaries.getBoundaryPlane(i);
            ArrayList<BoundaryPlane.Extension> extensions = new ArrayList<BoundaryPlane.Extension>();
            extensions.add(new BoundaryPlane.ElbowExtension(false));
            extensions.add(new BoundaryPlane.FlangeExtension(false));
            plane.setExtensions(extensions);
            String truncatedName = NamingUtils.truncateName((String)plane.getName());
            String fixedName = NamingUtils.createUniqueName((String)truncatedName, planeNames);
            planeNames.add(fixedName);
            plane.setName(fixedName);
            ++i;
        }
        boundaries.getToolOrientationLimit().setExtension(ToolOrientationLimit.NULL_EXTENSION);
    }

    @Override
    public List<String> getAffectedG3SafetyItems(SafetyBoundaries boundaries, SafetyTextResource textResource) {
        ArrayList<String> affectedG3SafetyItems = new ArrayList<String>();
        int i = 0;
        while (i < 8) {
            if (boundaries.getBoundaryPlane(i).isDefinedAndEnabled()) {
                affectedG3SafetyItems.add(textResource.safetyPlanes());
                break;
            }
            ++i;
        }
        if (boundaries.getToolOrientationLimit().isDefinedAndEnabled()) {
            affectedG3SafetyItems.add(textResource.toolOrientationLimit());
        }
        return affectedG3SafetyItems;
    }

    private void readFrom(ChecksumVersion version, BoundaryPlane plane, OptionsSection dictionary) {
        for (DictionaryReader<BoundaryPlane> each : this.planePersistence.getReaders()) {
            if (!each.canRead(version)) continue;
            each.read(plane, (Dictionary)dictionary);
            return;
        }
        throw new IllegalArgumentException(String.format("No boundary plane reader found for safety setup version \"%s\"", version.toString()));
    }

    private void readFrom(ChecksumVersion version, ToolOrientationLimit orientationLimit, OptionsSection dictionary) {
        for (DictionaryReader<ToolOrientationLimit> each : this.toolOrientationPersistence.getReaders()) {
            if (!each.canRead(version)) continue;
            each.read(orientationLimit, (Dictionary)dictionary);
            return;
        }
        throw new IllegalArgumentException(String.format("No tool orientation limit reader found for safety setup version \"%s\"", version.toString()));
    }

    private String getBoundaryPlaneSectionName(int planeNo) {
        return "SafetyLimits BoundaryPlane" + planeNo;
    }

    private static abstract class BoundaryPlaneStrategyTemplate
    implements DictionaryWriter<BoundaryPlane>,
    DictionaryReader<BoundaryPlane> {
        private static final String NAME = "name";
        private static final String SOURCE_FEATURE_ID = "sourceFeatureId";
        private static final String DISPLACEMENT = "displacement";
        private static final String MODE = "mode";
        private static final String PLANE_NORMAL = "planeNormal";
        private static final String DISTANCE_TO_ORIGIN = "distanceToOrigin";

        private BoundaryPlaneStrategyTemplate() {
        }

        @Override
        public void write(BoundaryPlane plane, Dictionary dictionary, ChecksumVersion checksumVersion) {
            dictionary.setString(NAME, plane.getName());
            dictionary.setUUID(SOURCE_FEATURE_ID, plane.getSourceFeatureId());
            dictionary.setDouble(DISPLACEMENT, Double.valueOf(plane.getDisplacement().getIn(Length.Unit.SI)));
            dictionary.setEnum(MODE, (Enum)plane.getSafetyMode());
            HessianNormalFormPlane planeParameters = plane.getPlaneParameters();
            double[] planeNormalAsDouble = planeParameters.getPlaneNormal().toDoubleArray();
            dictionary.setDoubleArray(PLANE_NORMAL, planeNormalAsDouble);
            dictionary.setDouble(DISTANCE_TO_ORIGIN, Double.valueOf(planeParameters.getDistanceToOrigin().getIn(Length.Unit.SI)));
            this.writeTCP(plane, dictionary);
            this.writeElbow(plane, dictionary);
            if (checksumVersion.atLeast(ChecksumVersion.VERSION_5_7)) {
                this.writeFlange(plane, dictionary);
            }
        }

        @Override
        public void read(BoundaryPlane plane, Dictionary dictionary) {
            plane.setName(dictionary.getString(NAME, ""));
            plane.setSourceFeatureId(dictionary.getUUID(SOURCE_FEATURE_ID, null));
            plane.setDisplacement(Length.from((double)dictionary.getDouble(DISPLACEMENT, Double.valueOf(0.0)), (Length.Unit)Length.Unit.SI));
            plane.setSafetyMode((SafetyLimitMode)dictionary.getEnum(MODE, SafetyLimitMode.class, (Enum)SafetyLimitMode.DISABLED));
            double[] vector = dictionary.getDoubleArray(PLANE_NORMAL, HessianNormalFormPlane.DISABLED.getPlaneNormal().toDoubleArray());
            double distanceToOrigin = dictionary.getDouble(DISTANCE_TO_ORIGIN, Double.valueOf(HessianNormalFormPlane.DISABLED.getDistanceToOrigin().getIn(Length.Unit.SI)));
            plane.setHessianNormalPlaneParameters(new HessianNormalFormPlane(Vector3.fromDoubleArray((double[])vector), Length.from((double)distanceToOrigin, (Length.Unit)Length.Unit.SI)));
            this.readTCP(plane, dictionary);
            this.readElbow(plane, dictionary);
            this.readFlange(plane, dictionary);
        }

        abstract void writeTCP(BoundaryPlane var1, Dictionary var2);

        abstract void readTCP(BoundaryPlane var1, Dictionary var2);

        abstract void writeElbow(BoundaryPlane var1, Dictionary var2);

        abstract void readElbow(BoundaryPlane var1, Dictionary var2);

        abstract void writeFlange(BoundaryPlane var1, Dictionary var2);

        abstract void readFlange(BoundaryPlane var1, Dictionary var2);
    }

    private static class G3BoundaryPlaneStrategy
    extends BoundaryPlaneStrategyTemplate {
        private static final String TCP_OFFSET = "tcpOffset";

        private G3BoundaryPlaneStrategy() {
        }

        @Override
        public boolean canRead(ChecksumVersion version) {
            return !version.atLeast(ChecksumVersion.VERSION_5_0);
        }

        @Override
        void writeTCP(BoundaryPlane plane, Dictionary dictionary) {
            Pose6d tcpOffset = plane.getExtension(BoundaryPlane.TCPHackExtension.class).getTcpOffset();
            if (tcpOffset != null) {
                dictionary.setDoubleArray(TCP_OFFSET, tcpOffset.toArray());
            }
        }

        @Override
        void readTCP(BoundaryPlane plane, Dictionary dictionary) {
            double[] tcpOffsetAsArray = dictionary.getDoubleArray(TCP_OFFSET, null);
            if (tcpOffsetAsArray != null) {
                plane.getExtension(BoundaryPlane.TCPHackExtension.class).setTcpOffset(new Pose6d(tcpOffsetAsArray));
            }
        }

        @Override
        void writeElbow(BoundaryPlane plane, Dictionary dictionary) {
        }

        @Override
        void readElbow(BoundaryPlane plane, Dictionary dictionary) {
        }

        @Override
        void writeFlange(BoundaryPlane plane, Dictionary dictionary) {
        }

        @Override
        void readFlange(BoundaryPlane plane, Dictionary dictionary) {
        }
    }

    private static class G3ToolOrientationStrategy
    extends ToolOrientationStrategyTemplate {
        private static final String TCP_OFFSET = "tcpOffset";

        private G3ToolOrientationStrategy() {
        }

        @Override
        public boolean canRead(ChecksumVersion version) {
            return !version.atLeast(ChecksumVersion.VERSION_5_0);
        }

        @Override
        void writeTCP(ToolOrientationLimit orientationLimit, Dictionary dictionary) {
            Pose6d tcpOffset = orientationLimit.getExtension(ToolOrientationLimit.TCPHackExtension.class).getTcpOffset();
            if (tcpOffset != null) {
                dictionary.setDoubleArray(TCP_OFFSET, tcpOffset.toArray());
            }
        }

        @Override
        void readTCP(ToolOrientationLimit orientationLimit, Dictionary dictionary) {
            double[] tcpOffsetAsArray = dictionary.getDoubleArray(TCP_OFFSET, null);
            if (tcpOffsetAsArray != null) {
                orientationLimit.getExtension(ToolOrientationLimit.TCPHackExtension.class).setTcpOffset(new Pose6d(tcpOffsetAsArray));
            }
        }
    }

    private static class G5BoundaryPlaneStrategy
    extends BoundaryPlaneStrategyTemplate {
        private static final String ELBOW_RESTRICTED = "elbowRestricted";
        private static final String FLANGE_RESTRICTED = "flangeRestricted";

        private G5BoundaryPlaneStrategy() {
        }

        @Override
        public boolean canRead(ChecksumVersion version) {
            return version.atLeast(ChecksumVersion.VERSION_5_0);
        }

        @Override
        void writeTCP(BoundaryPlane plane, Dictionary dictionary) {
        }

        @Override
        void readTCP(BoundaryPlane plane, Dictionary dictionary) {
        }

        @Override
        void writeElbow(BoundaryPlane plane, Dictionary dictionary) {
            dictionary.setBoolean(ELBOW_RESTRICTED, Boolean.valueOf(plane.getExtension(BoundaryPlane.ElbowExtension.class).isElbowRestricted()));
        }

        @Override
        void readElbow(BoundaryPlane plane, Dictionary dictionary) {
            plane.getExtension(BoundaryPlane.ElbowExtension.class).setElbowRestricted(dictionary.getBoolean(ELBOW_RESTRICTED, Boolean.valueOf(true)));
        }

        @Override
        void writeFlange(BoundaryPlane plane, Dictionary dictionary) {
            BoundaryPlane.FlangeExtension toolFlangeExtension = plane.getExtension(BoundaryPlane.FlangeExtension.class);
            dictionary.setBoolean(FLANGE_RESTRICTED, Boolean.valueOf(Objects.isNull(toolFlangeExtension) || toolFlangeExtension.isFlangeRestricted()));
        }

        @Override
        void readFlange(BoundaryPlane plane, Dictionary dictionary) {
            BoundaryPlane.FlangeExtension toolFlangeExtension = plane.getExtension(BoundaryPlane.FlangeExtension.class);
            if (Objects.nonNull(toolFlangeExtension)) {
                toolFlangeExtension.setFlangeRestricted(dictionary.getBoolean(FLANGE_RESTRICTED, Boolean.valueOf(true)));
            }
        }
    }

    private static class G5ToolOrientationStrategy
    extends ToolOrientationStrategyTemplate {
        private G5ToolOrientationStrategy() {
        }

        @Override
        public boolean canRead(ChecksumVersion version) {
            return version.atLeast(ChecksumVersion.VERSION_5_0);
        }

        @Override
        void writeTCP(ToolOrientationLimit orientationLimit, Dictionary dictionary) {
        }

        @Override
        void readTCP(ToolOrientationLimit orientationLimit, Dictionary dictionary) {
        }
    }

    private static abstract class ToolOrientationStrategyTemplate
    implements DictionaryWriter<ToolOrientationLimit>,
    DictionaryReader<ToolOrientationLimit> {
        private static final String TCP_ORIENTATION_VECTOR = "tcpOrientationVector";
        private static final String MAXIMUM_TCP_ORIENTATION_DEVIATION = "maximumTcpOrientationDeviation";
        private static final String SOURCE_FEATURE_ID = "sourceFeatureId";
        private static final String MODE = "mode";

        private ToolOrientationStrategyTemplate() {
        }

        @Override
        public void write(ToolOrientationLimit orientationLimit, Dictionary dictionary, ChecksumVersion checksumVersion) {
            double[] vector = orientationLimit.getTCPOrientationVector().toDoubleArray();
            dictionary.setDoubleArray(TCP_ORIENTATION_VECTOR, vector);
            dictionary.setDouble(MAXIMUM_TCP_ORIENTATION_DEVIATION, Double.valueOf(orientationLimit.getMaximumTcpOrientationDeviation()));
            dictionary.setUUID(SOURCE_FEATURE_ID, orientationLimit.getSourceFeatureId());
            dictionary.setEnum(MODE, (Enum)orientationLimit.getSafetyMode());
            this.writeTCP(orientationLimit, dictionary);
        }

        @Override
        public void read(ToolOrientationLimit orientationLimit, Dictionary dictionary) {
            double[] vector = dictionary.getDoubleArray(TCP_ORIENTATION_VECTOR, ToolOrientationLimit.DISABLED_TOOL_ORIENTATION_VECTOR.toDoubleArray());
            orientationLimit.setTCPOrientationVector(Vector3.fromDoubleArray((double[])vector));
            orientationLimit.setMaximumTcpOrientationDeviation(dictionary.getDouble(MAXIMUM_TCP_ORIENTATION_DEVIATION, Double.valueOf(ToolOrientationLimit.TOOL_ORIENTATION_DEVIATION_MAXIMUM)));
            orientationLimit.setSourceFeatureId(dictionary.getUUID(SOURCE_FEATURE_ID, null));
            orientationLimit.setSafetyMode((SafetyLimitMode)dictionary.getEnum(MODE, SafetyLimitMode.class, (Enum)SafetyLimitMode.DISABLED));
            this.readTCP(orientationLimit, dictionary);
        }

        abstract void writeTCP(ToolOrientationLimit var1, Dictionary var2);

        abstract void readTCP(ToolOrientationLimit var1, Dictionary var2);
    }
}

