/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.domain;

import com.ur.lang.DecimalFormatFactory;
import com.ur.math.Length;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.resources.ViewImageResource;
import com.ur.safety.AbstractSafetySetupToHtmlRenderer;
import com.ur.safety.HTMLPage;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.SafetySetupPanesLookAndFeel;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.boundaries.core.BoundaryPlane;
import com.ur.safety.boundaries.core.FeatureConfigurableLimit;
import com.ur.safety.boundaries.core.HessianNormalFormPlane;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.boundaries.core.ToolOrientationLimit;
import com.ur.safety.util.domain.AlternatingBackgroundRowGenerator;
import com.ur.util.swing.HTML;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.swing.Icon;

public abstract class BoundariesToHtmlRenderer
extends AbstractSafetySetupToHtmlRenderer {
    private static final int MINIMUM_COLUMN_LENGTH = 20;
    private final String pageTitle;
    private final ElbowToHTMLConverter elbowToHTMLConverter;
    private final ToolFlangeToHTMLConverter toolFlangeToHTMLConverter;
    private final BoundaryShowStrategy boundaryShowStrategy;

    private BoundariesToHtmlRenderer(SafetyTextResource textResource, String pageTitle, ElbowToHTMLConverter elbowToHTMLConverter, ToolFlangeToHTMLConverter toolFlangeToHTMLConverter, BoundaryShowStrategy boundaryShowStrategy, SafetySetupPanesLookAndFeel lookAndFeel) {
        super(textResource, lookAndFeel);
        this.pageTitle = pageTitle;
        this.elbowToHTMLConverter = elbowToHTMLConverter;
        this.toolFlangeToHTMLConverter = toolFlangeToHTMLConverter;
        this.boundaryShowStrategy = boundaryShowStrategy;
    }

    private static String toPrettyString(HessianNormalFormPlane hessianNormalFormPlane) {
        DecimalFormat formatter = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#0.####");
        return String.format("[%s,&nbsp;%s, %s,&nbsp;%s]%n", formatter.format(hessianNormalFormPlane.getPlaneNormal().x()), formatter.format(hessianNormalFormPlane.getPlaneNormal().y()), formatter.format(hessianNormalFormPlane.getPlaneNormal().z()), formatter.format(hessianNormalFormPlane.getDistanceToOrigin().getIn(Length.Unit.SI)));
    }

    private static String toPrettyString(ToolOrientationLimit toolOrientationLimit, SafetyLimitMode mode) {
        Vector3 tcpVector = toolOrientationLimit.getTCPOrientationVectorForController(mode);
        DecimalFormat formatter = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#0.####");
        return String.format("[%s, %s, %s, %s]%n", formatter.format(tcpVector.x()), formatter.format(tcpVector.y()), formatter.format(tcpVector.z()), formatter.format(toolOrientationLimit.getMaximumTCPOrientationDeviationForController(mode)));
    }

    @Override
    public HTMLPage createContributedPage(SafetySetup safetySetup, boolean useSIUnits) {
        if (safetySetup.isReducedModeDefined() || useSIUnits) {
            return new HTMLPage(this.pageTitle, this.presentAsHTML((SafetyBoundaries)safetySetup.getComponent(SafetyBoundaries.class), SafetyLimitMode.NORMAL, SafetyLimitMode.REDUCED, SafetyLimitMode.TRIGGER));
        }
        return new HTMLPage(this.pageTitle, this.presentAsHTML((SafetyBoundaries)safetySetup.getComponent(SafetyBoundaries.class), SafetyLimitMode.NORMAL, SafetyLimitMode.TRIGGER));
    }

    private String presentAsHTML(SafetyBoundaries safetyBoundaries, SafetyLimitMode ... modes) {
        ArrayList<String> rows = new ArrayList<String>();
        rows.add(HTML.tableRow(this.getHeaderCells(modes)));
        boolean showingPlanes = false;
        boolean showingDirectionLimit = false;
        AlternatingBackgroundRowGenerator rowGenerator = new AlternatingBackgroundRowGenerator();
        BoundaryPlane[] boundaryPlaneArray = safetyBoundaries.getBoundaryPlanes();
        int n = boundaryPlaneArray.length;
        int n2 = 0;
        while (n2 < n) {
            BoundaryPlane each = boundaryPlaneArray[n2];
            if (this.boundaryShowStrategy.showBoundary(each)) {
                rows.add(rowGenerator.generate(this.presentPlane(each, modes)));
                showingPlanes = true;
            }
            ++n2;
        }
        ToolOrientationLimit toolOrientationLimit = safetyBoundaries.getToolOrientationLimit();
        if (this.boundaryShowStrategy.showBoundary(toolOrientationLimit)) {
            rows.add(rowGenerator.generate(this.presentOrientationLimit(toolOrientationLimit, modes)));
            showingDirectionLimit = true;
        }
        if (showingPlanes || showingDirectionLimit) {
            String warnings = "";
            warnings = String.valueOf(warnings) + (showingPlanes ? HTML.p((String)(String.valueOf(HTML.image((HTML.Align)HTML.Align.bottom, (URL)ViewImageResource.asResource((Icon)ViewImageResource.formInformation()))) + "    " + this.textResource.infoInConfirmationDialogOfBoundaries())) : "");
            if (showingPlanes && showingDirectionLimit) {
                warnings = String.valueOf(warnings) + HTML.br();
            }
            warnings = String.valueOf(warnings) + (showingDirectionLimit ? HTML.p((String)(String.valueOf(HTML.image((HTML.Align)HTML.Align.bottom, (URL)ViewImageResource.asResource((Icon)ViewImageResource.formInformation()))) + "    " + this.textResource.infoInConfirmationDialogOfToolBoundaries())) : "");
            return String.valueOf(HTML.table((int)this.lookAndFeel.panelWidth, rows)) + HTML.br() + warnings;
        }
        return HTML.h2((String)this.textResource.NoPlanesDefined());
    }

    private Iterable<String> getHeaderCells(SafetyLimitMode ... modes) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(HTML.tableHeaderWithProperties((String)"align=left nowrap", (String)this.getBoundariesColumnTitle()));
        this.elbowToHTMLConverter.addElbowHeader(result);
        this.toolFlangeToHTMLConverter.addToolFlangeHeader(result);
        SafetyLimitMode[] safetyLimitModeArray = modes;
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            SafetyLimitMode each = safetyLimitModeArray[n2];
            String title = HTML.fillToMinimumLength((String)this.textResource.safetyLimitMode(each), (int)20);
            result.add(HTML.tableHeaderWithPropertiesWrappedAfterFirstWord((String)"align=left", (String)title));
            ++n2;
        }
        return result;
    }

    private Iterable<String> presentPlane(BoundaryPlane boundaryPlane, SafetyLimitMode ... modes) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.presentPlaneName(boundaryPlane.getName()));
        this.elbowToHTMLConverter.addElbowCell(boundaryPlane, result);
        this.toolFlangeToHTMLConverter.addToolFlangeCell(boundaryPlane, result);
        SafetyLimitMode[] safetyLimitModeArray = modes;
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            SafetyLimitMode each = safetyLimitModeArray[n2];
            result.add(HTML.tableCell((String)BoundariesToHtmlRenderer.toPrettyString(boundaryPlane.getPlaneParametersForSafetyMode(each))));
            ++n2;
        }
        return result;
    }

    protected abstract String presentPlaneName(String var1);

    private Iterable<String> presentOrientationLimit(ToolOrientationLimit toolOrientationLimit, SafetyLimitMode ... modes) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(HTML.tableCell((String)this.textResource.safetyToolBoundary()));
        this.elbowToHTMLConverter.addElbowCell(result);
        this.toolFlangeToHTMLConverter.addToolFlangeCell(result);
        SafetyLimitMode[] safetyLimitModeArray = modes;
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            SafetyLimitMode each = safetyLimitModeArray[n2];
            if (each == SafetyLimitMode.TRIGGER) {
                result.add(HTML.tableCell((String)this.textResource.None()));
            } else {
                result.add(HTML.tableCellWithProperties((String)"", (String)BoundariesToHtmlRenderer.toPrettyString(toolOrientationLimit, each)));
            }
            ++n2;
        }
        return result;
    }

    protected abstract String getBoundariesColumnTitle();

    /* synthetic */ BoundariesToHtmlRenderer(SafetyTextResource safetyTextResource, String string, ElbowToHTMLConverter elbowToHTMLConverter, ToolFlangeToHTMLConverter toolFlangeToHTMLConverter, BoundaryShowStrategy boundaryShowStrategy, SafetySetupPanesLookAndFeel safetySetupPanesLookAndFeel, BoundariesToHtmlRenderer boundariesToHtmlRenderer) {
        this(safetyTextResource, string, elbowToHTMLConverter, toolFlangeToHTMLConverter, boundaryShowStrategy, safetySetupPanesLookAndFeel);
    }

    public static class BoundariesToHtmlRendererImpl
    extends BoundariesToHtmlRenderer {
        @Inject
        public BoundariesToHtmlRendererImpl(SafetyTextResource text, SafetySetupPanesLookAndFeel lookAndFeel) {
            super(text, text.safetyTabPlanes(), new ElbowToHTMLConverter(text), new ToolFlangeToHTMLConverter(text), new ShowDefinedPlanes(), lookAndFeel, null);
        }

        @Override
        protected String presentPlaneName(String planeName) {
            return planeName.replaceAll("\\s", "&nbsp;");
        }

        @Override
        protected String getBoundariesColumnTitle() {
            return this.textResource.safetyTabPlanes();
        }
    }

    private static interface BoundaryShowStrategy {
        public boolean showBoundary(FeatureConfigurableLimit var1);
    }

    private static class ElbowToHTMLConverter {
        private final SafetyTextResource textResource;

        ElbowToHTMLConverter(SafetyTextResource textResource) {
            this.textResource = textResource;
        }

        public void addElbowHeader(Collection<String> result) {
            result.add(HTML.tableHeaderWithPropertiesWrappedAfterFirstWord((String)"align=center", (String)this.textResource.RestrictsElbow()));
        }

        public void addElbowCell(BoundaryPlane plane, List<String> result) {
            result.add(HTML.tableCell((String)HTML.center((String)(plane.getExtension(BoundaryPlane.ElbowExtension.class).isElbowRestricted() ? this.textResource.Yes() : this.textResource.No()))));
        }

        public void addElbowCell(List<String> result) {
            result.add(HTML.tableCell((String)HTML.center((String)"&mdash;")));
        }
    }

    private static class ShowDefinedPlanes
    implements BoundaryShowStrategy {
        private ShowDefinedPlanes() {
        }

        @Override
        public boolean showBoundary(FeatureConfigurableLimit each) {
            return each instanceof BoundaryPlane && !each.isUndefined();
        }
    }

    private static class ToolFlangeToHTMLConverter {
        private final SafetyTextResource textResource;

        ToolFlangeToHTMLConverter(SafetyTextResource textResource) {
            this.textResource = textResource;
        }

        public void addToolFlangeHeader(Collection<String> result) {
            result.add(HTML.tableHeaderWithPropertiesWrappedAfterFirstWord((String)"align=center", (String)this.textResource.RestrictsFlange()));
        }

        public void addToolFlangeCell(BoundaryPlane plane, List<String> result) {
            result.add(HTML.tableCell((String)HTML.center((String)(plane.getExtension(BoundaryPlane.FlangeExtension.class).isFlangeRestricted() ? this.textResource.Yes() : this.textResource.No()))));
        }

        public void addToolFlangeCell(List<String> result) {
            result.add(HTML.tableCell((String)HTML.center((String)"&mdash;")));
        }
    }
}

