/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.domain;

import com.ur.lang.StringUtils;
import com.ur.math.Length;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.OptionsSection;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.boundaries.core.BoundaryPlane;
import com.ur.safety.boundaries.core.HessianNormalFormPlane;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.boundaries.core.ToolOrientationLimit;
import java.util.Objects;

public final class BoundariesToStringConverter {
    static final String NORMAL_MODE_SAFETY_LIMITS_KEY = "NormalModeSafetyLimits";
    static final String REDUCED_MODE_SAFETY_LIMITS_KEY = "ReducedModeSafetyLimits";
    static final String REDUCED_MODE_TRIGGER_PLANES_KEY = "ReducedModeTriggerPlanes";

    public void copyControllerRepresentationTo(ChecksumVersion checksumVersion, Options options, SafetyBoundaries boundaries) {
        this.copyControllerRepresentationTo(boundaries, SafetyLimitMode.NORMAL, options.getSection(NORMAL_MODE_SAFETY_LIMITS_KEY), checksumVersion);
        this.copyControllerRepresentationTo(boundaries, SafetyLimitMode.REDUCED, options.getSection(REDUCED_MODE_SAFETY_LIMITS_KEY), checksumVersion);
        this.copyControllerRepresentationTo(boundaries, SafetyLimitMode.TRIGGER, options.getSection(REDUCED_MODE_TRIGGER_PLANES_KEY), checksumVersion);
    }

    private void copyControllerRepresentationTo(SafetyBoundaries boundaries, SafetyLimitMode mode, OptionsSection section, ChecksumVersion checksumVersion) {
        int i = 0;
        while (i < 8) {
            String boundaryPlaneAsString = this.convertBoundaryPlaneToString(boundaries.getBoundaryPlane(i), mode, checksumVersion);
            String safetyPlaneName = this.generatePlaneStringPrefix(i);
            section.setString(safetyPlaneName, boundaryPlaneAsString);
            ++i;
        }
        if (mode != SafetyLimitMode.TRIGGER) {
            this.copyTcpOrientation(boundaries.getToolOrientationLimit(), mode, section);
        }
    }

    private void copyTcpOrientation(ToolOrientationLimit toolOrientationLimit, SafetyLimitMode mode, OptionsSection section) {
        Vector3 tcpVector = toolOrientationLimit.getTCPOrientationVectorForController(mode);
        section.setFloatArray("tcpOrientationVector", new float[]{(float)tcpVector.x(), (float)tcpVector.y(), (float)tcpVector.z()});
        section.setFloat("maximumTcpOrientationDeviation", Float.valueOf((float)toolOrientationLimit.getMaximumTCPOrientationDeviationForController(mode)));
    }

    private String generatePlaneStringPrefix(int planeNo) {
        return "plane" + planeNo;
    }

    private String convertBoundaryPlaneToString(BoundaryPlane boundaryPlane, SafetyLimitMode mode, ChecksumVersion checksumVersion) {
        HessianNormalFormPlane plane = boundaryPlane.getPlaneParametersForSafetyMode(mode);
        String elbowRestrictedPresentation = this.getElbowRestrictedPresentation(boundaryPlane, mode);
        String flangeRestrictedPresentation = checksumVersion.atLeast(ChecksumVersion.VERSION_5_7) ? this.getToolFlangeRestrictedPresentation(boundaryPlane, mode) : "";
        return "[" + this.convertPlaneToString(plane) + elbowRestrictedPresentation + flangeRestrictedPresentation + "]";
    }

    private String getElbowRestrictedPresentation(BoundaryPlane boundaryPlane, SafetyLimitMode mode) {
        BoundaryPlane.ElbowExtension elbowExtension = boundaryPlane.getExtension(BoundaryPlane.ElbowExtension.class);
        String elbowRestricted = boundaryPlane.isLimitDefined(mode) && Objects.nonNull(elbowExtension) && elbowExtension.isElbowRestricted() ? "1" : "0";
        return ", " + elbowRestricted;
    }

    private String getToolFlangeRestrictedPresentation(BoundaryPlane boundaryPlane, SafetyLimitMode mode) {
        BoundaryPlane.FlangeExtension flangeExtension = boundaryPlane.getExtension(BoundaryPlane.FlangeExtension.class);
        String toolFlangeRestricted = boundaryPlane.isLimitDefined(mode) && Objects.nonNull(flangeExtension) && flangeExtension.isFlangeRestricted() ? "1" : "0";
        return ", " + toolFlangeRestricted;
    }

    private String convertPlaneToString(HessianNormalFormPlane plane) {
        Vector3 normal = plane.getPlaneNormal();
        return StringUtils.joinStringsWith((String)", ", (Object[])new Double[]{normal.x(), normal.y(), normal.z(), plane.getDistanceToOrigin().getIn(Length.Unit.SI)});
    }

    public static BoundariesToStringConverter createConverter() {
        return new BoundariesToStringConverter();
    }
}

