/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.domain;

import com.ur.lang.EndianConverter;
import com.ur.math.Length;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.SafetyEndianConverter;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.boundaries.core.BoundaryPlane;
import com.ur.safety.boundaries.core.HessianNormalFormPlane;
import com.ur.safety.boundaries.core.ToolOrientationLimit;
import com.ur.safety.boundaries.domain.BoundariesMessageParser;
import com.ur.safety.boundaries.domain.BoundaryMessageParser;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;

public class BoundaryMessageParserImpl
implements BoundaryMessageParser {
    private static final int DEFAULT_VALUE_TO_RESTRICT_ALL_TOOL_FLANGES = 0;
    private final EndianConverter endianConverter;

    @Inject
    BoundaryMessageParserImpl(SafetyEndianConverter safetyEndianConverter) {
        this.endianConverter = safetyEndianConverter.getConverter();
    }

    @Override
    public BoundariesMessageParser.ControllerBoundaryPlane[] parsePlanes(DataInput stream, ChecksumVersion version) throws IOException {
        int elbowRestrictedRepresentation = stream.readUnsignedByte();
        int flangeRestrictedRepresentation = this.getToolFlangeRestrictedRepresentation(stream, version);
        BoundariesMessageParser.ControllerBoundaryPlane[] result = new BoundariesMessageParser.ControllerBoundaryPlane[8];
        int i = 0;
        while (i < 8) {
            boolean isFlangeRestricted = (flangeRestrictedRepresentation >> i & 1) == 1;
            boolean isElbowRestricted = (elbowRestrictedRepresentation >> i & 1) == 1;
            double nx = this.endianConverter.convert(stream);
            double ny = this.endianConverter.convert(stream);
            double nz = this.endianConverter.convert(stream);
            Length p = Length.from((double)this.endianConverter.convert(stream), (Length.Unit)Length.Unit.SI);
            ArrayList<BoundaryPlane.Extension> extensions = new ArrayList<BoundaryPlane.Extension>();
            extensions.add(new BoundaryPlane.ElbowExtension(isElbowRestricted));
            extensions.add(new BoundaryPlane.FlangeExtension(isFlangeRestricted));
            result[i] = new BoundariesMessageParser.ControllerBoundaryPlane(new HessianNormalFormPlane(nx, ny, nz, p), extensions);
            ++i;
        }
        return result;
    }

    @Override
    public ToolOrientationLimit parseOrientation(DataInput stream) throws IOException {
        double x = this.endianConverter.convert(stream);
        double y = this.endianConverter.convert(stream);
        double z = this.endianConverter.convert(stream);
        double maxTCPOrientationDeviation = this.endianConverter.convert(stream);
        return new ToolOrientationLimit(SafetyLimitMode.DISABLED, new Vector3(x, y, z), maxTCPOrientationDeviation, ToolOrientationLimit.NULL_EXTENSION);
    }

    private int getToolFlangeRestrictedRepresentation(DataInput stream, ChecksumVersion version) throws IOException {
        if (version.atLeast(ChecksumVersion.VERSION_5_7)) {
            return stream.readUnsignedByte();
        }
        return 0;
    }
}

