/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.domain;

import com.ur.lang.EndianConverter;
import com.ur.math.Length;
import com.ur.monitor.model.Vector3;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.boundaries.core.BoundaryPlane;
import com.ur.safety.boundaries.core.HessianNormalFormPlane;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_1_0;
import java.nio.ByteBuffer;

public class PlanesChecksumContribution_1_0
implements SafetyChecksumGenerator_1_0.ChecksumGeneratorContribution<SafetyBoundaries> {
    protected static final int NUMBER_OF_PLANES = 8;
    protected static final int NUMBER_OF_BYTES_FOR_PLANES = 128;
    protected final SafetyLimitMode mode;

    public PlanesChecksumContribution_1_0(SafetyLimitMode mode) {
        this.mode = mode;
    }

    @Override
    public Class<SafetyBoundaries> getComponentType() {
        return SafetyBoundaries.class;
    }

    @Override
    public int getByteCount() {
        return 128;
    }

    @Override
    public void addBytes(EndianConverter converter, ByteBuffer buffer, SafetyBoundaries component) {
        this.addPlanes(component, converter, buffer);
    }

    protected void addPlanes(SafetyBoundaries component, EndianConverter converter, ByteBuffer buffer) {
        int i = 0;
        while (i < 8) {
            BoundaryPlane plane = component.getBoundaryPlane(i);
            this.addPlane(plane, converter, buffer);
            ++i;
        }
    }

    protected void addPlane(BoundaryPlane plane, EndianConverter converter, ByteBuffer buffer) {
        HessianNormalFormPlane trigger = plane.getPlaneParametersForSafetyMode(this.mode);
        Vector3 vector = trigger.getPlaneNormal();
        converter.convert(buffer, (float)vector.x());
        converter.convert(buffer, (float)vector.y());
        converter.convert(buffer, (float)vector.z());
        converter.convert(buffer, (float)trigger.getDistanceToOrigin().getIn(Length.Unit.SI));
    }
}

