/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.domain;

import com.ur.lang.EndianConverter;
import com.ur.monitor.model.Vector3;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.boundaries.core.ToolOrientationLimit;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_1_0;
import java.nio.ByteBuffer;

public class ToolOrientationChecksumContribution
implements SafetyChecksumGenerator_1_0.ChecksumGeneratorContribution<SafetyBoundaries> {
    protected static final int NUMBER_OF_BYTES_FOR_THE_TOOL = 16;
    private final SafetyLimitMode mode;

    public ToolOrientationChecksumContribution(SafetyLimitMode mode) {
        this.mode = mode;
    }

    @Override
    public Class<SafetyBoundaries> getComponentType() {
        return SafetyBoundaries.class;
    }

    @Override
    public int getByteCount() {
        return 16;
    }

    @Override
    public void addBytes(EndianConverter converter, ByteBuffer buffer, SafetyBoundaries component) {
        ToolOrientationLimit tool = component.getToolOrientationLimit();
        Vector3 vector = tool.getTCPOrientationVectorForController(this.mode);
        converter.convert(buffer, (float)vector.x());
        converter.convert(buffer, (float)vector.y());
        converter.convert(buffer, (float)vector.z());
        converter.convert(buffer, (float)tool.getMaximumTCPOrientationDeviationForController(this.mode));
    }
}

