/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.domain.exposed;

import com.ur.math.Length;
import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.safety.SafetySetupContribution;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.boundaries.core.BoundaryPlane;
import com.ur.safety.boundaries.core.HessianNormalFormPlane;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.boundaries.core.ToolOrientationLimit;
import com.ur.safety.boundaries.domain.BoundariesPersistence;
import com.ur.safety.boundaries.domain.BoundariesToStringConverter;
import java.util.ArrayList;
import java.util.List;

public final class BoundariesContribution
implements SafetySetupContribution<SafetyBoundaries> {
    private final BoundaryDefaults boundaryDefaults;
    private final BoundariesPersistence boundariesPersistence;
    private final BoundariesToStringConverter boundariesToStringConverter;

    private BoundariesContribution(BoundaryDefaults boundaryDefaults, BoundariesPersistence boundariesPersistence, BoundariesToStringConverter boundariesToStringConverter) {
        this.boundaryDefaults = boundaryDefaults;
        this.boundariesPersistence = boundariesPersistence;
        this.boundariesToStringConverter = boundariesToStringConverter;
    }

    public static BoundariesContribution createContribution() {
        return new BoundariesContribution(new BoundaryDefaults(), BoundariesPersistence.createG5Persistence(), BoundariesToStringConverter.createConverter());
    }

    public Class<SafetyBoundaries> getComponentType() {
        return SafetyBoundaries.class;
    }

    public SafetyBoundaries createDefaultComponent() {
        ToolOrientationLimit orientationLimit = new ToolOrientationLimit(SafetyLimitMode.DISABLED, ToolOrientationLimit.DISABLED_TOOL_ORIENTATION_VECTOR, ToolOrientationLimit.TOOL_ORIENTATION_DEVIATION_MAXIMUM, this.boundaryDefaults.defaultToolOrientationLimitExtension());
        BoundaryPlane[] boundaryPlanes = new BoundaryPlane[8];
        int i = 0;
        while (i < boundaryPlanes.length) {
            boundaryPlanes[i] = new BoundaryPlane(SafetyLimitMode.DISABLED, SafetyBoundaries.getDefaultPlaneName(i), HessianNormalFormPlane.DISABLED, Length.ZERO, this.boundaryDefaults.defaultBoundaryPlaneExtension());
            ++i;
        }
        return new SafetyBoundaries(boundaryPlanes, orientationLimit, true);
    }

    public SafetyBoundaries readFromOptions(ChecksumVersion checksumVersion, Options options) {
        SafetyBoundaries component = this.createDefaultComponent(checksumVersion);
        this.boundariesPersistence.readFromOptions(component, options);
        return component;
    }

    SafetyBoundaries createDefaultComponent(ChecksumVersion checksumVersion) {
        ToolOrientationLimit orientationLimit = new ToolOrientationLimit(SafetyLimitMode.DISABLED, ToolOrientationLimit.DISABLED_TOOL_ORIENTATION_VECTOR, ToolOrientationLimit.TOOL_ORIENTATION_DEVIATION_MAXIMUM, this.boundaryDefaults.defaultToolOrientationLimitExtension(checksumVersion));
        BoundaryPlane[] boundaryPlanes = new BoundaryPlane[8];
        int i = 0;
        while (i < boundaryPlanes.length) {
            boundaryPlanes[i] = new BoundaryPlane(SafetyLimitMode.DISABLED, SafetyBoundaries.getDefaultPlaneName(i), HessianNormalFormPlane.DISABLED, Length.ZERO, this.boundaryDefaults.defaultBoundaryPlaneExtension(checksumVersion));
            ++i;
        }
        return new SafetyBoundaries(boundaryPlanes, orientationLimit, true);
    }

    public void copyToOptions(ChecksumVersion checksumVersion, Options options, SafetyBoundaries component) {
        this.boundariesPersistence.copyToOptions(checksumVersion, options, component);
    }

    public void copyControllerRepresentationTo(ChecksumVersion checksumVersion, Options options, SafetyBoundaries component) {
        this.boundariesToStringConverter.copyControllerRepresentationTo(checksumVersion, options, component);
    }

    public boolean isSupported(ChecksumVersion version) {
        return true;
    }

    private static class BoundaryDefaults {
        private BoundaryDefaults() {
        }

        public List<BoundaryPlane.Extension> defaultBoundaryPlaneExtension() {
            ArrayList<BoundaryPlane.Extension> extensions = new ArrayList<BoundaryPlane.Extension>();
            extensions.add(new BoundaryPlane.ElbowExtension(true));
            extensions.add(new BoundaryPlane.FlangeExtension(true));
            return extensions;
        }

        public List<BoundaryPlane.Extension> defaultBoundaryPlaneExtension(ChecksumVersion checksumVersion) {
            ArrayList<BoundaryPlane.Extension> extensions = new ArrayList<BoundaryPlane.Extension>();
            if (checksumVersion.atLeast(ChecksumVersion.VERSION_5_0)) {
                extensions.add(new BoundaryPlane.ElbowExtension(true));
                extensions.add(new BoundaryPlane.FlangeExtension(true));
            } else {
                extensions.add(new BoundaryPlane.TCPHackExtension(null));
            }
            return extensions;
        }

        public ToolOrientationLimit.Extension defaultToolOrientationLimitExtension() {
            return ToolOrientationLimit.NULL_EXTENSION;
        }

        public ToolOrientationLimit.Extension defaultToolOrientationLimitExtension(ChecksumVersion checksumVersion) {
            if (checksumVersion.atLeast(ChecksumVersion.VERSION_5_0)) {
                return ToolOrientationLimit.NULL_EXTENSION;
            }
            return new ToolOrientationLimit.TCPHackExtension(null);
        }
    }
}

