/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.externalapi;

import com.ur.lang.HashCodeBuilder;
import com.ur.lang.PrimitiveUtils;
import com.ur.math.Length;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.boundaries.core.BoundaryPlane;
import com.ur.safety.boundaries.core.HessianNormalFormPlane;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.boundaries.externalapi.BoundariesView;
import com.ur.safety.boundaries.externalapi.BoundaryPlaneProperties;
import com.ur.safety.boundaries.externalapi.ElementDefinitionState;
import com.ur.safety.boundaries.externalapi.SafetyBoundaryVisualization;
import com.ur.safety.impl.ReloadOnSafetyLoaded;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.security.SafetyLockListener;
import com.ur.safety.util.domain.SpatialFeatureUniqueByName;
import com.ur.safety.util.externalapi.DefinedPointsAndPlanes;
import com.ur.safety.util.externalapi.SelectFeaturePresenter;
import com.ur.safety.util.externalapi.SelectSafetyLimitPresenter;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.util.Conjunction;
import com.ur.util.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class BoundariesPresenter
implements ReloadOnSafetyLoaded,
SelectFeaturePresenter,
SelectSafetyLimitPresenter {
    private static final UIBoundary NULL_SAFETY_PLANE = BoundariesPresenter.getNullSafetyPlane();
    private final SafetyTextResource text;
    private final FeaturesLookup lookupService;
    private final SafetySettingsLookupService safetySettingsLookupService;
    private final EnableBoundariesView enableView;
    private final List<UIBoundary> activeUIBoundaries = new ArrayList<UIBoundary>();
    private final List<UIBoundary> unusedUIBoundaries = new ArrayList<UIBoundary>();
    private BoundariesView view;
    private SafetyBoundaryVisualization boundariesVisualization;
    private UIBoundary selectedUIBoundary = NULL_SAFETY_PLANE;

    @Inject
    public BoundariesPresenter(SafetyTextResource text, FeaturesLookup lookupService, SafetySettingsLookupService safetySettingsLookupService, EnableBoundariesView enableView) {
        this.text = text;
        this.lookupService = lookupService;
        this.safetySettingsLookupService = safetySettingsLookupService;
        this.enableView = enableView;
    }

    public void setView(BoundariesView view) {
        this.view = view;
        this.enableView.setBoundariesView(view);
        this.activate();
    }

    public void set3DView(SafetyBoundaryVisualization safetyBoundaryVisualization) {
        this.boundariesVisualization = safetyBoundaryVisualization;
    }

    public void activate() {
        this.initializePresenter();
        this.view.setBoundariesList(this.activeUIBoundaries);
        this.view.setAvailableFeatures(this.lookupService.getFeaturesBy((Predicate)new Conjunction(new Predicate[]{new DefinedPointsAndPlanes(), new SpatialFeatureUniqueByName()})));
        this.view.setSelectedSafetyPlane(this.selectedUIBoundary);
        this.selectSafetyPlane(this.selectedUIBoundary);
    }

    private void initializePresenter() {
        if (this.activeUIBoundaries.isEmpty() && this.unusedUIBoundaries.isEmpty()) {
            SafetyBoundaries boundaries = this.safetySettingsLookupService.getSafetyComponent(SafetyBoundaries.class);
            this.selectedUIBoundary = NULL_SAFETY_PLANE;
            BoundaryPlane[] planes = boundaries.getBoundaryPlanes();
            UIBoundary.transformPlanes(planes, this.activeUIBoundaries, this.unusedUIBoundaries);
        }
    }

    public void deactivate() {
    }

    @Override
    public void selectFeature(SpatialFeature selectedGeomFeature) {
        if (this.selectedUIBoundary.getFeatureId() == null && selectedGeomFeature != null) {
            this.selectedUIBoundary.setSafetyLimitMode(SafetyLimitMode.BOTH);
        }
        this.selectedUIBoundary.setFeature((GeomFeature)selectedGeomFeature);
        this.updatePropertiesInView(this.selectedUIBoundary);
    }

    @Override
    public void synchronizeFeature() {
        GeomFeature feature;
        if (this.selectedUIBoundary.getFeatureId() != null && (feature = this.lookupService.getFeatureByUUID(this.selectedUIBoundary.getFeatureId())) != null) {
            this.selectedUIBoundary.plane.copyFromGeomFeature(feature);
            this.updatePropertiesInView(this.selectedUIBoundary);
        }
    }

    public void selectSafetyPlane(UIBoundary selectPlane) {
        this.selectedUIBoundary = selectPlane;
        this.enableView.setSelectedSafetyPlane(selectPlane);
        this.updatePropertiesInView(this.selectedUIBoundary);
    }

    public void removeSafetyPlane() {
        int index = this.activeUIBoundaries.indexOf(this.selectedUIBoundary);
        this.activeUIBoundaries.remove(this.selectedUIBoundary);
        this.unusedUIBoundaries.add(this.selectedUIBoundary);
        this.boundariesVisualization.clearVisualization(this.selectedUIBoundary);
        this.selectedUIBoundary.reset();
        UIBoundary toSelect = --index >= 0 ? this.activeUIBoundaries.get(index) : NULL_SAFETY_PLANE;
        this.view.setBoundariesList(this.activeUIBoundaries);
        this.view.setSelectedSafetyPlane(toSelect);
        this.selectSafetyPlane(toSelect);
    }

    public void addSafetyPlane() {
        if (this.canAddMore()) {
            String name;
            UIBoundary safetyPlane = this.unusedUIBoundaries.remove(0);
            safetyPlane.reset();
            int i = 1;
            while (true) {
                if (!this.planeNameIsUsed(name = String.valueOf(this.text.safetyHeaderName()) + " " + i)) break;
                ++i;
            }
            safetyPlane.setName(name);
            this.activeUIBoundaries.add(safetyPlane);
            this.view.addSafetyPlane(safetyPlane);
            this.selectSafetyPlane(safetyPlane);
        }
    }

    private boolean planeNameIsUsed(String name) {
        for (UIBoundary activeUIBoundary : this.activeUIBoundaries) {
            if (!name.equals(activeUIBoundary.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSafetyLimitMode(SafetyLimitMode safetyLimitMode) {
        this.selectedUIBoundary.setSafetyLimitMode(safetyLimitMode);
        this.updatePropertiesInView(this.selectedUIBoundary);
    }

    public void setOffset(String displacement) {
        this.selectedUIBoundary.setOffset(PrimitiveUtils.parseDouble((String)displacement, (double)this.selectedUIBoundary.getOffset()));
        this.updatePropertiesInView(this.selectedUIBoundary);
    }

    public void setName(String name) {
        this.selectedUIBoundary.setName(name);
        this.updatePropertiesInView(this.selectedUIBoundary);
    }

    public void setElbowRestricted(boolean elbowRestricted) {
        this.selectedUIBoundary.setElbowRestricted(elbowRestricted);
        this.updatePropertiesInView(this.selectedUIBoundary);
    }

    public void setFlangeRestricted(boolean flangeRestricted) {
        this.selectedUIBoundary.setFlangeRestricted(flangeRestricted);
        this.updatePropertiesInView(this.selectedUIBoundary);
    }

    public void toggleVisible() {
        this.selectedUIBoundary.setVisible(!this.selectedUIBoundary.isVisible());
        this.updatePropertiesInView(this.selectedUIBoundary);
    }

    @Override
    public void reset() {
        this.activeUIBoundaries.clear();
        this.unusedUIBoundaries.clear();
        this.activate();
        this.deactivate();
    }

    public boolean canAddMore() {
        return !this.unusedUIBoundaries.isEmpty();
    }

    private void updatePropertiesInView(UIBoundary selectedBoundary) {
        GeomFeature feature = this.lookupService.getFeatureByUUID(selectedBoundary.getFeatureId());
        BoundaryPlaneProperties boundaryPlaneProperties = new BoundaryPlaneProperties(selectedBoundary.getName(), feature, selectedBoundary.getSafetyLimitMode(), selectedBoundary.getOffset(), selectedBoundary.isElbowChecked(), selectedBoundary.isFlangeChecked());
        this.view.setPlaneProperties(boundaryPlaneProperties);
        if (this.boundariesVisualization != null) {
            this.boundariesVisualization.updateBoundaryPlanes(selectedBoundary, this.activeUIBoundaries, this.unusedUIBoundaries);
        }
        this.enableView.updateEnablement();
        this.view.setSelectedFeatureState(selectedBoundary.getDefinitionState(feature));
        this.view.setShowElbowSphere(this.isElbowRestrictedByAVisualizedPlane(selectedBoundary));
    }

    private boolean isElbowRestrictedByAVisualizedPlane(UIBoundary selectedBoundary) {
        for (UIBoundary each : this.activeUIBoundaries) {
            if (!each.isElbowChecked() || !Objects.equals(each, selectedBoundary) && !each.isVisible() || !each.isDefined()) continue;
            return true;
        }
        return false;
    }

    public int getSafetyPlaneCount() {
        return this.activeUIBoundaries.size();
    }

    private static UIBoundary getNullSafetyPlane() {
        List<BoundaryPlane.Extension> extensions = Arrays.asList(new BoundaryPlane.ElbowExtension(true), new BoundaryPlane.FlangeExtension(true));
        BoundaryPlane boundaryPlane = new BoundaryPlane(SafetyLimitMode.DISABLED, "", new HessianNormalFormPlane(), Length.ZERO, extensions);
        return new UIBoundary(boundaryPlane, -1);
    }

    static class EnableBoundariesView
    implements SafetyLockListener {
        private final SafetyLock safetyLock;
        private final FeaturesLookup featuresLookup;
        private UIBoundary safetyPlane = BoundariesPresenter.access$0();
        private BoundariesView view;

        @Inject
        EnableBoundariesView(SafetyLock safetyLock, FeaturesLookup featuresLookup) {
            this.safetyLock = safetyLock;
            this.featuresLookup = featuresLookup;
            safetyLock.addSafetyLockListener(this);
        }

        public void setBoundariesView(BoundariesView view) {
            this.view = view;
        }

        public void setSelectedSafetyPlane(UIBoundary safetyPlane) {
            this.safetyPlane = safetyPlane;
        }

        @Override
        public void doUnlock() {
            this.updateEnablement();
        }

        @Override
        public void doLock() {
            this.updateEnablement();
        }

        public void updateEnablement() {
            boolean enableAddRemovePlanes = !this.safetyLock.isLocked();
            this.view.setEnabledAddRemovePlanes(enableAddRemovePlanes);
            boolean enableRenameAndSelectFeature = enableAddRemovePlanes && this.safetyPlane != NULL_SAFETY_PLANE;
            this.view.setEnabledRenamePlane(enableRenameAndSelectFeature);
            this.view.setEnabledSelectFeature(enableRenameAndSelectFeature);
            GeomFeature feature = this.featuresLookup.getFeatureByUUID(this.safetyPlane.getFeatureId());
            boolean enableSyncFeature = enableRenameAndSelectFeature && this.safetyPlane.getDefinitionState(feature) == ElementDefinitionState.CHANGED;
            this.view.setEnabledSynchronizeFeature(enableSyncFeature);
            boolean enableOtherPlaneProperties = enableRenameAndSelectFeature && this.safetyPlane.getFeatureId() != null;
            this.view.setEnabledSelectSafetyMode(enableOtherPlaneProperties);
            this.view.setEnabledChangeOffset(enableOtherPlaneProperties);
            this.view.setEnabledElbowRestriction(enableOtherPlaneProperties);
            this.view.setEnabledFlangeRestriction(enableOtherPlaneProperties);
        }
    }

    public static class UIBoundary {
        private final UnitsConverter convertLengths = Units.getMetersConverter();
        private final BoundaryPlane plane;
        private final int index;
        private boolean visible;

        UIBoundary(BoundaryPlane plane, int index) {
            this.plane = plane;
            this.index = index;
        }

        static void transformPlanes(BoundaryPlane[] planes, Collection<UIBoundary> defined, Collection<UIBoundary> undefined) {
            int i = 0;
            BoundaryPlane[] boundaryPlaneArray = planes;
            int n = planes.length;
            int n2 = 0;
            while (n2 < n) {
                BoundaryPlane each = boundaryPlaneArray[n2];
                if (each.isUndefined()) {
                    undefined.add(new UIBoundary(each, i));
                } else {
                    defined.add(new UIBoundary(each, i));
                }
                ++i;
                ++n2;
            }
        }

        public int getPlaneIndex() {
            return this.index;
        }

        public boolean isVisible() {
            return this.visible;
        }

        private void setVisible(boolean visibleState) {
            this.visible = visibleState;
        }

        public SafetyLimitMode getSafetyLimitMode() {
            return this.plane.getSafetyMode();
        }

        private void setSafetyLimitMode(SafetyLimitMode mode) {
            this.plane.setSafetyMode(mode);
        }

        public UUID getFeatureId() {
            return this.plane.getSourceFeatureId();
        }

        private void setFeature(GeomFeature geomFeature) {
            if (geomFeature == null) {
                this.setSafetyLimitMode(SafetyLimitMode.DISABLED);
                this.setOffset(0.0);
                this.setElbowRestricted(true);
                this.setFlangeRestricted(true);
            }
            this.plane.copyFromGeomFeature(geomFeature);
        }

        public String getName() {
            return this.plane.getName();
        }

        private void setName(String name) {
            this.plane.setName(name);
        }

        public boolean isElbowChecked() {
            return this.plane.getExtension(BoundaryPlane.ElbowExtension.class).isElbowRestricted();
        }

        private void setElbowRestricted(boolean elbowRestricted) {
            this.plane.getExtension(BoundaryPlane.ElbowExtension.class).setElbowRestricted(elbowRestricted);
        }

        public boolean isFlangeChecked() {
            return this.plane.getExtension(BoundaryPlane.FlangeExtension.class).isFlangeRestricted();
        }

        private void setFlangeRestricted(boolean flangeRestricted) {
            this.plane.getExtension(BoundaryPlane.FlangeExtension.class).setFlangeRestricted(flangeRestricted);
        }

        public double getOffset() {
            return this.convertLengths.convertFrom(this.plane.getDisplacement().getIn(Length.Unit.SI));
        }

        private void setOffset(double offset) {
            offset = this.convertLengths.convertTo(offset);
            this.plane.setDisplacement(Length.from((double)offset, (Length.Unit)Length.Unit.SI));
        }

        public void reset() {
            this.setOffset(0.0);
            this.setFeature(null);
            this.setSafetyLimitMode(SafetyLimitMode.DISABLED);
            this.setVisible(false);
            this.setElbowRestricted(true);
        }

        public boolean isDefined() {
            return !this.plane.isUndefined();
        }

        public int hashCode() {
            return new HashCodeBuilder(URMath.HASH_CODE_PRECISION).append((Object)this.convertLengths).append((Object)this.plane).append(this.index).append(this.visible).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj != null && this.getClass() == obj.getClass()) {
                return ((UIBoundary)obj).plane == this.plane;
            }
            return false;
        }

        public BoundaryPlane asBoundaryPlane() {
            return this.plane;
        }

        public ElementDefinitionState getDefinitionState(GeomFeature feature) {
            return ElementDefinitionState.getState(this.plane, feature);
        }
    }
}

