/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.externalapi;

import com.ur.lang.DecimalFormatFactory;
import com.ur.polyscope.valueobjects.converters.UnitType;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.Settings;
import com.ur.safety.boundaries.externalapi.BoundaryInputBinder;
import com.ur.safety.tolerances.SafetyComplianceTolerances;
import com.ur.safety.util.externalapi.ValidationStrategyProxy;
import com.ur.swing.InputView;
import com.ur.swing.number.Mode;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.event.EventManager;
import java.text.Format;
import javax.inject.Inject;

public class BoundaryInputBinderImpl
extends SafetyChangeListener.Template
implements BoundaryInputBinder {
    private final EventManager eventManager;
    private final SafetyTextResource safetyTextResource;
    private SafetyComplianceTolerances tolerances;

    @Inject
    protected BoundaryInputBinderImpl(EventManager eventManager, SafetyTextResource safetyTextResource) {
        this.eventManager = eventManager;
        this.safetyTextResource = safetyTextResource;
        eventManager.addStrongListener(SafetyChangeListener.class, (Object)this);
    }

    @Override
    public void safetyTolerancesReceived(SafetyComplianceTolerances tolerances) {
        this.tolerances = tolerances;
    }

    @Override
    public void bindPlaneDisplacementSupport(InputView inputView) {
        PlaneDisplacementValidationStrategyProxy validator = new PlaneDisplacementValidationStrategyProxy(inputView, this.safetyTextResource);
        this.setTolerances(inputView, validator);
    }

    @Override
    public void bindTriggerDisplacementSupport(InputView inputView) {
        TriggerDisplacementValidationStrategyProxy validator = new TriggerDisplacementValidationStrategyProxy(inputView, this.safetyTextResource);
        this.setTolerances(inputView, validator);
    }

    public void setTolerances(InputView inputView, SafetyChangeListener listener) {
        if (this.tolerances == null) {
            this.eventManager.addWeakListener((Object)inputView, SafetyChangeListener.class, (Object)listener);
        } else {
            listener.safetyTolerancesReceived(this.tolerances);
        }
    }

    private static abstract class BaseDisplacementValidationStrategyProxy
    extends SafetyChangeListener.Template {
        private final UnitsConverter metricConverter = Units.getMetersConverter();
        protected final InputView inputView;
        protected final SafetyTextResource text;
        private final ValidationStrategyProxy errorStrategy = new ValidationStrategyProxy();

        protected BaseDisplacementValidationStrategyProxy(InputView inputView, SafetyTextResource text) {
            this.inputView = inputView;
            this.text = text;
            if (Settings.getUnits() == UnitType.METRIC) {
                inputView.setErrorValidationStrategy(new ValidationStrategy[]{new ValidationStrategy.Composite(new ValidationStrategy[]{ValidationFactory.getWholeNumberValidator(), this.errorStrategy})});
                inputView.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#"));
                inputView.setMode(Mode.WholeNumbers);
                inputView.setWarningValidationStrategy(new ValidationStrategy[]{ValidationStrategy.ALWAYS_VALID});
            } else {
                inputView.setErrorValidationStrategy(new ValidationStrategy[]{new ValidationStrategy.Composite(new ValidationStrategy[]{ValidationFactory.getNumberValidator(), this.errorStrategy})});
                inputView.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#.##"));
                inputView.setMode(Mode.Standard);
                inputView.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getDecimalPlacesValidator((int)2)});
            }
            ValidationStrategyProxy warningStrategy = new ValidationStrategyProxy();
            inputView.setWarningValidationStrategy(new ValidationStrategy[]{warningStrategy});
        }

        protected void setToleranceValidation(double boundaryPlaneTolerance) {
            String boundaryTolerance = Settings.getUnits() == UnitType.METRIC ? " " + this.text.minusToleranceNoDecimals(this.metricConverter.convertFrom(boundaryPlaneTolerance), this.metricConverter.getUnit()) : " " + this.text.minusTolerance(this.metricConverter.convertFrom(boundaryPlaneTolerance), this.metricConverter.getUnit());
            this.inputView.setUnit(boundaryTolerance);
            double min = -5.0;
            double max = 5.0;
            this.errorStrategy.setValidaStrategy(ValidationFactory.getRangeValidator((double)min, (double)max, (UnitsConverter)this.metricConverter));
            String limits = null;
            limits = Settings.getUnits().isUS() ? this.text.minimumAndMaximumValuesTo3Decimals(this.metricConverter.convertFrom(min), this.metricConverter.convertFrom(max), this.metricConverter.getUnit()) : this.text.minimumAndMaximumValues(this.metricConverter.convertFrom(min), this.metricConverter.convertFrom(max), this.metricConverter.getUnit());
            this.inputView.setRestrictionsText(limits);
        }
    }

    private static class PlaneDisplacementValidationStrategyProxy
    extends BaseDisplacementValidationStrategyProxy {
        public PlaneDisplacementValidationStrategyProxy(InputView inputView, SafetyTextResource text) {
            super(inputView, text);
        }

        @Override
        public void safetyTolerancesReceived(SafetyComplianceTolerances tolerances) {
            this.setToleranceValidation(tolerances.getToolPositionTolerance());
        }
    }

    private static class TriggerDisplacementValidationStrategyProxy
    extends BaseDisplacementValidationStrategyProxy {
        public TriggerDisplacementValidationStrategyProxy(InputView inputView, SafetyTextResource text) {
            super(inputView, text);
        }

        @Override
        public void safetyTolerancesReceived(SafetyComplianceTolerances tolerances) {
            this.setToleranceValidation(tolerances.getTriggerToolPositionTolerance());
        }
    }
}

