/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.externalapi;

import com.ur.math.Length;
import com.ur.monitor.model.Pose6d;
import com.ur.monitor.model.Sphere;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.safety.position.ElbowPosition;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.boundaries.core.BoundaryPlane;
import com.ur.safety.boundaries.externalapi.BoundaryPlaneDistanceStrategy;
import com.ur.safety.boundaries.externalapi.BoundaryPlaneProximitySource;
import com.ur.safety.workpiece.core.WorkpieceConfiguration;
import com.ur.util.Optional;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class BoundaryPlaneDistanceStrategyImpl
implements BoundaryPlaneDistanceStrategy {
    private final SafetySettingsLookupService safetyLookup;
    private final Provider<ElbowPosition> latestElbowPosition;

    @Inject
    BoundaryPlaneDistanceStrategyImpl(SafetySettingsLookupService safetyLookup, Provider<ElbowPosition> latestElbowPosition) {
        this.safetyLookup = safetyLookup;
        this.latestElbowPosition = latestElbowPosition;
    }

    @Override
    public Length getDistance(BoundaryPlane plane, BoundaryPlaneProximitySource source, Pose6d tcpPose, Pose6d tcpOffset) {
        switch (source) {
            case TOOL: {
                return this.getSignedDistanceForTool(plane, tcpPose, tcpOffset);
            }
            case ELBOW: {
                return this.getSignedDistanceForElbow(plane);
            }
        }
        throw new IllegalArgumentException("Unknown plane proximity source: " + (Object)((Object)source));
    }

    private Length getSignedDistanceForTool(BoundaryPlane plane, Pose6d tcpPose, Pose6d tcpOffset) {
        Length result = Length.INFINITE;
        Optional<WorkpieceConfiguration> workpieceConfiguration = this.safetyLookup.getControllerComponent(WorkpieceConfiguration.class);
        if (!workpieceConfiguration.isPresent()) {
            return result;
        }
        BoundaryPlane.FlangeExtension flangeExtension = plane.getExtension(BoundaryPlane.FlangeExtension.class);
        List<Sphere> spheresToCheck = flangeExtension.isFlangeRestricted() ? ((WorkpieceConfiguration)workpieceConfiguration.get()).getDefinedToolSpheres() : ((WorkpieceConfiguration)workpieceConfiguration.get()).getToolSpheresForToolPositions();
        for (Sphere each : spheresToCheck) {
            Pose6d sphereCenter = Pose6dTransformUtils.getPoseWithModifiedOffset((Pose6d)tcpPose, (Pose6d)tcpOffset, (Pose6d)new Pose6d((Tuple3d)each.center.toVector3d(), (Tuple3d)new Vector3d()));
            Length distance = this.calculateVisualizationDistance(plane, new Sphere(Vector3.fromVector3d((Vector3d)sphereCenter.getPos()), each.radius));
            result = Length.min((Length)result, (Length)distance);
        }
        return result;
    }

    private Length getSignedDistanceForElbow(BoundaryPlane plane) {
        BoundaryPlane.ElbowExtension elbowExtension = plane.getExtension(BoundaryPlane.ElbowExtension.class);
        if (elbowExtension.isElbowRestricted()) {
            ElbowPosition elbowPosition = (ElbowPosition)this.latestElbowPosition.get();
            Sphere elbowSphere = new Sphere(elbowPosition.getPosition(), elbowPosition.getRadius());
            return this.calculateVisualizationDistance(plane, elbowSphere);
        }
        return Length.INFINITE;
    }

    private Length calculateVisualizationDistance(BoundaryPlane plane, Sphere sphere) {
        Length signedDistanceOfCenter = plane.getPlaneParameters().getSignedDistance(sphere.center);
        if (plane.isTrigger()) {
            Length absoluteDistanceOfCenter = signedDistanceOfCenter.abs();
            if (absoluteDistanceOfCenter.isLessThanOrEqualTo(sphere.radius)) {
                return Length.ZERO;
            }
            return absoluteDistanceOfCenter.minus(sphere.radius);
        }
        return signedDistanceOfCenter.minus(sphere.radius);
    }
}

