/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.externalapi;

import com.ur.lang.HashCodeBuilder;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.safety.SafetyLimitMode;
import java.util.Objects;

public class BoundaryPlaneProperties {
    private final String name;
    private final GeomFeature feature;
    private final SafetyLimitMode safetyLimitMode;
    private final double displacement;
    private final boolean elbowChecked;
    private final boolean flangeChecked;

    public BoundaryPlaneProperties(String name, GeomFeature feature, SafetyLimitMode safetyLimitMode, double displacement, boolean elbowChecked, boolean flangeChecked) {
        this.name = name;
        this.feature = feature;
        this.safetyLimitMode = safetyLimitMode;
        this.displacement = displacement;
        this.elbowChecked = elbowChecked;
        this.flangeChecked = flangeChecked;
    }

    public String getName() {
        return this.name;
    }

    public GeomFeature getFeature() {
        return this.feature;
    }

    public SafetyLimitMode getSafetyLimitMode() {
        return this.safetyLimitMode;
    }

    public double getDisplacement() {
        return this.displacement;
    }

    public boolean isElbowChecked() {
        return this.elbowChecked;
    }

    public boolean isFlangeChecked() {
        return this.flangeChecked;
    }

    public int hashCode() {
        return new HashCodeBuilder(URMath.HASH_CODE_PRECISION).append((Object)this.name).append((Object)this.feature).append((Object)this.safetyLimitMode).append(this.displacement).append(this.elbowChecked).append(this.flangeChecked).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundaryPlaneProperties that = (BoundaryPlaneProperties)o;
        return Objects.equals(this.name, that.getName()) && Objects.equals(Objects.nonNull(this.feature) ? this.feature.toString() : "", Objects.nonNull(that.getFeature()) ? that.getFeature().toString() : "") && Objects.equals((Object)this.safetyLimitMode, (Object)that.getSafetyLimitMode()) && Objects.equals(this.displacement, that.getDisplacement()) && Objects.equals(this.elbowChecked, that.isElbowChecked()) && Objects.equals(this.flangeChecked, that.isFlangeChecked());
    }
}

