/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.externalapi;

import com.ur.lang.EqualsUtil;
import com.ur.math.Length;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.boundaries.core.BoundaryPlane;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.boundaries.externalapi.BoundaryPlaneDistanceStrategy;
import com.ur.safety.boundaries.externalapi.BoundaryPlaneProximitySource;
import javax.inject.Inject;

public class BoundaryPlaneVisualizationStrategy {
    static final Length CLOSE_PROXIMITY_DISTANCE = Length.from((double)0.01, (Length.Unit)Length.Unit.M);
    static final Length SOMEWHAT_CLOSE_PROXIMITY_DISTANCE = Length.from((double)0.1, (Length.Unit)Length.Unit.M);
    private final SafetySettingsLookupService safetyLookup;
    private final BoundaryPlaneDistanceStrategy distanceStrategy;

    @Inject
    BoundaryPlaneVisualizationStrategy(SafetySettingsLookupService safetyLookup, BoundaryPlaneDistanceStrategy distanceStrategy) {
        this.safetyLookup = safetyLookup;
        this.distanceStrategy = distanceStrategy;
    }

    public PlaneProximity getLimitProximity(SafetyBoundaries safetyBoundaries, Pose6d tcpPose, Pose6d tcpOffset) {
        PlaneProximity result = PlaneProximity.WELL_WITHIN_THE_LIMIT;
        BoundaryPlaneProximitySource[] boundaryPlaneProximitySourceArray = BoundaryPlaneProximitySource.values();
        int n = boundaryPlaneProximitySourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            BoundaryPlaneProximitySource each = boundaryPlaneProximitySourceArray[n2];
            PlaneProximity sourceProximity = this.getLimitProximity(safetyBoundaries, each, tcpPose, tcpOffset);
            result = PlaneProximity.closest(result, sourceProximity);
            ++n2;
        }
        return result;
    }

    public PlaneProximity getLimitProximity(SafetyBoundaries safetyBoundaries, BoundaryPlaneProximitySource source, Pose6d tcpPose, Pose6d tcpOffset) {
        PlaneProximity result = PlaneProximity.WELL_WITHIN_THE_LIMIT;
        BoundaryPlane[] boundaryPlaneArray = safetyBoundaries.getBoundaryPlanes();
        int n = boundaryPlaneArray.length;
        int n2 = 0;
        while (n2 < n) {
            BoundaryPlane each = boundaryPlaneArray[n2];
            PlaneProximity planeProximity = this.getLimitProximity(each, source, tcpPose, tcpOffset);
            result = PlaneProximity.closest(result, planeProximity);
            ++n2;
        }
        return result;
    }

    public PlaneProximity getLimitProximity(BoundaryPlane plane, Pose6d tcpPose, Pose6d tcpOffset) {
        PlaneProximity result = PlaneProximity.WELL_WITHIN_THE_LIMIT;
        BoundaryPlaneProximitySource[] boundaryPlaneProximitySourceArray = BoundaryPlaneProximitySource.values();
        int n = boundaryPlaneProximitySourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            BoundaryPlaneProximitySource each = boundaryPlaneProximitySourceArray[n2];
            PlaneProximity sourceProximity = this.getLimitProximity(plane, each, tcpPose, tcpOffset);
            result = PlaneProximity.closest(result, sourceProximity);
            ++n2;
        }
        return result;
    }

    private PlaneProximity getLimitProximity(BoundaryPlane plane, BoundaryPlaneProximitySource source, Pose6d tcpPose, Pose6d tcpOffset) {
        if (plane.isUndefined() || !this.shouldLimitBeVisualized(plane)) {
            return PlaneProximity.WELL_WITHIN_THE_LIMIT;
        }
        Length criticalProximityDistance = Length.from((double)(2.0 * this.safetyLookup.getSafetyComplianceTolerances().getToolPositionTolerance()), (Length.Unit)Length.Unit.M);
        Length planeDistance = this.distanceStrategy.getDistance(plane, source, tcpPose, tcpOffset);
        if (planeDistance.isLessThanOrEqualTo(Length.ZERO)) {
            return PlaneProximity.LIMIT_VIOLATED;
        }
        if (planeDistance.isLessThanOrEqualTo(criticalProximityDistance) && !plane.isTrigger()) {
            return PlaneProximity.CRITICALLY_CLOSE_TO_LIMIT;
        }
        if (planeDistance.isLessThanOrEqualTo(CLOSE_PROXIMITY_DISTANCE)) {
            return PlaneProximity.CLOSE_TO_LIMIT;
        }
        if (planeDistance.isLessThanOrEqualTo(SOMEWHAT_CLOSE_PROXIMITY_DISTANCE)) {
            return PlaneProximity.SOMEWHAT_CLOSE_TO_LIMIT;
        }
        return PlaneProximity.WELL_WITHIN_THE_LIMIT;
    }

    private boolean shouldLimitBeVisualized(BoundaryPlane boundaryPlane) {
        SafetyLimitMode mode = boundaryPlane.getSafetyMode();
        return SafetySetup.isReducedModeEnabled() ? EqualsUtil.equalsOneOf((Object)((Object)mode), (Object[])new SafetyLimitMode[]{SafetyLimitMode.REDUCED, SafetyLimitMode.TRIGGER, SafetyLimitMode.BOTH}) : EqualsUtil.notEqualsOneOf((Object)((Object)mode), (Object[])new SafetyLimitMode[]{SafetyLimitMode.DISABLED, SafetyLimitMode.REDUCED});
    }

    public static enum PlaneProximity {
        LIMIT_VIOLATED,
        CRITICALLY_CLOSE_TO_LIMIT,
        CLOSE_TO_LIMIT,
        SOMEWHAT_CLOSE_TO_LIMIT,
        WELL_WITHIN_THE_LIMIT;


        public static PlaneProximity closest(PlaneProximity first, PlaneProximity second) {
            return first.ordinal() <= second.ordinal() ? first : second;
        }
    }
}

