/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.externalapi;

import com.ur.lang.EqualsUtil;
import com.ur.monitor.model.Pose6d;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.boundaries.core.ToolOrientationLimit;
import com.ur.safety.tolerances.SafetyComplianceTolerances;
import com.ur.safety.workpiece.core.SphericalUnitVector;
import com.ur.safety.workpiece.core.WorkpieceConfiguration;
import javax.inject.Inject;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public interface ToolOrientationVisualizationStrategy {
    public Pose6d getToolOrientationLimitPose(SafetySetup var1, Pose6d var2, Pose6d var3);

    public OrientationLimitProximity getLimitProximity(SafetySetup var1, Pose6d var2, Pose6d var3);

    public static enum OrientationLimitProximity {
        LIMIT_VIOLATED,
        CRITICALLY_CLOSE_TO_LIMIT,
        CLOSE_TO_LIMIT,
        SOMEWHAT_CLOSE_TO_LIMIT,
        WELL_WITHIN_THE_LIMIT;

    }

    public static abstract class Template
    implements ToolOrientationVisualizationStrategy {
        private static final double CLOSE_ORIENTATION_ANGLE = Math.toRadians(5.0);
        private static final double SOMEWHAT_CLOSE_ORIENTATION_ANGLE = Math.toRadians(8.0);
        private final SafetySettingsLookupService safetyTolerancesLookup;

        Template(SafetySettingsLookupService safetyTolerancesLookup) {
            this.safetyTolerancesLookup = safetyTolerancesLookup;
        }

        @Override
        public OrientationLimitProximity getLimitProximity(SafetySetup safetySetup, Pose6d tcpPose, Pose6d tcpOffset) {
            if (safetySetup == null) {
                return OrientationLimitProximity.WELL_WITHIN_THE_LIMIT;
            }
            ToolOrientationLimit limit = ((SafetyBoundaries)safetySetup.getComponent(SafetyBoundaries.class)).getToolOrientationLimit();
            if (!this.shouldLimitBeVisualized(limit)) {
                return OrientationLimitProximity.WELL_WITHIN_THE_LIMIT;
            }
            SafetyComplianceTolerances tolerances = this.safetyTolerancesLookup.getSafetyComplianceTolerances();
            double tcpOrientationCriticalProximityThreshold = 2.0 * tolerances.getToolOrientationTolerance();
            double minLimitCloseness = this.getAngleToLimit(safetySetup, tcpPose, tcpOffset);
            if (minLimitCloseness < 0.0) {
                return OrientationLimitProximity.LIMIT_VIOLATED;
            }
            if (minLimitCloseness < tcpOrientationCriticalProximityThreshold) {
                return OrientationLimitProximity.CRITICALLY_CLOSE_TO_LIMIT;
            }
            if (minLimitCloseness < CLOSE_ORIENTATION_ANGLE) {
                return OrientationLimitProximity.CLOSE_TO_LIMIT;
            }
            if (minLimitCloseness < SOMEWHAT_CLOSE_ORIENTATION_ANGLE) {
                return OrientationLimitProximity.SOMEWHAT_CLOSE_TO_LIMIT;
            }
            return OrientationLimitProximity.WELL_WITHIN_THE_LIMIT;
        }

        protected abstract double getAngleToLimit(SafetySetup var1, Pose6d var2, Pose6d var3);

        private boolean shouldLimitBeVisualized(ToolOrientationLimit limit) {
            return SafetySetup.isReducedModeEnabled() ? EqualsUtil.equalsOneOf((Object)((Object)limit.getSafetyMode()), (Object[])new SafetyLimitMode[]{SafetyLimitMode.REDUCED, SafetyLimitMode.TRIGGER, SafetyLimitMode.BOTH}) : EqualsUtil.notEqualsOneOf((Object)((Object)limit.getSafetyMode()), (Object[])new SafetyLimitMode[]{SafetyLimitMode.DISABLED, SafetyLimitMode.REDUCED});
        }
    }

    public static class ToolOrientationVisualizationStrategyImpl
    extends Template {
        @Inject
        public ToolOrientationVisualizationStrategyImpl(SafetySettingsLookupService tolerancesLookup) {
            super(tolerancesLookup);
        }

        @Override
        public Pose6d getToolOrientationLimitPose(SafetySetup safetySetup, Pose6d tcpPose, Pose6d tcpOffset) {
            SphericalUnitVector toolDirection = ((WorkpieceConfiguration)safetySetup.getComponent(WorkpieceConfiguration.class)).getToolOrientation().sphericalDirection;
            Vector3 rotationVector = URMath.getRotationVectorForZAxis((Vector3)toolDirection.asVector3());
            return Pose6dTransformUtils.getPoseWithModifiedOffset((Pose6d)tcpPose, (Pose6d)tcpOffset, (Pose6d)new Pose6d((Tuple3d)new Vector3d(), (Tuple3d)rotationVector.toVector3d()));
        }

        @Override
        protected double getAngleToLimit(SafetySetup safetySetup, Pose6d toolPose, Pose6d tcpOffset) {
            ToolOrientationLimit limit = ((SafetyBoundaries)safetySetup.getComponent(SafetyBoundaries.class)).getToolOrientationLimit();
            Pose6d toolDirectionAsPose = this.getToolOrientationLimitPose(safetySetup, toolPose, tcpOffset);
            return limit.getLimitCloseness(toolDirectionAsPose.getRot());
        }
    }
}

